/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoElement;
import freenet.crypt.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class DSASignature
implements CryptoElement,
Serializable {
    private final BigInteger r;
    private final BigInteger s;

    public DSASignature(InputStream in) throws IOException {
        this.r = Util.readMPI(in);
        this.s = Util.readMPI(in);
    }

    public DSASignature(String sig) throws NumberFormatException {
        int x = sig.indexOf(44);
        if (x <= 0) {
            throw new NumberFormatException("DSA Signatures have two values");
        }
        this.r = new BigInteger(sig.substring(0, x), 16);
        this.s = new BigInteger(sig.substring(x + 1), 16);
    }

    public static DSASignature read(InputStream in) throws IOException {
        BigInteger r = Util.readMPI(in);
        BigInteger s = Util.readMPI(in);
        return new DSASignature(r, s);
    }

    public void write(OutputStream o) throws IOException {
        Util.writeMPI(this.r, o);
        Util.writeMPI(this.s, o);
    }

    public String writeAsField() {
        return this.toString();
    }

    public DSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public String toString() {
        return this.r.toString(16) + "," + this.s.toString(16);
    }
}

