/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Digest;
import freenet.crypt.DigestFactory;
import freenet.support.Bucket;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public class ProgressiveHashOutputStream
extends OutputStream {
    private Bucket b;
    private OutputStream out;
    private boolean closed = false;
    private DigestFactory df;
    private Digest ctx;
    private Stack digests;
    private int digSize;
    private long partSize;
    private long written = 0L;
    private long totalLength = -1L;
    private byte[] initialDigest;
    private Stack dvals;

    public ProgressiveHashOutputStream(long partSize, DigestFactory df, Bucket b) throws IOException {
        if (partSize <= 0L) {
            throw new IllegalArgumentException("partSize must be > 0");
        }
        b.resetWrite();
        this.b = b;
        this.out = new BufferedOutputStream(b.getOutputStream());
        this.df = df;
        this.ctx = df.getInstance();
        this.partSize = partSize;
        this.digests = new Stack();
        this.digSize = this.ctx.digestSize() >> 3;
    }

    public void write(int i) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (this.written == this.partSize) {
            this.nextDigest();
        }
        this.out.write(i);
        this.ctx.update((byte)i);
        ++this.written;
    }

    public void write(byte[] b, int off, int length) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        while (length > 0) {
            int chunk = (int)Math.min((long)length, this.partSize - this.written);
            if (chunk == 0) {
                this.nextDigest();
                continue;
            }
            this.out.write(b, off, chunk);
            this.ctx.update(b, off, chunk);
            this.written += (long)chunk;
            off += chunk;
            length -= chunk;
        }
    }

    private void nextDigest() {
        this.digests.push(this.ctx);
        this.ctx = this.df.getInstance();
        this.written = 0L;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.out.close();
        this.closed = true;
        this.dvals = new Stack();
        while (!this.digests.empty()) {
            byte[] dval = this.ctx.digest();
            this.ctx = (Digest)this.digests.pop();
            this.ctx.update(dval);
            this.dvals.push(dval);
        }
        this.initialDigest = this.ctx.digest();
        int parts = (int)((this.b.size() - 1L) / this.partSize);
        long lastPart = this.b.size() - (long)parts * this.partSize;
        this.totalLength = (long)parts * (this.partSize + 21L) + lastPart + 1L;
    }

    public byte[] getInitialDigest() {
        return this.initialDigest;
    }

    public long getLength() {
        return this.totalLength;
    }

    public InputStream getInputStream() throws IOException {
        return this.closed ? new InterleaveInputStream(this.b.getInputStream(), this.b.size()) : null;
    }

    protected class InterleaveInputStream
    extends FilterInputStream {
        private byte[] digestBuf;
        private long pos;
        private long length;

        public InterleaveInputStream(InputStream in, long length) throws IOException {
            super(in);
            this.length = length;
            this.pos = 0L;
            this.digestBuf = new byte[ProgressiveHashOutputStream.this.digSize + 1];
            this.digestBuf[((ProgressiveHashOutputStream)ProgressiveHashOutputStream.this).digSize] = 0;
        }

        public int read() throws IOException {
            if (this.pos > 0L && (this.pos == ProgressiveHashOutputStream.this.partSize || this.length == 0L)) {
                this.next();
            }
            if (this.pos < 0L) {
                return this.digestBuf[this.digestBuf.length + (int)this.pos++] & 0xFF;
            }
            if (this.length == 0L) {
                return -1;
            }
            int ret = this.in.read();
            if (ret != -1) {
                ++this.pos;
                --this.length;
            }
            return ret;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len <= 0) {
                return 0;
            }
            if (this.pos > 0L && (this.pos == ProgressiveHashOutputStream.this.partSize || this.length == 0L)) {
                this.next();
            }
            if (this.pos < 0L) {
                int n = Math.min(len, 0 - (int)this.pos);
                System.arraycopy(this.digestBuf, this.digestBuf.length + (int)this.pos, b, off, n);
                this.pos += (long)n;
                return n;
            }
            if (this.length == 0L) {
                return -1;
            }
            len = (int)Math.min((long)len, Math.min(ProgressiveHashOutputStream.this.partSize - this.pos, this.length));
            int n = this.in.read(b, off, len);
            this.pos += (long)n;
            this.length -= (long)n;
            return n;
        }

        private void next() {
            if (!ProgressiveHashOutputStream.this.dvals.empty()) {
                System.arraycopy((byte[])ProgressiveHashOutputStream.this.dvals.pop(), 0, this.digestBuf, 0, ProgressiveHashOutputStream.this.digSize);
                this.pos = -1 - ProgressiveHashOutputStream.this.digSize;
            } else {
                this.pos = -1L;
            }
        }

        public int available() throws IOException {
            return this.pos < 0L ? 0 - (int)this.pos : (int)Math.min((long)super.available(), ProgressiveHashOutputStream.this.partSize - this.pos);
        }
    }
}

