/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.Key;
import freenet.KeyException;
import freenet.Storables;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.io.DataNotValidIOException;
import freenet.support.io.VerifyingInputStream;
import java.io.InputStream;

public class CHK
extends Key {
    public static int keyNumber = 770;

    public CHK(byte[] keyval) throws KeyException {
        super(keyval);
        if (this.val.length != 23 || (this.val[21] & 0xFF) != (keyNumber >> 8 & 0xFF) || (this.val[22] & 0xFF) != (keyNumber & 0xFF)) {
            throw new KeyException("Byte array does not contain a CHK");
        }
    }

    public CHK(Storables storables, int log2size) throws KeyException {
        super(20, log2size, keyNumber);
        if (!storables.isLegalForCHK()) {
            throw new KeyException("illegal Storables");
        }
        Digest ctx = SHA1.getInstance();
        storables.hashUpdate(ctx);
        System.arraycopy(ctx.digest(), 0, this.val, 0, 20);
    }

    public VerifyingInputStream verifyStream(InputStream data, Storables storables, long transLength) throws DataNotValidIOException {
        if (!storables.isLegalForCHK()) {
            throw new DataNotValidIOException(132);
        }
        byte log2size = this.val[20];
        long partSize = storables.getPartSize();
        long dataLength = CHK.getDataLength(transLength, partSize);
        if (log2size < 10 || log2size > 62 || (long)(1 << log2size) != dataLength || partSize != CHK.getPartSize(dataLength)) {
            throw new DataNotValidIOException(132);
        }
        Digest ctx = SHA1.getInstance();
        storables.hashUpdate(ctx);
        if (!Util.byteArrayEqual(ctx.digest(), this.val, 0, 20)) {
            throw new DataNotValidIOException(132);
        }
        return super.verifyStream(data, storables, transLength);
    }
}

