/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import fecimpl.FECUtils;
import fecimpl.OnionFECBase;
import freenet.client.FECEncoder;
import freenet.support.Bucket;
import freenet.support.StripedBucketArray2;
import java.io.IOException;
import java.util.logging.Logger;

public class OnionFECEncoder
extends OnionFECBase
implements FECEncoder {
    private static Logger logger = Logger.getLogger(OnionFECEncoder.class.getName());
    protected static final String DEFAULT_NAME = "OnionFEC_a_1_2";
    protected static final int DEFAULT_NUM = 1;
    protected static final int DEFAULT_DENOM = 2;

    public OnionFECEncoder() {
        this(DEFAULT_NAME, 1, 2);
    }

    protected OnionFECEncoder(String name, int redundancyNum, int redundancyDenom) {
        super(name, redundancyNum, redundancyDenom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket[] encode(int segmentNumber, Bucket[] blocks, int[] requested) throws IOException {
        Bucket[] ret;
        block13: {
            if (this.code == null) {
                throw new IllegalStateException("Not initialized");
            }
            this.setSegment(segmentNumber);
            int l = this.n - this.k;
            int i = 0;
            if (requested == null) {
                requested = new int[l];
                for (i = 0; i < l; ++i) {
                    requested[i] = this.k + i;
                }
            }
            if (requested.length == 0 || requested.length > l) {
                throw new IllegalArgumentException("You asked for ridiculous check block indices.");
            }
            for (i = 0; i < requested.length; ++i) {
                if (requested[i] >= this.k && requested[i] < this.n) continue;
                throw new IllegalArgumentException("You asked for ridiculous check block indices.");
            }
            ret = null;
            Bucket[] checkBlocks = FECUtils.makeBuckets(this.bucketFactory, requested.length, this.blockSize, false);
            try {
                if (this.stripeWidth == -1) {
                    FECUtils.encode(this.code, this.n, this.k, blocks, checkBlocks, requested);
                    ret = checkBlocks;
                    checkBlocks = null;
                    break block13;
                }
                StripedBucketArray2 dataArray = new StripedBucketArray2();
                StripedBucketArray2 checkArray = new StripedBucketArray2();
                try {
                    int stripeCount = this.blockSize / this.stripeWidth;
                    Bucket[] dataStripe = dataArray.allocate(blocks);
                    Bucket[] checkStripe = checkArray.allocate(checkBlocks);
                    for (i = 0; i < stripeCount; ++i) {
                        logger.fine("Encoding stripe: " + i + " [" + this.stripeWidth + "]");
                        dataArray.setRange(i * this.stripeWidth, this.stripeWidth);
                        checkArray.setRange(i * this.stripeWidth, this.stripeWidth);
                        FECUtils.encode(this.code, this.n, this.k, dataStripe, checkStripe, requested);
                    }
                    ret = checkBlocks;
                    checkBlocks = null;
                }
                finally {
                    dataArray.release();
                    checkArray.release();
                }
            }
            finally {
                FECUtils.freeBuckets(this.bucketFactory, checkBlocks);
            }
        }
        return ret;
    }
}

