/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ArrayBucket
implements Bucket {
    private Vector data = new Vector();
    private boolean reset;
    private String name;

    public ArrayBucket() {
        this("ArrayBucket");
    }

    public ArrayBucket(byte[] initdata) {
        this("ArrayBucket");
        this.data.addElement(initdata);
    }

    public ArrayBucket(String name) {
        this.name = name;
    }

    public OutputStream getOutputStream() {
        return new ArrayBucketOutputStream(this.reset);
    }

    public InputStream getInputStream() {
        return new ArrayBucketInputStream();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            byte[] b = (byte[])e.nextElement();
            s.append(new String(b));
        }
        return new String(s);
    }

    public void read(InputStream in) throws IOException {
        int i;
        ArrayBucketOutputStream out = new ArrayBucketOutputStream(this.reset);
        byte[] b = new byte[65535];
        while ((i = in.read(b)) != -1) {
            ((OutputStream)out).write(b, 0, i);
        }
        ((OutputStream)out).close();
    }

    public long size() {
        long size = 0L;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            byte[] b = (byte[])e.nextElement();
            size += (long)b.length;
        }
        return size;
    }

    public String getName() {
        return this.name;
    }

    public void resetWrite() {
        this.reset = true;
    }

    private class ArrayBucketInputStream
    extends InputStream {
        Enumeration e;
        ByteArrayInputStream in;

        public ArrayBucketInputStream() {
            this.e = ArrayBucket.this.data.elements();
        }

        public int read() {
            return this.priv_read();
        }

        private int priv_read() {
            int i;
            if (this.in == null) {
                if (this.e.hasMoreElements()) {
                    this.in = new ByteArrayInputStream((byte[])this.e.nextElement());
                } else {
                    return -1;
                }
            }
            if ((i = this.in.read()) == -1) {
                this.in = null;
                return this.priv_read();
            }
            return i;
        }

        public int read(byte[] b) {
            return this.priv_read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            return this.priv_read(b, off, len);
        }

        private int priv_read(byte[] b, int off, int len) {
            int i;
            if (this.in == null) {
                if (this.e.hasMoreElements()) {
                    this.in = new ByteArrayInputStream((byte[])this.e.nextElement());
                } else {
                    return -1;
                }
            }
            if ((i = this.in.read(b, off, len)) == -1) {
                this.in = null;
                return this.priv_read(b, off, len);
            }
            return i;
        }

        public int available() {
            if (this.in == null) {
                if (this.e.hasMoreElements()) {
                    this.in = new ByteArrayInputStream((byte[])this.e.nextElement());
                } else {
                    return 0;
                }
            }
            return this.in.available();
        }
    }

    private class ArrayBucketOutputStream
    extends ByteArrayOutputStream {
        boolean reset;
        boolean done = false;

        public ArrayBucketOutputStream(boolean reset) {
            this.reset = reset;
        }

        public void close() {
            this.done = true;
            if (this.reset) {
                ArrayBucket.this.data.removeAllElements();
                ArrayBucket.this.data.trimToSize();
            }
            this.reset = false;
            ArrayBucket.this.data.addElement(this.toByteArray());
        }
    }
}

