/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class RandomAccessFileBucket2
implements Bucket {
    RandomAccessFile raf = null;
    private File file = null;
    private long offset = -1L;
    private long localOffset = 0L;
    private long len = -1L;
    private boolean readOnly = false;
    private boolean released = false;
    private final Vector streams = new Vector();

    public RandomAccessFileBucket2(File file, long offset, long len, boolean readOnly, RandomAccessFile r) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Can't read file: " + file.getAbsolutePath());
        }
        if (!file.canWrite() && !readOnly) {
            throw new IOException("Can't write to file: " + file.getAbsolutePath());
        }
        this.file = file;
        this.readOnly = readOnly;
        this.raf = r;
        this.setRange(offset, len);
    }

    public synchronized void setRange(long offset, long len) throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        if (this.streams.size() > 0) {
            throw new IllegalStateException("Can't reset range.  There are open streams.");
        }
        if (offset < 0L || len < 0L) {
            throw new IllegalArgumentException("Bad range arguments.");
        }
        if (offset + len > this.file.length()) {
            len = this.file.length() - offset;
        }
        this.offset = offset;
        this.len = len;
        this.localOffset = 0L;
    }

    public final synchronized Range getRange() {
        return new Range(this.offset, this.len);
    }

    public final synchronized boolean hasOpenStreams() {
        return this.streams.size() > 0;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        RAInputStream newIn = new RAInputStream(this, this.file.getAbsolutePath());
        this.streams.addElement(newIn);
        return newIn;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isReleased()) {
            throw new IOException("Attempt to use a released RandomAccessBucket: " + this.getName());
        }
        if (this.readOnly) {
            throw new IOException("Tried to write a read-only Bucket.");
        }
        RAOutputStream newOut = new RAOutputStream(this, this.file.getAbsolutePath());
        this.streams.addElement(newOut);
        return newOut;
    }

    public String getName() {
        return this.file.getAbsolutePath() + " [" + this.offset + ", " + (this.offset + this.len - 1L) + "]";
    }

    public synchronized void resetWrite() {
        if (this.isReleased()) {
            throw new RuntimeException("Attempt to use a released RandomAccessFileBucket: " + this.getName());
        }
        this.localOffset = 0L;
    }

    public long size() {
        return this.len;
    }

    public synchronized boolean release() {
        if (this.released) {
            return true;
        }
        for (int i = 0; i < this.streams.size(); ++i) {
            try {
                if (this.streams.elementAt(i) instanceof InputStream) {
                    ((InputStream)this.streams.elementAt(i)).close();
                    continue;
                }
                if (!(this.streams.elementAt(i) instanceof OutputStream)) continue;
                ((OutputStream)this.streams.elementAt(i)).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.streams.removeAllElements();
        this.streams.trimToSize();
        this.released = true;
        return true;
    }

    public final synchronized boolean isReleased() {
        return this.released;
    }

    public void finalize() throws Throwable {
        if (!this.released) {
            this.release();
        }
    }

    public static Bucket[] segment(File file, int blockSize, long offset, int blocks, boolean readOnly, RandomAccessFile r) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Can't read file: " + file.getAbsolutePath());
        }
        if (!file.canWrite() && !readOnly) {
            throw new IOException("Can't write to file: " + file.getAbsolutePath());
        }
        if (offset < 0L || offset >= file.length() - 1L) {
            throw new IllegalArgumentException("offset: " + offset);
        }
        long length = file.length() - offset;
        int nBlocks = (int)(length / (long)blockSize);
        if (length % (long)blockSize != 0L) {
            ++nBlocks;
        }
        if (blocks == -1) {
            blocks = nBlocks;
        } else if (blocks > nBlocks || blocks < 1) {
            throw new IllegalArgumentException("blocks: " + blocks + "; nBlocks: " + nBlocks + "; blockSize: " + blockSize + "; offset: " + offset + "; fileLen: " + file.length() + "; length: " + length);
        }
        Bucket[] ret = new Bucket[blocks];
        for (int i = 0; i < blocks; ++i) {
            long localOffset = (long)(i * blockSize) + offset;
            int blockLen = blockSize;
            if (i == nBlocks - 1) {
                blockLen = (int)(length - (long)((nBlocks - 1) * blockSize));
            }
            ret[i] = new RandomAccessFileBucket2(file, localOffset, blockLen, readOnly, r);
        }
        return ret;
    }

    private class RAOutputStream
    extends OutputStream {
        private RandomAccessFileBucket2 rafb = null;
        private final String prefix = "";

        public RAOutputStream(RandomAccessFileBucket2 rafb, String pref) throws IOException {
            this.rafb = rafb;
            RandomAccessFileBucket2.this.raf.seek(rafb.offset + rafb.localOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                int nAvailable = this.bytesLeft();
                if (nAvailable < 1) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                RandomAccessFileBucket2.this.raf.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                int nAvailable = this.bytesLeft();
                if (nAvailable < buf.length) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                RandomAccessFileBucket2.this.raf.write(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int off, int tlen) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                int nAvailable = this.bytesLeft();
                if (nAvailable < tlen) {
                    throw new IOException("Attempt to write past end of Bucket.");
                }
                RandomAccessFileBucket2.this.raf.write(buf, off, tlen);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                this.checkValid();
                if (this.rafb.streams.contains(this)) {
                    this.rafb.streams.removeElement(this);
                }
                this.rafb.streams.trimToSize();
                long added = RandomAccessFileBucket2.this.raf.getFilePointer() - this.rafb.offset;
                if (added > 0L) {
                    this.rafb.localOffset = added;
                }
            }
        }

        private final void checkValid() throws IOException {
            if (this.rafb.isReleased()) {
                throw new IOException("Attempt to use a released RandomAccessFileBucket: ");
            }
        }

        private final int bytesLeft() throws IOException {
            return (int)(this.rafb.offset + this.rafb.len - RandomAccessFileBucket2.this.raf.getFilePointer());
        }
    }

    class RAInputStream
    extends InputStream {
        private RandomAccessFileBucket2 rafb = null;

        public RAInputStream(RandomAccessFileBucket2 rafb, String prefix) throws IOException {
            this.rafb = rafb;
            RandomAccessFileBucket2.this.raf.seek(RandomAccessFileBucket2.this.offset);
        }

        private final int bytesLeft() throws IOException {
            return (int)(this.rafb.offset + this.rafb.len - RandomAccessFileBucket2.this.raf.getFilePointer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                if (this.bytesLeft() < 1) {
                    return -1;
                }
                return RandomAccessFileBucket2.this.raf.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] bytes) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                int nAvailable = this.bytesLeft();
                if (nAvailable < 1) {
                    return -1;
                }
                if (nAvailable > bytes.length) {
                    nAvailable = bytes.length;
                }
                return RandomAccessFileBucket2.this.raf.read(bytes, 0, nAvailable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] bytes, int a, int b) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                int nAvailable = this.bytesLeft();
                if (nAvailable < 1) {
                    return -1;
                }
                if (nAvailable > b) {
                    nAvailable = b;
                }
                return RandomAccessFileBucket2.this.raf.read(bytes, a, nAvailable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long a) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                int nAvailable = this.bytesLeft();
                if (nAvailable < 1) {
                    return -1L;
                }
                if ((long)nAvailable > a) {
                    nAvailable = (int)a;
                }
                return RandomAccessFileBucket2.this.raf.skipBytes(nAvailable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                return this.bytesLeft();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = this.rafb;
            synchronized (randomAccessFileBucket2) {
                if (this.rafb.streams.contains(this)) {
                    this.rafb.streams.removeElement(this);
                }
                this.rafb.streams.trimToSize();
            }
        }

        public void mark(int a) {
        }

        public void reset() throws IOException {
        }

        public boolean markSupported() {
            return false;
        }
    }

    public static class Range {
        public long offset;
        public long len;

        Range(long offset, long len) {
            this.offset = offset;
            this.len = len;
        }
    }
}

