/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.Core;
import frost.util.FileAccess;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frost {
    private static final Logger logger = Logger.getLogger(Frost.class.getName());
    private static String lookAndFeel = null;
    private static String cmdLineLocaleName = null;
    private static String cmdLineLocaleFileName = null;
    private static boolean offlineMode = false;
    private static File runLockFile = new File("frost.lock");
    private static FileChannel lockChannel;
    private static FileLock fileLock;

    public static void main(String[] args) {
        System.out.println();
        System.out.println("Frost, Copyright (C) 2007 Frost Project");
        System.out.println("Frost comes with ABSOLUTELY NO WARRANTY!");
        System.out.println("This is free software, and you are welcome to");
        System.out.println("redistribute it under the GPL conditions.");
        System.out.println("Frost uses code from apache.org (Apache license),");
        System.out.println("bouncycastle.org (BSD license), Onion Networks (BSD license),");
        System.out.println("Martin Newstead (LGPL license), Volker H. Simonis (GPL v2 license) and");
        System.out.println("McObject LLC (GPL v2 license).");
        System.out.println();
        Frost.parseCommandLine(args);
        new Frost();
    }

    private void initializeLookAndFeel() {
        LookAndFeel laf = null;
        try {
            String landf;
            if (lookAndFeel != null) {
                try {
                    laf = (LookAndFeel)Class.forName(lookAndFeel).newInstance();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (laf == null || !laf.isSupportedLookAndFeel()) {
                    laf = null;
                }
            }
            if (laf == null && (landf = Core.frostSettings.getValue("ChoosenLookAndFeel")) != null && landf.length() > 0) {
                try {
                    laf = (LookAndFeel)Class.forName(landf).newInstance();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (laf == null || !laf.isSupportedLookAndFeel()) {
                    laf = null;
                }
            }
            if (laf == null && (landf = UIManager.getSystemLookAndFeelClassName()) != null && landf.length() > 0) {
                try {
                    laf = (LookAndFeel)Class.forName(landf).newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (laf == null || !laf.isSupportedLookAndFeel()) {
                    laf = null;
                }
            }
            if (laf != null) {
                UIManager.setLookAndFeel(laf);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Using the default");
        }
    }

    private static void parseCommandLine(String[] args) {
        int count = 0;
        try {
            while (args.length > count) {
                if (args[count].equals("-?") || args[count].equals("-help") || args[count].equals("--help") || args[count].equals("/?") || args[count].equals("/help")) {
                    Frost.showHelp();
                    ++count;
                    continue;
                }
                if (args[count].equals("-lf")) {
                    lookAndFeel = args[count + 1];
                    count += 2;
                    continue;
                }
                if (args[count].equals("-locale")) {
                    cmdLineLocaleName = args[count + 1];
                    count += 2;
                    continue;
                }
                if (args[count].equals("-localefile")) {
                    cmdLineLocaleFileName = args[count + 1];
                    count += 2;
                    continue;
                }
                if (args[count].equals("-offline")) {
                    offlineMode = true;
                    ++count;
                    continue;
                }
                Frost.showHelp();
            }
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            Frost.showHelp();
        }
    }

    private static void showHelp() {
        UIManager.LookAndFeelInfo[] feels;
        System.out.println("java -jar frost.jar [-lf lookAndFeel] [-locale languageCode]\n");
        System.out.println("-lf     Sets the 'Look and Feel' Frost will use.");
        System.out.println("        (overriden by the skins preferences)\n");
        System.out.println("        These ones are currently available:");
        for (UIManager.LookAndFeelInfo element : feels = UIManager.getInstalledLookAndFeels()) {
            System.out.println("           " + element.getClassName());
        }
        System.out.println("\n         And this one is used by default:");
        System.out.println("           " + lookAndFeel + "\n");
        System.out.println("-locale  Sets the language Frost will use, if available.");
        System.out.println("         (overrides the setting in the preferences)\n");
        System.out.println("-localefile  Sets the language file.");
        System.out.println("             (allows tests of own language files)");
        System.out.println("             (if set the -locale setting is ignored)\n");
        System.out.println("-offline     Startup in offline mode.");
        System.out.println("Example:\n");
        System.out.print("java -jar frost.jar ");
        if (feels.length > 0) {
            System.out.print("-lf " + feels[0].getClassName() + " ");
        }
        System.out.println("-locale es\n");
        System.out.println("That command line will instruct Frost to use the");
        if (feels.length > 0) {
            System.out.println(feels[0].getClassName() + " look and feel and the");
        }
        System.out.println("Spanish language.");
        System.exit(0);
    }

    public Frost() {
        System.out.println("Starting Frost " + this.getClass().getPackage().getSpecificationVersion());
        System.out.println();
        for (String s : Frost.getEnvironmentInformation()) {
            System.out.println(s);
        }
        System.out.println();
        Core core = Core.getInstance();
        String jvmVendor = System.getProperty("java.vm.vendor");
        String jvmVersion = System.getProperty("java.vm.version");
        if (jvmVendor != null && jvmVersion != null) {
            if (jvmVendor.indexOf("Sun ") < 0) {
                boolean skipInfoDialog = false;
                String lastUsedVendor = Core.frostSettings.getValue("lastUsedJvm.vendor");
                String lastUsedVersion = Core.frostSettings.getValue("lastUsedJvm.version");
                if (lastUsedVendor != null && lastUsedVendor.length() > 0 && lastUsedVersion != null && lastUsedVersion.length() > 0 && lastUsedVendor.equals(jvmVendor) && lastUsedVersion.equals(jvmVersion)) {
                    skipInfoDialog = true;
                }
                if (!skipInfoDialog) {
                    MiscToolkit.showMessage("Frost was tested with Java from Sun. Your JVM vendor is " + jvmVendor + ".\n" + "If Frost does not work as expected, get Suns Java from http://java.sun.com\n\n" + "(This information dialog will not be shown again until your JVM version changed.)", 2, "Untested Java version detected");
                }
            }
            Core.frostSettings.setValue("lastUsedJvm.vendor", jvmVendor);
            Core.frostSettings.setValue("lastUsedJvm.version", jvmVersion);
        } else {
            System.out.println("Error: JVM vendor or version property is not set!");
        }
        this.initializeLookAndFeel();
        if (!this.initializeLockFile(Language.getInstance())) {
            System.exit(1);
        }
        if (!this.checkLibs()) {
            System.exit(3);
        }
        try {
            core.initialize();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "There was a problem while initializing Frost.", e);
            System.exit(3);
        }
    }

    public static List<String> getEnvironmentInformation() {
        ArrayList<String> envInfo = new ArrayList<String>();
        envInfo.add("JVM      : " + System.getProperty("java.vm.vendor") + "; " + System.getProperty("java.vm.version") + "; " + System.getProperty("java.vm.name"));
        envInfo.add("Runtime  : " + System.getProperty("java.vendor") + "; " + System.getProperty("java.version"));
        envInfo.add("OS       : " + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("os.arch"));
        envInfo.add("MaxMemory: " + Runtime.getRuntime().maxMemory());
        return envInfo;
    }

    private boolean checkLibs() {
        String jarFileName = "";
        try {
            jarFileName = "xercesImpl.jar";
            Class.forName("org.apache.xerces.dom.DocumentImpl");
            jarFileName = "xml-apis.jar";
            Class.forName("org.w3c.dom.Document");
            jarFileName = "xercesImpl.jar";
            Class.forName("org.apache.xml.serialize.OutputFormat");
            jarFileName = "genChkImpl.jar";
            Class.forName("freenet.client.ClientKey");
            jarFileName = "fecImpl.jar";
            Class.forName("fecimpl.FECUtils");
            jarFileName = "datechooser.jar";
            Class.forName("mseries.ui.MDateEntryField");
            jarFileName = "joda-time.jar";
            Class.forName("org.joda.time.DateTime");
            jarFileName = "perst15.jar";
            Class.forName("org.garret.perst.Persistent");
        }
        catch (ClassNotFoundException e1) {
            MiscToolkit.showMessage("Please start Frost using its start scripts (frost.bat for Windows, frost.sh for Unix).\nIf Frost was working and you updated just frost.jar, try updating with frost.zip\nERROR: The jar file " + jarFileName + " is missing.", 0, "ERROR: The jar file " + jarFileName + " is missing.");
            return false;
        }
        return true;
    }

    private boolean initializeLockFile(Language language) {
        FileAccess.writeFile("frost-lock", runLockFile);
        try {
            lockChannel = new RandomAccessFile(runLockFile, "rw").getChannel();
            fileLock = null;
            try {
                fileLock = lockChannel.tryLock();
            }
            catch (OverlappingFileLockException e) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileLock == null) {
            MiscToolkit.showMessage(language.getString("Frost.lockFileFound") + "'" + runLockFile.getAbsolutePath() + "'", 0, "ERROR: Found Frost lock file 'frost.lock'.");
            return false;
        }
        return true;
    }

    public static void releaseLockFile() {
        if (fileLock != null) {
            try {
                fileLock.release();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (lockChannel != null) {
            try {
                lockChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        runLockFile.delete();
    }

    public static String getCmdLineLocaleFileName() {
        return cmdLineLocaleFileName;
    }

    public static String getCmdLineLocaleName() {
        return cmdLineLocaleName;
    }

    public static boolean isOfflineMode() {
        return offlineMode;
    }
}

