/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.Core;
import frost.SettingsClass;
import frost.SettingsUpdater;
import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.BoardInfoFrame;
import frost.boards.BoardUpdateBoardSelector;
import frost.boards.BoardUpdateInformationFrame;
import frost.boards.Folder;
import frost.boards.TOF;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.components.translate.TranslationStartDialog;
import frost.ext.JSysTrayIcon;
import frost.fileTransfer.FileTransferInformation;
import frost.gui.AboutBox;
import frost.gui.IdentitiesBrowser;
import frost.gui.KnownBoardsFrame;
import frost.gui.MainFrameStatusBar;
import frost.gui.ManageLocalIdentitiesDialog;
import frost.gui.MessageFrame;
import frost.gui.MessagePanel;
import frost.gui.SearchMessagesDialog;
import frost.gui.StatisticsDialog;
import frost.gui.help.HelpBrowserFrame;
import frost.gui.messagetreetable.MessageTreeTable;
import frost.gui.messagetreetable.TreeTableModelAdapter;
import frost.gui.preferences.OptionsFrame;
import frost.gui.sentmessages.SentMessagesPanel;
import frost.gui.unsentmessages.UnsentMessagesPanel;
import frost.messages.FrostMessageObject;
import frost.messages.UnsentMessagesManager;
import frost.storage.StorageException;
import frost.storage.perst.filelist.FileListStorage;
import frost.storage.perst.identities.IdentitiesStorage;
import frost.storage.perst.messagearchive.ArchiveMessageStorage;
import frost.storage.perst.messages.MessageStorage;
import frost.threads.RunningMessageThreadsInformation;
import frost.util.DateFun;
import frost.util.Mixed;
import frost.util.gui.GlassPane;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MemoryMonitor;
import frost.util.gui.MiscToolkit;
import frost.util.gui.StartupMessage;
import frost.util.gui.translation.JTranslatableTabbedPane;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageGuiSupport;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame
implements SettingsUpdater,
LanguageListener {
    private static final Logger logger = Logger.getLogger(MainFrame.class.getName());
    private final ImageIcon frameIconDefault = MiscToolkit.loadImageIcon("/data/jtc.jpg");
    private final ImageIcon frameIconNewMessage = MiscToolkit.loadImageIcon("/data/newmessage.gif");
    private HelpBrowserFrame helpBrowser = null;
    private SearchMessagesDialog searchMessagesDialog = null;
    private MemoryMonitor memoryMonitor = null;
    private long todaysDateMillis = 0L;
    private MessagePanel messagePanel = null;
    private SentMessagesPanel sentMessagesPanel = null;
    private UnsentMessagesPanel unsentMessagesPanel = null;
    private ImageIcon progressIconRunning = null;
    private ImageIcon progressIconIdle = null;
    private JLabel progressIconLabel = null;
    private JLabel disconnectedLabel = null;
    private static SettingsClass frostSettings = null;
    private static MainFrame instance = null;
    private JButton boardInfoButton = null;
    private long counter = 55L;
    private static List<StartupMessage> queuedStartupMessages = new LinkedList<StartupMessage>();
    private JButton knownBoardsButton = null;
    private JButton searchMessagesButton = null;
    private final JMenu fileMenu = new JMenu();
    private final JMenuItem fileExitMenuItem = new JMenuItem();
    private final JMenuItem fileStatisticsMenuItem = new JMenuItem();
    private final JMenuItem helpAboutMenuItem = new JMenuItem();
    private final JMenuItem helpHelpMenuItem = new JMenuItem();
    private final JMenuItem helpMemMonMenuItem = new JMenuItem();
    private final JMenu helpMenu = new JMenu();
    private final JMenu languageMenu = new JMenu();
    private Language language = null;
    private JMenuBar menuBar;
    private JButton newBoardButton = null;
    private JButton newFolderButton = null;
    private JToolBar buttonToolBar;
    private MainFrameStatusBar statusBar;
    private final JMenu optionsMenu = new JMenu();
    private final JMenuItem optionsPreferencesMenuItem = new JMenuItem();
    private final JMenuItem optionsManageLocalIdentitiesMenuItem = new JMenuItem();
    private final JMenuItem optionsManageIdentitiesMenuItem = new JMenuItem();
    private final JMenu pluginMenu = new JMenu();
    private final JMenuItem pluginTranslateMenuItem = new JMenuItem();
    private JButton removeBoardButton = null;
    private JButton renameFolderButton = null;
    private JButton configBoardButton = null;
    private JButton systemTrayButton = null;
    private JTranslatableTabbedPane tabbedPane;
    private final JLabel timeLabel = new JLabel("");
    private final JCheckBoxMenuItem tofAutomaticUpdateMenuItem = new JCheckBoxMenuItem();
    private final JMenuItem tofDisplayBoardInfoMenuItem = new JMenuItem();
    private final JMenuItem tofDisplayBoardUpdateInformationMenuItem = new JMenuItem();
    private final JMenuItem tofDisplayKnownBoards = new JMenuItem();
    private final JMenuItem tofSearchMessages = new JMenuItem();
    private final JMenu tofMenu = new JMenu();
    private TofTree tofTree = null;
    private TofTreeModel tofTreeModel = null;
    private JSplitPane treeAndTabbedPaneSplitpane = null;
    private GlassPane glassPane = null;
    private final List<JRadioButtonMenuItem> lookAndFeels = new ArrayList<JRadioButtonMenuItem>();

    public MainFrame(SettingsClass settings, String title) {
        instance = this;
        Core.getInstance();
        frostSettings = settings;
        this.language = Language.getInstance();
        this.setDefaultCloseOperation(0);
        frostSettings.addUpdater(this);
        this.enableEvents(64L);
        this.setIconImage(this.frameIconDefault.getImage());
        this.setResizable(true);
        this.setTitle(title);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.addWindowListener(new WindowClosingListener());
        this.addWindowStateListener(new WindowStateListener());
    }

    public static MainFrame getInstance() {
        return instance;
    }

    public TofTree getTofTree() {
        return this.tofTree;
    }

    public TofTreeModel getTofTreeModel() {
        return this.tofTreeModel;
    }

    public void addPanel(String title, JPanel panel) {
        this.getTabbedPane().add(title, panel);
    }

    public void addMenuItem(JMenuItem item, String menuNameKey, int block, int position, boolean newBlock) {
        int index;
        String menuName = this.language.getString(menuNameKey);
        JMenu menu = null;
        for (index = 0; index < this.getMainMenuBar().getMenuCount() && menu == null; ++index) {
            JMenu aMenu = this.getMainMenuBar().getMenu(index);
            if (aMenu == null || !menuName.equals(aMenu.getText())) continue;
            menu = aMenu;
        }
        if (menu == null) {
            menu = new JMenu(menuName);
            this.getMainMenuBar().add(menu);
            menu.add(item);
            return;
        }
        int blockCount = 0;
        for (index = 0; index < menu.getItemCount() && blockCount < block; ++index) {
            JMenuItem component = menu.getItem(index);
            if (component != null) continue;
            ++blockCount;
        }
        if (blockCount < block) {
            menu.addSeparator();
            menu.add(item);
            return;
        }
        if (newBlock) {
            menu.insertSeparator(index);
            menu.insert(item, index);
            return;
        }
        JMenuItem component = menu.getItem(index);
        for (int posCount = 0; index < menu.getComponentCount() && component != null && posCount < position; ++posCount) {
            component = menu.getItem(++index);
        }
        menu.add((Component)item, index);
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTranslatableTabbedPane(this.language);
        }
        return this.tabbedPane;
    }

    public void selectTabbedPaneTab(String title) {
        int position = this.getTabbedPane().indexOfTab(title);
        if (position != -1) {
            this.getTabbedPane().setSelectedIndex(position);
        }
    }

    private JToolBar getButtonToolBar() {
        if (this.buttonToolBar == null) {
            this.buttonToolBar = new JToolBar();
            this.newBoardButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/internet-group-chat.png"));
            this.newFolderButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/folder-new.png"));
            this.configBoardButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/document-properties.png"));
            this.renameFolderButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/edit-select-all.png"));
            this.removeBoardButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/user-trash.png"));
            this.boardInfoButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/information.png"));
            this.knownBoardsButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/internet-web-browser.png"));
            this.searchMessagesButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/edit-find.png"));
            this.systemTrayButton = new JButton(MiscToolkit.loadImageIcon("/data/tray.gif"));
            this.progressIconRunning = MiscToolkit.loadImageIcon("/data/progress_running.gif");
            this.progressIconIdle = MiscToolkit.loadImageIcon("/data/progress_idle.gif");
            this.progressIconLabel = new JLabel(this.progressIconIdle);
            this.disconnectedLabel = new JLabel("");
            MiscToolkit.configureButton(this.newBoardButton, "MainFrame.toolbar.tooltip.newBoard", this.language);
            MiscToolkit.configureButton(this.newFolderButton, "MainFrame.toolbar.tooltip.newFolder", this.language);
            MiscToolkit.configureButton(this.removeBoardButton, "MainFrame.toolbar.tooltip.removeBoard", this.language);
            MiscToolkit.configureButton(this.renameFolderButton, "MainFrame.toolbar.tooltip.renameFolder", this.language);
            MiscToolkit.configureButton(this.boardInfoButton, "MainFrame.toolbar.tooltip.boardInformationWindow", this.language);
            MiscToolkit.configureButton(this.systemTrayButton, "MainFrame.toolbar.tooltip.minimizeToSystemTray", this.language);
            MiscToolkit.configureButton(this.knownBoardsButton, "MainFrame.toolbar.tooltip.displayListOfKnownBoards", this.language);
            MiscToolkit.configureButton(this.searchMessagesButton, "MainFrame.toolbar.tooltip.searchMessages", this.language);
            MiscToolkit.configureButton(this.configBoardButton, "MainFrame.toolbar.tooltip.configureBoard", this.language);
            this.knownBoardsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofDisplayKnownBoardsMenuItem_actionPerformed(e);
                }
            });
            this.searchMessagesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.startSearchMessagesDialog();
                }
            });
            this.newBoardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofTree.createNewBoard(MainFrame.this);
                }
            });
            this.newFolderButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofTree.createNewFolder(MainFrame.this);
                }
            });
            this.renameFolderButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.renameFolder((Folder)MainFrame.this.tofTreeModel.getSelectedNode());
                }
            });
            this.removeBoardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofTree.removeNode(MainFrame.this.tofTreeModel.getSelectedNode());
                }
            });
            this.configBoardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofTree.configureBoard(MainFrame.this.tofTreeModel.getSelectedNode());
                }
            });
            this.systemTrayButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (JSysTrayIcon.getInstance() != null) {
                            JSysTrayIcon.getInstance().showWindow(JSysTrayIcon.SHOW_CMD_HIDE);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.boardInfoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofDisplayBoardInfoMenuItem_actionPerformed(e);
                }
            });
            this.buttonToolBar.setRollover(true);
            this.buttonToolBar.setFloatable(false);
            Dimension blankSpace = new Dimension(3, 3);
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.add(this.newBoardButton);
            this.buttonToolBar.add(this.newFolderButton);
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.add(this.configBoardButton);
            this.buttonToolBar.add(this.renameFolderButton);
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.add(this.removeBoardButton);
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.add(this.boardInfoButton);
            this.buttonToolBar.add(this.knownBoardsButton);
            this.buttonToolBar.add(this.searchMessagesButton);
            if (JSysTrayIcon.getInstance() != null) {
                this.buttonToolBar.add(Box.createRigidArea(blankSpace));
                this.buttonToolBar.addSeparator();
                this.buttonToolBar.add(Box.createRigidArea(blankSpace));
                this.buttonToolBar.add(this.systemTrayButton);
            }
            this.buttonToolBar.add(Box.createHorizontalGlue());
            this.buttonToolBar.add(this.disconnectedLabel);
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
            this.buttonToolBar.add(this.progressIconLabel);
            this.buttonToolBar.add(Box.createRigidArea(blankSpace));
        }
        return this.buttonToolBar;
    }

    public void showProgress() {
        this.progressIconLabel.setIcon(this.progressIconRunning);
    }

    public void hideProgress() {
        this.progressIconLabel.setIcon(this.progressIconIdle);
    }

    public void setDisconnected() {
        this.disconnectedLabel.setOpaque(true);
        this.disconnectedLabel.setBackground(Color.yellow);
        this.disconnectedLabel.setText(" DISCONNECTED ");
    }

    public void setConnected() {
        this.disconnectedLabel.setOpaque(false);
        this.disconnectedLabel.setBackground(this.progressIconLabel.getBackground());
        this.disconnectedLabel.setText("");
    }

    private JMenuBar getMainMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            JMenu lookAndFeelMenu = this.getLookAndFeelMenu();
            this.tofDisplayBoardInfoMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/information.png", 16, 16));
            this.tofAutomaticUpdateMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/mail-send-receive.png", 16, 16));
            this.tofDisplayKnownBoards.setIcon(MiscToolkit.getScaledImage("/data/toolbar/internet-web-browser.png", 16, 16));
            this.tofSearchMessages.setIcon(MiscToolkit.getScaledImage("/data/toolbar/edit-find.png", 16, 16));
            this.fileExitMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/system-log-out.png", 16, 16));
            this.fileStatisticsMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/x-office-spreadsheet.png", 16, 16));
            lookAndFeelMenu.setIcon(MiscToolkit.getScaledImage("/data/toolbar/preferences-desktop-theme.png", 16, 16));
            this.optionsManageIdentitiesMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/group.png", 16, 16));
            this.optionsManageLocalIdentitiesMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/user.png", 16, 16));
            this.optionsPreferencesMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/preferences-system.png", 16, 16));
            this.helpAboutMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/award_star_silver_3.png", 16, 16));
            this.pluginTranslateMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/arrow_switch.png", 16, 16));
            this.fileExitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.fileExitMenuItem_actionPerformed(e);
                }
            });
            this.fileStatisticsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.fileStatisticsMenuItem_actionPerformed(e);
                }
            });
            this.optionsPreferencesMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.optionsPreferencesMenuItem_actionPerformed(e);
                }
            });
            this.optionsManageLocalIdentitiesMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.optionsManageLocalIdentitiesMenuItem_actionPerformed(e);
                }
            });
            this.optionsManageIdentitiesMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.optionsManageIdentitiesMenuItem_actionPerformed(e);
                }
            });
            this.tofDisplayBoardInfoMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofDisplayBoardInfoMenuItem_actionPerformed(e);
                }
            });
            this.tofDisplayBoardUpdateInformationMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofDisplayBoardUpdateInformationMenuItem_actionPerformed(e);
                }
            });
            this.tofDisplayKnownBoards.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.tofDisplayKnownBoardsMenuItem_actionPerformed(e);
                }
            });
            this.tofSearchMessages.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.startSearchMessagesDialog();
                }
            });
            this.pluginTranslateMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.getTranslationDialog().setVisible(true);
                }
            });
            this.helpHelpMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/help-browser.png", 16, 16));
            this.helpHelpMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.showHtmlHelp("index.html");
                }
            });
            if (!Core.isHelpHtmlSecure()) {
                this.helpHelpMenuItem.setEnabled(false);
            }
            this.helpAboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.helpAboutMenuItem_actionPerformed(e);
                }
            });
            this.helpMemMonMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/utilities-system-monitor.png", 16, 16));
            this.helpMemMonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.getMemoryMonitor().showDialog();
                }
            });
            this.fileMenu.add(this.fileStatisticsMenuItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileExitMenuItem);
            this.tofMenu.add(this.tofAutomaticUpdateMenuItem);
            this.tofMenu.addSeparator();
            this.tofMenu.add(this.tofDisplayBoardInfoMenuItem);
            this.tofMenu.add(this.tofDisplayBoardUpdateInformationMenuItem);
            this.tofMenu.add(this.tofDisplayKnownBoards);
            this.tofMenu.add(this.tofSearchMessages);
            this.optionsMenu.add(this.optionsManageLocalIdentitiesMenuItem);
            this.optionsMenu.add(this.optionsManageIdentitiesMenuItem);
            this.optionsMenu.addSeparator();
            this.optionsMenu.add(lookAndFeelMenu);
            this.optionsMenu.addSeparator();
            this.optionsMenu.add(this.optionsPreferencesMenuItem);
            this.pluginMenu.add(this.pluginTranslateMenuItem);
            LanguageGuiSupport.getInstance().buildInitialLanguageMenu(this.languageMenu);
            this.helpMenu.add(this.helpMemMonMenuItem);
            this.helpMenu.add(this.helpHelpMenuItem);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.helpAboutMenuItem);
            this.menuBar.add(this.fileMenu);
            this.menuBar.add(this.tofMenu);
            this.menuBar.add(this.optionsMenu);
            this.menuBar.add(this.pluginMenu);
            this.menuBar.add(this.languageMenu);
            this.menuBar.add(this.helpMenu);
            this.menuBar.add(Box.createHorizontalGlue());
            this.menuBar.add(this.timeLabel);
            this.menuBar.add(Box.createRigidArea(new Dimension(3, 3)));
            this.translateMainMenu();
            this.language.addLanguageListener(this);
        }
        return this.menuBar;
    }

    private JMenu getLookAndFeelMenu() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        JMenu lfMenu = new JMenu("Look and feel");
        ButtonGroup group = new ButtonGroup();
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String lfName = e.getActionCommand();
                try {
                    UIManager.setLookAndFeel(lfName);
                    MainFrame.this.updateComponentTreesUI();
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Exception changing l&f", t);
                }
            }
        };
        for (UIManager.LookAndFeelInfo element : info) {
            String lfClassName = element.getClassName();
            try {
                LookAndFeel laf = (LookAndFeel)Class.forName(lfClassName).newInstance();
                if (!laf.isSupportedLookAndFeel()) continue;
                JRadioButtonMenuItem rmItem = new JRadioButtonMenuItem(laf.getName() + "  [" + lfClassName + "]");
                rmItem.setActionCommand(lfClassName);
                rmItem.setSelected(UIManager.getLookAndFeel().getName().equals(laf.getName()));
                group.add(rmItem);
                rmItem.addActionListener(al);
                lfMenu.add(rmItem);
                this.lookAndFeels.add(rmItem);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception adding l&f menu", t);
            }
        }
        return lfMenu;
    }

    private MainFrameStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new MainFrameStatusBar();
        }
        return this.statusBar;
    }

    private JTabbedPane buildMainPanel() {
        JScrollPane tofTreeScrollPane = new JScrollPane(this.tofTree);
        tofTreeScrollPane.setWheelScrollingEnabled(true);
        this.tofTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                MainFrame.this.tofTree_actionPerformed(e);
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        this.treeAndTabbedPaneSplitpane = new JSplitPane(1, tofTreeScrollPane, p);
        p.add((Component)this.getMessagePanel(), "Center");
        int dividerLoc = frostSettings.getIntValue("MainFrame.treeAndTabbedPaneSplitpaneDividerLocation");
        if (dividerLoc < 10) {
            dividerLoc = 160;
        }
        this.treeAndTabbedPaneSplitpane.setDividerLocation(dividerLoc);
        this.getTabbedPane().insertTab("MainFrame.tabbedPane.news", null, this.treeAndTabbedPaneSplitpane, null, 0);
        this.getTabbedPane().setSelectedIndex(0);
        return this.getTabbedPane();
    }

    public void setKeyActionForNewsTab(Action action, String actionName, KeyStroke keyStroke) {
        this.treeAndTabbedPaneSplitpane.getInputMap(1).put(keyStroke, actionName);
        this.treeAndTabbedPaneSplitpane.getActionMap().put(actionName, action);
    }

    public void showMessagePanelInSplitpane() {
        if (this.treeAndTabbedPaneSplitpane != null) {
            JPanel p = (JPanel)this.treeAndTabbedPaneSplitpane.getRightComponent();
            if (p.getComponent(0) == this.getMessagePanel()) {
                return;
            }
            p.removeAll();
            p.add((Component)this.getMessagePanel(), "Center");
            p.repaint();
            if (this.getSentMessagesPanel().isShown()) {
                this.getSentMessagesPanel().cleanupAfterLeave();
            }
            if (this.getUnsentMessagesPanel().isShown()) {
                this.getUnsentMessagesPanel().cleanupAfterLeave();
            }
        }
    }

    public void showSentMessagePanelInSplitpane() {
        if (this.treeAndTabbedPaneSplitpane != null) {
            final JPanel p = (JPanel)this.treeAndTabbedPaneSplitpane.getRightComponent();
            if (p.getComponent(0) == this.getSentMessagesPanel()) {
                return;
            }
            Thread t = new Thread(){

                public void run() {
                    try {
                        this.setPriority(this.getPriority() - 1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    MainFrame.this.getSentMessagesPanel().prepareForShow();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            p.removeAll();
                            p.add((Component)MainFrame.this.getSentMessagesPanel(), "Center");
                            MainFrame.this.deactivateGlassPane();
                            if (MainFrame.this.getUnsentMessagesPanel().isShown()) {
                                MainFrame.this.getUnsentMessagesPanel().cleanupAfterLeave();
                            }
                        }
                    });
                }
            };
            this.activateGlassPane();
            t.start();
        }
    }

    public void showUnsentMessagePanelInSplitpane() {
        if (this.treeAndTabbedPaneSplitpane != null) {
            final JPanel p = (JPanel)this.treeAndTabbedPaneSplitpane.getRightComponent();
            if (p.getComponent(0) == this.getUnsentMessagesPanel()) {
                return;
            }
            Thread t = new Thread(){

                public void run() {
                    try {
                        this.setPriority(this.getPriority() - 1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    MainFrame.this.getUnsentMessagesPanel().prepareForShow();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            p.removeAll();
                            p.add((Component)MainFrame.this.getUnsentMessagesPanel(), "Center");
                            MainFrame.this.deactivateGlassPane();
                            if (MainFrame.this.getSentMessagesPanel().isShown()) {
                                MainFrame.this.getSentMessagesPanel().cleanupAfterLeave();
                            }
                        }
                    });
                }
            };
            this.activateGlassPane();
            t.start();
        }
    }

    public SentMessagesPanel getSentMessagesPanel() {
        if (this.sentMessagesPanel == null) {
            this.sentMessagesPanel = new SentMessagesPanel();
        }
        return this.sentMessagesPanel;
    }

    public UnsentMessagesPanel getUnsentMessagesPanel() {
        if (this.unsentMessagesPanel == null) {
            this.unsentMessagesPanel = new UnsentMessagesPanel();
        }
        return this.unsentMessagesPanel;
    }

    public void saveLayout() {
        Rectangle bounds = this.getBounds();
        boolean isMaximized = (this.getExtendedState() & 6) != 0;
        frostSettings.setValue("lastFrameMaximized", isMaximized);
        if (!isMaximized) {
            frostSettings.setValue("lastFrameHeight", bounds.height);
            frostSettings.setValue("lastFrameWidth", bounds.width);
            frostSettings.setValue("lastFramePosX", bounds.x);
            frostSettings.setValue("lastFramePosY", bounds.y);
        }
        frostSettings.setValue("MainFrame.treeAndTabbedPaneSplitpaneDividerLocation", this.treeAndTabbedPaneSplitpane.getDividerLocation());
        for (JRadioButtonMenuItem rbmi : this.lookAndFeels) {
            if (!rbmi.isSelected()) continue;
            frostSettings.setValue("ChoosenLookAndFeel", rbmi.getActionCommand());
        }
        this.getMessagePanel().saveLayout(frostSettings);
        this.getSentMessagesPanel().saveTableFormat();
        this.getUnsentMessagesPanel().saveTableFormat();
    }

    private void fileExitMenuItem_actionPerformed(ActionEvent e) {
        int result;
        if (MessageFrame.getOpenInstanceCount() > 0 && (result = JOptionPane.showConfirmDialog(this, this.language.getString("MainFrame.openCreateMessageWindows.body"), this.language.getString("MainFrame.openCreateMessageWindows.title"), 0, 3)) == 1) {
            return;
        }
        if (UnsentMessagesManager.getRunningMessageUploads() > 0 && (result = JOptionPane.showConfirmDialog(this, this.language.getString("MainFrame.runningUploadsWarning.body"), this.language.getString("MainFrame.runningUploadsWarning.title"), 0, 3)) == 1) {
            return;
        }
        this.saveLayout();
        System.exit(0);
    }

    private void fileStatisticsMenuItem_actionPerformed(ActionEvent evt) {
        this.activateGlassPane();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    final int msgCount = MessageStorage.inst().getMessageCount();
                    final int arcMsgCount = ArchiveMessageStorage.inst().getMessageCount();
                    final int idCount = IdentitiesStorage.inst().getIdentityCount();
                    final int fileCount = FileListStorage.inst().getFileCount();
                    final int sharerCount = FileListStorage.inst().getSharerCount();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainFrame.this.deactivateGlassPane();
                            StatisticsDialog dlg = new StatisticsDialog(MainFrame.this);
                            dlg.startDialog(msgCount, arcMsgCount, idCount, sharerCount, fileCount, 0L);
                        }
                    });
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainFrame.this.deactivateGlassPane();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
    }

    public MessagePanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new MessagePanel(frostSettings, this);
            this.messagePanel.setParentFrame(this);
            this.messagePanel.setIdentities(Core.getIdentities());
            this.messagePanel.initialize();
        }
        return this.messagePanel;
    }

    private void helpAboutMenuItem_actionPerformed(ActionEvent e) {
        AboutBox dlg = new AboutBox(this);
        dlg.setVisible(true);
    }

    public void postInitialize() {
        if (this.tofTree.getRowCount() > frostSettings.getIntValue("tofTreeSelectedRow")) {
            this.tofTree.setSelectionRow(frostSettings.getIntValue("tofTreeSelectedRow"));
        }
    }

    public void initialize() {
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.getButtonToolBar(), "North");
        contentPanel.add((Component)this.buildMainPanel(), "Center");
        contentPanel.add((Component)this.getStatusBar(), "South");
        this.setJMenuBar(this.getMainMenuBar());
        TOF.getInstance().searchAllUnreadMessages(false);
        this.tofAutomaticUpdateMenuItem.setSelected(frostSettings.getBoolValue("automaticUpdate"));
        if (frostSettings.getIntValue("messageBodyFontSize") < 6) {
            frostSettings.setValue("messageBodyFontSize", 6);
        }
        int lastHeight = frostSettings.getIntValue("lastFrameHeight");
        int lastWidth = frostSettings.getIntValue("lastFrameWidth");
        int lastPosX = frostSettings.getIntValue("lastFramePosX");
        int lastPosY = frostSettings.getIntValue("lastFramePosY");
        boolean lastMaximized = frostSettings.getBoolValue("lastFrameMaximized");
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (lastWidth < 100) {
            lastWidth = 700;
        }
        if (lastWidth > scrSize.width) {
            lastWidth = scrSize.width;
        }
        if (lastHeight < 100) {
            lastHeight = 500;
        }
        if (lastHeight > scrSize.height) {
            lastWidth = scrSize.height;
        }
        if (lastPosX < 0) {
            lastPosX = 0;
        }
        if (lastPosY < 0) {
            lastPosY = 0;
        }
        if (lastPosX + lastWidth > scrSize.width) {
            lastPosX = scrSize.width / 10;
            lastWidth = (int)(scrSize.getWidth() / 10.0 * 8.0);
        }
        if (lastPosY + lastHeight > scrSize.height) {
            lastPosY = scrSize.height / 10;
            lastHeight = (int)(scrSize.getHeight() / 10.0 * 8.0);
        }
        this.setBounds(lastPosX, lastPosY, lastWidth, lastHeight);
        if (lastMaximized) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
        this.validate();
    }

    public void startTickerThread() {
        Thread tickerThread = new Thread("tick tack"){

            public void run() {
                while (true) {
                    Mixed.wait(1000);
                    MainFrame.this.timer_actionPerformed();
                }
            }
        };
        tickerThread.start();
    }

    private void optionsPreferencesMenuItem_actionPerformed(ActionEvent e) {
        try {
            frostSettings.exitSave();
        }
        catch (StorageException se) {
            logger.log(Level.SEVERE, "Error while saving the settings.", se);
        }
        OptionsFrame optionsDlg = new OptionsFrame((Frame)this, frostSettings);
        boolean okPressed = optionsDlg.runDialog();
        if (okPressed) {
            if (optionsDlg.shouldReloadMessages()) {
                TOF.getInstance().searchAllUnreadMessages(true);
                this.tofTree_actionPerformed(null);
            }
            if (optionsDlg.shouldResetLastBackloadUpdateFinishedMillis()) {
                this.getTofTreeModel().resetLastBackloadUpdateFinishedMillis();
            }
            if (optionsDlg.shouldResetSharedFilesLastDownloaded()) {
                Thread t = new Thread(){

                    public void run() {
                        try {
                            FileListStorage.inst().resetLastDownloaded();
                        }
                        catch (Throwable tt) {
                            logger.log(Level.SEVERE, "Exception during resetLastDownloaded", tt);
                        }
                    }
                };
                t.start();
            }
            this.tofTree.updateTree();
        }
    }

    private void optionsManageLocalIdentitiesMenuItem_actionPerformed(ActionEvent e) {
        ManageLocalIdentitiesDialog dlg = new ManageLocalIdentitiesDialog();
        dlg.setVisible(true);
        if (dlg.isIdentitiesImported()) {
            this.tofTree_actionPerformed(null);
        }
    }

    private void optionsManageIdentitiesMenuItem_actionPerformed(ActionEvent e) {
        new IdentitiesBrowser(this).startDialog();
    }

    public void renameFolder(Folder selected) {
        if (selected == null) {
            return;
        }
        String newname = null;
        do {
            if ((newname = JOptionPane.showInputDialog(this, this.language.getString("MainFrame.dialog.renameFolder") + ":\n", selected.getName())) != null) continue;
            return;
        } while (newname.length() == 0);
        selected.setName(newname);
        this.updateTofTree(selected);
    }

    @Override
    public void languageChanged(LanguageEvent e) {
        this.translateMainMenu();
        LanguageGuiSupport.getInstance().translateLanguageMenu();
        this.translateButtons();
    }

    public void setPanelEnabled(String title, boolean enabled) {
        int position = this.getTabbedPane().indexOfTab(title);
        if (position != -1) {
            this.getTabbedPane().setEnabledAt(position, enabled);
        }
    }

    public void setTofTree(TofTree tofTree) {
        this.tofTree = tofTree;
    }

    public void setTofTreeModel(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    public void timer_actionPerformed() {
        ++this.counter;
        RunningMessageThreadsInformation msgInfo = this.tofTree.getRunningBoardUpdateThreads().getRunningMessageThreadsInformation();
        FileTransferInformation fileInfo = Core.getInstance().getFileTransferManager().getFileTransferInformation();
        if (Core.isFreenetOnline() && this.counter % 15L == 0L && this.isAutomaticBoardUpdateEnabled() && msgInfo.getDownloadingBoardCount() < frostSettings.getIntValue("automaticUpdate.concurrentBoardUpdates")) {
            Board nextBoard = BoardUpdateBoardSelector.selectNextBoard(this.tofTreeModel);
            if (nextBoard != null) {
                this.tofTree.updateBoard(nextBoard);
                logger.info("*** Automatic board update started for: " + nextBoard.getName());
            } else {
                logger.info("*** Automatic board update - min update interval not reached.  waiting...");
            }
        }
        DateTime now = new DateTime(DateTimeZone.UTC);
        if (this.getTodaysDateMillis() == 0L || this.counter % 60L == 0L) {
            long millis = now.toDateMidnight().getMillis();
            if (this.getTodaysDateMillis() != millis) {
                this.setTodaysDateMillis(millis);
            }
        }
        this.timeLabel.setText(DateFun.FORMAT_DATE_VISIBLE.print(now) + " - " + DateFun.FORMAT_TIME_VISIBLE.print(now));
        this.getStatusBar().setStatusBarInformations(fileInfo, msgInfo, this.tofTreeModel.getSelectedNode().getName());
        Core.getInstance().getFileTransferManager().updateWaitingCountInPanels(fileInfo);
    }

    public long getTodaysDateMillis() {
        return this.todaysDateMillis;
    }

    private void setTodaysDateMillis(long v) {
        this.todaysDateMillis = v;
    }

    private void tofDisplayBoardInfoMenuItem_actionPerformed(ActionEvent e) {
        if (!BoardInfoFrame.isDialogShowing()) {
            BoardInfoFrame boardInfo = new BoardInfoFrame(this, this.tofTree);
            boardInfo.startDialog();
        }
    }

    private void tofDisplayBoardUpdateInformationMenuItem_actionPerformed(ActionEvent e) {
        if (!BoardUpdateInformationFrame.isDialogShowing()) {
            BoardUpdateInformationFrame boardInfo = new BoardUpdateInformationFrame(this, this.tofTree);
            boardInfo.startDialog();
        }
    }

    private void tofDisplayKnownBoardsMenuItem_actionPerformed(ActionEvent e) {
        KnownBoardsFrame knownBoards = new KnownBoardsFrame(this, this.tofTree);
        knownBoards.startDialog();
    }

    public void tofTree_actionPerformed(TreeSelectionEvent e) {
        this.tofTree_actionPerformed(e, false);
    }

    public void tofTree_actionPerformed(TreeSelectionEvent e, boolean reload) {
        AbstractNode node;
        int[] i = this.tofTree.getSelectionRows();
        if (i != null && i.length > 0) {
            frostSettings.setValue("tofTreeSelectedRow", i[0]);
        }
        if ((node = (AbstractNode)this.tofTree.getLastSelectedPathComponent()) == null) {
            return;
        }
        boolean showSentMessagesPanel = false;
        boolean showUnsentMessagesPanel = false;
        if (node.isBoard()) {
            int[] rows;
            this.removeBoardButton.setEnabled(true);
            this.renameFolderButton.setEnabled(false);
            this.configBoardButton.setEnabled(true);
            FrostMessageObject previousMessage = null;
            if (reload && (rows = this.getMessageTreeTable().getSelectedRows()) != null && rows.length > 0) {
                previousMessage = (FrostMessageObject)this.getMessageTableModel().getRow(rows[0]);
            }
            this.getMessagePanel().getMessageTable().setNewRootNode(new FrostMessageObject(true));
            this.getMessagePanel().updateMessageCountLabels(node);
            TOF.getInstance().updateTofTable((Board)node, previousMessage);
            this.getMessagePanel().getMessageTable().clearSelection();
        } else if (node.isFolder()) {
            this.getMessagePanel().getMessageTable().setNewRootNode(new FrostMessageObject(true));
            this.getMessagePanel().updateMessageCountLabels(node);
            this.renameFolderButton.setEnabled(true);
            if (node.isRoot()) {
                this.removeBoardButton.setEnabled(false);
            } else {
                this.removeBoardButton.setEnabled(true);
            }
            this.configBoardButton.setEnabled(false);
        } else if (node.isUnsentMessagesFolder()) {
            this.getMessagePanel().getMessageTable().setNewRootNode(new FrostMessageObject(true));
            this.removeBoardButton.setEnabled(false);
            this.configBoardButton.setEnabled(false);
            showUnsentMessagesPanel = true;
        } else if (node.isSentMessagesFolder()) {
            this.getMessagePanel().getMessageTable().setNewRootNode(new FrostMessageObject(true));
            this.removeBoardButton.setEnabled(false);
            this.configBoardButton.setEnabled(false);
            showSentMessagesPanel = true;
        }
        if (showSentMessagesPanel) {
            this.showSentMessagePanelInSplitpane();
        } else if (showUnsentMessagesPanel) {
            this.showUnsentMessagePanelInSplitpane();
        } else {
            this.showMessagePanelInSplitpane();
        }
    }

    private void translateButtons() {
        this.newBoardButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.newBoard"));
        this.newFolderButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.newFolder"));
        this.systemTrayButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.minimizeToSystemTray"));
        this.knownBoardsButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.displayListOfKnownBoards"));
        this.searchMessagesButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.searchMessages"));
        this.boardInfoButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.boardInformationWindow"));
        this.removeBoardButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.removeBoard"));
        this.renameFolderButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.renameFolder"));
        this.configBoardButton.setToolTipText(this.language.getString("MainFrame.toolbar.tooltip.configureBoard"));
    }

    private void translateMainMenu() {
        this.fileMenu.setText(this.language.getString("MainFrame.menu.file"));
        this.fileExitMenuItem.setText(this.language.getString("Common.exit"));
        this.fileStatisticsMenuItem.setText(this.language.getString("MainFrame.menu.file.statistics"));
        this.tofMenu.setText(this.language.getString("MainFrame.menu.news"));
        this.tofDisplayBoardInfoMenuItem.setText(this.language.getString("MainFrame.menu.news.displayBoardInformationWindow"));
        this.tofDisplayBoardUpdateInformationMenuItem.setText(this.language.getString("MainFrame.menu.news.displayBoardUpdateInformationMenuItem"));
        this.tofAutomaticUpdateMenuItem.setText(this.language.getString("MainFrame.menu.news.automaticBoardUpdate"));
        this.tofDisplayKnownBoards.setText(this.language.getString("MainFrame.menu.news.displayKnownBoards"));
        this.tofSearchMessages.setText(this.language.getString("MainFrame.menu.news.searchMessages"));
        this.optionsMenu.setText(this.language.getString("MainFrame.menu.options"));
        this.optionsPreferencesMenuItem.setText(this.language.getString("MainFrame.menu.options.preferences"));
        this.optionsManageLocalIdentitiesMenuItem.setText(this.language.getString("MainFrame.menu.options.manageLocalIdentities"));
        this.optionsManageIdentitiesMenuItem.setText(this.language.getString("MainFrame.menu.options.manageIdentities"));
        this.pluginMenu.setText(this.language.getString("MainFrame.menu.plugins"));
        this.pluginTranslateMenuItem.setText(this.language.getString("MainFrame.menu.plugins.translateFrost"));
        this.languageMenu.setText(this.language.getString("MainFrame.menu.language"));
        this.helpMenu.setText(this.language.getString("MainFrame.menu.help"));
        this.helpMemMonMenuItem.setText(this.language.getString("MainFrame.menu.help.showMemoryMonitor"));
        this.helpHelpMenuItem.setText(this.language.getString("MainFrame.menu.help.help"));
        this.helpAboutMenuItem.setText(this.language.getString("MainFrame.menu.help.aboutFrost"));
    }

    @Override
    public void updateSettings() {
        frostSettings.setValue("automaticUpdate", this.tofAutomaticUpdateMenuItem.isSelected());
    }

    public void displayNewMessageIcon(boolean showNewMessageIcon) {
        ImageIcon iconToSet;
        this.getStatusBar().showNewMessageIcon(showNewMessageIcon);
        if (JSysTrayIcon.getInstance() != null) {
            try {
                if (showNewMessageIcon) {
                    JSysTrayIcon.getInstance().setIcon(5);
                } else {
                    JSysTrayIcon.getInstance().setIcon(0);
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Exception during JSysTrayIcon.setIcon()", ex);
            }
        }
        if (showNewMessageIcon) {
            iconToSet = this.frameIconNewMessage;
            if (!System.getProperty("os.name").startsWith("Windows")) {
                String t = this.getTitle();
                if (!(t.equals("*") || t.startsWith("*") && t.endsWith("*"))) {
                    t = "*" + t + "*";
                }
                this.setTitle(t);
            }
        } else {
            iconToSet = this.frameIconDefault;
            if (!System.getProperty("os.name").startsWith("Windows")) {
                String t = this.getTitle();
                if (!t.equals("*") && t.startsWith("*") && t.endsWith("*")) {
                    t = t.substring(1, t.length() - 1);
                }
                this.setTitle(t);
            }
        }
        this.setIconImage(iconToSet.getImage());
    }

    public void updateTofTree(AbstractNode board) {
        if (board == null) {
            return;
        }
        this.tofTreeModel.nodeChanged(board);
        for (TreeNode parentFolder = board.getParent(); parentFolder != null; parentFolder = parentFolder.getParent()) {
            this.tofTreeModel.nodeChanged(parentFolder);
        }
    }

    public void setAutomaticBoardUpdateEnabled(boolean state) {
        this.tofAutomaticUpdateMenuItem.setSelected(state);
    }

    public boolean isAutomaticBoardUpdateEnabled() {
        return this.tofAutomaticUpdateMenuItem.isSelected();
    }

    private MemoryMonitor getMemoryMonitor() {
        if (this.memoryMonitor == null) {
            this.memoryMonitor = new MemoryMonitor();
        }
        return this.memoryMonitor;
    }

    private TranslationStartDialog getTranslationDialog() {
        return new TranslationStartDialog(this);
    }

    public void showHtmlHelp(String item) {
        if (!Core.isHelpHtmlSecure()) {
            return;
        }
        if (this.helpBrowser == null) {
            this.helpBrowser = new HelpBrowserFrame(frostSettings.getValue("locale"), "help/help.zip");
        }
        this.helpBrowser.setVisible(true);
        this.helpBrowser.showHelpPage(item);
    }

    public void startSearchMessagesDialog() {
        this.getSearchMessagesDialog().startDialog();
    }

    public void startSearchMessagesDialog(List<Board> l) {
        this.getSearchMessagesDialog().startDialog(l);
    }

    public SearchMessagesDialog getSearchMessagesDialog() {
        if (this.searchMessagesDialog == null) {
            this.searchMessagesDialog = new SearchMessagesDialog();
        }
        return this.searchMessagesDialog;
    }

    public void updateMessageCountLabels(Board board) {
        this.getMessagePanel().updateMessageCountLabels(board);
    }

    public TreeTableModelAdapter getMessageTableModel() {
        return this.getMessagePanel().getMessageTableModel();
    }

    public DefaultTreeModel getMessageTreeModel() {
        return this.getMessagePanel().getMessageTreeModel();
    }

    public MessageTreeTable getMessageTreeTable() {
        return this.getMessagePanel().getMessageTable();
    }

    public void activateGlassPane() {
        GlassPane aPane;
        this.showProgress();
        this.glassPane = aPane = GlassPane.mount(this, true);
        if (this.glassPane != null) {
            this.glassPane.setVisible(true);
        }
    }

    public void deactivateGlassPane() {
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
            this.glassPane = null;
        }
        this.hideProgress();
    }

    public void updateComponentTreesUI() {
        Frame[] appFrames = Frame.getFrames();
        JSkinnablePopupMenu[] appPopups = JSkinnablePopupMenu.getSkinnablePopupMenus();
        for (Frame frame : appFrames) {
            Window[] ownedWindows;
            SwingUtilities.updateComponentTreeUI(frame);
            for (Window element2 : ownedWindows = frame.getOwnedWindows()) {
                if (!(element2 instanceof Dialog)) continue;
                SwingUtilities.updateComponentTreeUI(element2);
            }
        }
        for (Container container : appPopups) {
            SwingUtilities.updateComponentTreeUI(container);
        }
        SwingUtilities.updateComponentTreeUI(this.getMessagePanel());
        SwingUtilities.updateComponentTreeUI(this.getSentMessagesPanel());
        SwingUtilities.updateComponentTreeUI(this.getUnsentMessagesPanel());
        this.repaint();
    }

    public static void enqueueStartupMessage(StartupMessage sm) {
        queuedStartupMessages.add(sm);
    }

    public void showStartupMessages() {
        for (StartupMessage sm : queuedStartupMessages) {
            sm.display(this);
        }
        StartupMessage.cleanup();
        queuedStartupMessages.clear();
        queuedStartupMessages = null;
    }

    private class WindowStateListener
    extends WindowAdapter {
        private WindowStateListener() {
        }

        public void windowStateChanged(WindowEvent e) {
            if ((e.getNewState() & 1) != 0 && Core.frostSettings.getBoolValue("minimizeToSystray") && JSysTrayIcon.getInstance() != null) {
                boolean wasMaximized = (e.getOldState() & 6) != 0;
                try {
                    if (wasMaximized) {
                        JSysTrayIcon.getInstance().showWindow(JSysTrayIcon.SHOW_CMD_HIDE_WAS_MAXIMIZED);
                    } else {
                        JSysTrayIcon.getInstance().showWindow(JSysTrayIcon.SHOW_CMD_HIDE);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        public void windowClosing(WindowEvent e) {
            MainFrame.this.fileExitMenuItem_actionPerformed(null);
        }
    }
}

