/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.Folder;
import frost.gui.KnownBoardsManager;
import frost.storage.perst.messages.MessageStorage;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TofTreeModel
extends DefaultTreeModel {
    private final DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();

    public TofTreeModel(TreeNode root) {
        super(root);
    }

    public void initialAssignPerstFrostBoardObjects() {
        LinkedList<Board> boardList = this.getAllBoards();
        for (Board b : boardList) {
            MessageStorage.inst().assignPerstFrostBoardObject(b);
        }
    }

    public void addNodeToTree(AbstractNode newNode) {
        AbstractNode selectedNode = this.getSelectedNode();
        Folder targetFolder = !selectedNode.isFolder() ? (Folder)selectedNode.getParent() : (Folder)selectedNode;
        this.addNodeToTree(newNode, targetFolder);
    }

    public void addNodeToTree(AbstractNode newNode, Folder targetFolder) {
        targetFolder.add(newNode);
        if (newNode.isBoard() && !MessageStorage.inst().assignPerstFrostBoardObject((Board)newNode)) {
            return;
        }
        int[] insertedIndex = new int[]{targetFolder.getChildCount() - 1};
        this.nodesWereInserted(targetFolder, insertedIndex);
    }

    public void removeNode(AbstractNode node, boolean removeFromDatabase) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (node != null && parent != null) {
            final LinkedList<Board> boardsToDelete = new LinkedList<Board>();
            if (removeFromDatabase) {
                if (node.isFolder()) {
                    Enumeration<AbstractNode> e = node.breadthFirstEnumeration();
                    while (e.hasMoreElements()) {
                        AbstractNode b = e.nextElement();
                        if (b.isFolder()) continue;
                        boardsToDelete.add((Board)b);
                    }
                } else if (node.isBoard()) {
                    boardsToDelete.add((Board)node);
                }
            }
            KnownBoardsManager.addNewKnownBoards(boardsToDelete);
            DefaultMutableTreeNode nextSelectedNode = node.getPreviousSibling();
            if (nextSelectedNode == null && (nextSelectedNode = node.getNextSibling()) == null) {
                nextSelectedNode = parent;
            }
            TreePath nextSelectionPath = new TreePath(this.getPathToRoot(nextSelectedNode));
            int[] childIndices = new int[]{parent.getIndex(node)};
            Object[] removedChilds = new Object[]{node};
            node.removeFromParent();
            this.nodesWereRemoved(parent, childIndices, removedChilds);
            this.selectionModel.setSelectionPath(nextSelectionPath);
            if (!boardsToDelete.isEmpty()) {
                Thread worker = new Thread(){

                    public void run() {
                        for (Board board : boardsToDelete) {
                            MessageStorage.inst().removeBoard(board);
                        }
                    }
                };
                worker.start();
            }
        }
    }

    public LinkedList<Board> getAllBoards() {
        LinkedList<Board> boards = new LinkedList<Board>();
        Enumeration<AbstractNode> e = this.getRoot().depthFirstEnumeration();
        while (e.hasMoreElements()) {
            AbstractNode child = e.nextElement();
            if (!child.isBoard()) continue;
            boards.add((Board)child);
        }
        return boards;
    }

    @Override
    public AbstractNode getRoot() {
        return (AbstractNode)super.getRoot();
    }

    public void resetLastBackloadUpdateFinishedMillis() {
        Enumeration<AbstractNode> e = this.getRoot().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            AbstractNode child = e.nextElement();
            if (!child.isBoard()) continue;
            ((Board)child).setLastBackloadUpdateFinishedMillis(0L);
        }
    }

    public Board getBoardByName(String boardName) {
        if (boardName == null) {
            return null;
        }
        Enumeration<AbstractNode> e = this.getRoot().depthFirstEnumeration();
        while (e.hasMoreElements()) {
            AbstractNode child = e.nextElement();
            if (!child.isBoard() || child.getName().compareToIgnoreCase(boardName) != 0) continue;
            return (Board)child;
        }
        return null;
    }

    public AbstractNode getSelectedNode() {
        AbstractNode node;
        TreePath selectedPath = this.selectionModel.getSelectionPath();
        if (selectedPath != null) {
            node = (AbstractNode)selectedPath.getLastPathComponent();
        } else {
            node = this.getRoot();
            this.selectionModel.setSelectionPath(new TreePath(node));
        }
        return node;
    }

    TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }
}

