/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import frost.crypt.SignMetaData;
import frost.identities.LocalIdentity;
import frost.util.XMLTools;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EncryptMetaData
extends SignMetaData {
    private static final Logger logger = Logger.getLogger(EncryptMetaData.class.getName());
    String recipient;

    public EncryptMetaData(Element el) throws SAXException {
        try {
            this.loadXMLElement(el);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
            throw e;
        }
    }

    public EncryptMetaData(byte[] encrypted_data, LocalIdentity myId, String recipient) {
        super(encrypted_data, myId);
        assert (recipient != null);
        this.recipient = recipient;
    }

    public Element getXMLElement(Document container) {
        Element el = super.getXMLElement(container);
        if (this.recipient == null) {
            logger.log(Level.SEVERE, "getXMLElement: recipient is null, this is not allowed!");
            return null;
        }
        Element rec = container.createElement("Recipient");
        CDATASection cdata = container.createCDATASection(this.recipient);
        rec.appendChild(cdata);
        el.appendChild(rec);
        return el;
    }

    public void loadXMLElement(Element e) throws SAXException {
        super.loadXMLElement(e);
        if (XMLTools.getChildElementsByTagName(e, "Recipient").size() > 0) {
            this.recipient = XMLTools.getChildElementsCDATAValue(e, "Recipient");
        }
        assert (this.recipient != null && this.recipient.length() > 0);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public int getType() {
        return 1;
    }
}

