/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import frost.crypt.EncryptMetaData;
import frost.crypt.SignMetaData;
import frost.identities.Identity;
import frost.util.XMLTools;
import frost.util.XMLizable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class MetaData
implements XMLizable {
    private static final Logger logger = Logger.getLogger(MetaData.class.getName());
    public static final int SIGN = 0;
    public static final int ENCRYPT = 1;
    Identity person;

    public abstract int getType();

    public Identity getPerson() {
        return this.person;
    }

    public Element getXMLElement(Document container) {
        Element el = container.createElement("FrostMetaData");
        Element _person = this.person.getXMLElement(container);
        el.appendChild(_person);
        Element _person_old = this.person.getXMLElement_old(container);
        el.appendChild(_person_old);
        return el;
    }

    public static MetaData getInstance(Element e) {
        if (e == null) {
            logger.log(Level.SEVERE, "MetaData.getInstance(): The provided XML element is null.");
            return null;
        }
        if (!e.getNodeName().equals("FrostMetaData")) {
            logger.log(Level.SEVERE, "MetaData.getInstance(): This is no FrostMetaData XML element.");
            return null;
        }
        try {
            if (XMLTools.getChildElementsByTagName(e, "Recipient").size() == 0) {
                return new SignMetaData(e);
            }
            return new EncryptMetaData(e);
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, "Exception thrown in getInstance(byte [] body, Element e)", ex);
            return null;
        }
    }
}

