/*
 * Decompiled with CFR 0.152.
 */
package frost.ext;

import frost.ext.ExecResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Execute {
    private static final int BUFF_SIZE = 10240;

    public static ExecResult run_wait(String[] cmd) {
        return Execute.run_wait(cmd, "UTF-8");
    }

    public static ExecResult run_wait(String[] cmd, String cs) {
        ExecResult result = new ExecResult();
        try {
            char[] cbuf = new char[10240];
            result.proc = Execute.runtimeExec(cmd);
            InputStream isStdOut = result.proc.getInputStream();
            InputStream isStdErr = result.proc.getErrorStream();
            result.stdOut = new StringBuilder();
            InputStreamReader iSReader = new InputStreamReader(isStdOut, cs);
            BufferedReader reader = new BufferedReader(iSReader);
            int count = 0;
            while (count != -1) {
                count = reader.read(cbuf, 0, 10240);
                if (count == -1) continue;
                result.stdOut.append(cbuf, 0, count);
            }
            reader.close();
            result.stdErr = new StringBuilder();
            iSReader = new InputStreamReader(isStdErr, cs);
            reader = new BufferedReader(iSReader);
            count = 0;
            while (count != -1) {
                count = reader.read(cbuf, 0, 10240);
                if (count == -1) continue;
                result.stdOut.append(cbuf, 0, count);
            }
            reader.close();
            result.proc.waitFor();
            result.retcode = result.proc.exitValue();
        }
        catch (Throwable t) {
            result.error = t;
        }
        return result;
    }

    public static Process runtimeExec(String[] cmd) throws IOException {
        Process p;
        if (Execute.isWindows()) {
            StringBuilder winCmd = new StringBuilder();
            for (int i = 0; i < cmd.length; ++i) {
                winCmd.append(' ');
                if (cmd[i].indexOf(32) > -1) {
                    winCmd.append("\"\" ");
                    winCmd.append('\"');
                    winCmd.append(cmd[i]);
                    winCmd.append('\"');
                    continue;
                }
                winCmd.append(cmd[i]);
            }
            p = Runtime.getRuntime().exec(winCmd.toString());
        } else {
            p = Runtime.getRuntime().exec(cmd);
        }
        return p;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;
    }
}

