/*
 * Decompiled with CFR 0.152.
 */
package frost.ext;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class JSysTrayIcon {
    private static int ERR_NO_ERROR = 0;
    private static int ERR_INVALID_PARAM = 1;
    private static int ERR_WINDOW_NOT_FOUND = 2;
    private static int ERR_ICON_NOT_FOUND = 3;
    public static int SHOW_CMD_HIDE = 1;
    public static int SHOW_CMD_SHOW = 2;
    public static int SHOW_CMD_HIDE_WAS_MAXIMIZED = 3;
    private static boolean libLoaded = false;
    private static Vector<JSysTrayIcon> iconList = new Vector();
    private int systrayHandle = 0;
    private String windowTitle = null;
    private static JSysTrayIcon sysTrayIcon = null;

    private native int nativeShowWindow(String var1, int var2);

    private native int nativeCreateSystrayIcon(int var1, String var2, String var3);

    private native int nativeModifySystrayIcon(int var1, int var2, String var3, String var4);

    private native int nativeDeleteSystrayIcon(int var1);

    public JSysTrayIcon(int iconIndex, String tooltipText, String windowTitle) throws IOException {
        if (!libLoaded) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                try {
                    System.loadLibrary("exec/JSysTray");
                    libLoaded = true;
                }
                catch (UnsatisfiedLinkError e) {
                    throw new IOException("Could not load JSysTray.dll: " + e.toString());
                }
            } else {
                throw new IOException("SysTrayIcon is not supported on this system.");
            }
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
        this.windowTitle = windowTitle;
        this.systrayHandle = this.nativeCreateSystrayIcon(iconIndex, tooltipText, windowTitle);
        if (this.systrayHandle == 0) {
            throw new IOException("Systray icon has not been created.");
        }
        iconList.addElement(this);
    }

    public void setIcon(int iconIndex) throws IOException {
        if (this.systrayHandle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int rc = this.nativeModifySystrayIcon(this.systrayHandle, iconIndex, null, null);
        if (rc == ERR_ICON_NOT_FOUND) {
            throw new IOException("The specified icon has not been found");
        }
        if (rc == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (rc != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been modified. rc=" + rc);
        }
    }

    public void setTooltip(String tooltipText) throws IOException {
        if (this.systrayHandle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int rc = this.nativeModifySystrayIcon(this.systrayHandle, -1, tooltipText, null);
        if (rc == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (rc != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been modified. rc=" + rc);
        }
    }

    public void setWindowTitle(String windowTitle) throws IOException {
        if (this.systrayHandle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        this.windowTitle = windowTitle;
        int rc = this.nativeModifySystrayIcon(this.systrayHandle, -1, null, this.windowTitle);
        if (rc == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (rc != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been modified. rc=" + rc);
        }
    }

    public void delete() throws IOException {
        if (this.systrayHandle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int rc = this.nativeDeleteSystrayIcon(this.systrayHandle);
        if (rc == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (rc != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been deleted. rc=" + rc);
        }
        this.systrayHandle = 0;
        this.windowTitle = null;
        iconList.removeElement(this);
    }

    public void showWindow(int showCmd) throws IOException {
        if (this.systrayHandle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int rc = this.nativeShowWindow(this.windowTitle, showCmd);
        if (rc == ERR_WINDOW_NOT_FOUND) {
            throw new IOException("The specified window has not been found");
        }
        if (rc == ERR_INVALID_PARAM) {
            throw new IOException("An invalod parameter has been specified");
        }
        if (rc != ERR_NO_ERROR) {
            throw new IOException("The Window state has not been changed. rc=" + rc);
        }
    }

    public static void createInstance(int iconIx, String tooltipTxt, String winTitle) throws Throwable {
        sysTrayIcon = new JSysTrayIcon(iconIx, tooltipTxt, winTitle);
    }

    public static JSysTrayIcon getInstance() {
        return sysTrayIcon;
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            Enumeration e = iconList.elements();
            while (e.hasMoreElements()) {
                JSysTrayIcon icon = (JSysTrayIcon)e.nextElement();
                try {
                    icon.delete();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

