/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.fcp.BoardKeyPair;
import frost.fcp.FcpHandler05;
import frost.fcp.FcpHandler07;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import frost.fcp.FreenetKeys;
import frost.fcp.NodeAddress;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.upload.FrostUploadItem;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FcpHandler {
    private static final Logger logger = Logger.getLogger(FcpHandler.class.getName());
    public static final int TYPE_MESSAGE = 1;
    public static final int TYPE_FILE = 2;
    public static final int MAX_MESSAGE_SIZE_07 = 81920;
    public static final int MAX_FILELIST_SIZE_07 = 540672;
    private static FcpHandler instance = null;
    public static final int FREENET_05 = 5;
    public static final int FREENET_07 = 7;
    private static int initializedVersion = -1;

    public static FcpHandler inst() {
        return instance;
    }

    public static boolean isFreenet05() {
        return initializedVersion == 5;
    }

    public static boolean isFreenet07() {
        return initializedVersion == 7;
    }

    public static void initializeFcp(List<String> nodes, int freenetVersion) throws UnsupportedOperationException {
        if (freenetVersion == 5) {
            instance = new FcpHandler05();
            instance.initialize(nodes);
            initializedVersion = freenetVersion;
            FreenetKeys.initializeFor05();
        } else if (freenetVersion == 7) {
            instance = new FcpHandler07();
            instance.initialize(nodes);
            initializedVersion = freenetVersion;
            FreenetKeys.initializeFor07();
        } else {
            logger.severe("Unsupported freenet version: " + freenetVersion);
            throw new UnsupportedOperationException("This Freenet version is not supported, must be 5 or 7: " + freenetVersion);
        }
    }

    public abstract void initialize(List<String> var1);

    public abstract List<NodeAddress> getNodes();

    public void goneOnline() {
    }

    public FcpResultGet getFile(int type, String key, Long size, File target, boolean doRedirect) {
        return this.getFile(type, key, size, target, doRedirect, false, -1, -1, true, null);
    }

    public FcpResultGet getFile(int type, String key, Long size, File target, boolean doRedirect, boolean fastDownload, int maxSize, int maxRetries) {
        return this.getFile(type, key, size, target, doRedirect, fastDownload, maxSize, maxRetries, true, null);
    }

    public abstract FcpResultGet getFile(int var1, String var2, Long var3, File var4, boolean var5, boolean var6, int var7, int var8, boolean var9, FrostDownloadItem var10);

    public FcpResultPut putFile(int type, String uri, File file, byte[] metadata, boolean doRedirect, boolean removeLocalKey, boolean doMime) {
        return this.putFile(type, uri, file, metadata, doRedirect, removeLocalKey, doMime, null);
    }

    public abstract FcpResultPut putFile(int var1, String var2, File var3, byte[] var4, boolean var5, boolean var6, boolean var7, FrostUploadItem var8);

    public abstract String generateCHK(File var1) throws Throwable;

    public abstract List<String> getNodeInfo() throws IOException, ConnectException;

    public abstract BoardKeyPair generateBoardKeyPair() throws IOException, ConnectException;
}

