/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

public class FcpResultPut {
    public static final int Success = 1;
    public static final int KeyCollision = 2;
    public static final int Error = 3;
    public static final int Retry = 4;
    public static final int NoConnection = 5;
    public static final FcpResultPut ERROR_RESULT = new FcpResultPut(3);
    public static final FcpResultPut NO_CONNECTION_RESULT = new FcpResultPut(5);
    private int resultVal;
    private String chkKey;
    private int returnCode = -1;
    private String codeDescription = null;
    private boolean isFatal = false;

    public FcpResultPut(int result) {
        this(result, null);
    }

    public FcpResultPut(int result, int rc, String cd, boolean fatal) {
        this(result, null);
        this.returnCode = rc;
        this.codeDescription = cd;
        this.isFatal = fatal;
    }

    public FcpResultPut(int result, String chk) {
        this.resultVal = result;
        this.chkKey = chk;
    }

    public boolean isSuccess() {
        return this.resultVal == 1;
    }

    public boolean isKeyCollision() {
        return this.resultVal == 2;
    }

    public boolean isError() {
        return this.resultVal == 3 || this.resultVal == 5;
    }

    public boolean isRetry() {
        return this.resultVal == 4;
    }

    public boolean isNoConnection() {
        return this.resultVal == 5;
    }

    public String getChkKey() {
        return this.chkKey;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getCodeDescription() {
        return this.codeDescription;
    }
}

