/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import freenet.client.ClientCHK;
import freenet.support.ArrayBucket;
import freenet.support.Bucket;
import freenet.support.FileBucket;
import frost.fcp.fcp05.FecBlock;
import frost.fcp.fcp05.FecSplitfile;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FecTools {
    private static Logger logger = Logger.getLogger(FecTools.class.getName());

    public static String generateCHK(File inputfile) {
        return FecTools.generateCHK(inputfile, 0L);
    }

    public static String generateCHK(File inputfile, long metalength) {
        if (inputfile == null || !inputfile.exists() || inputfile.length() == 0L) {
            return null;
        }
        FileBucket data = new FileBucket(inputfile);
        return FecTools.generateCHK(data, metalength);
    }

    public static String generateCHK(byte[] inputdata) {
        return FecTools.generateCHK(inputdata, 0L);
    }

    public static String generateCHK(byte[] inputdata, long metalength) {
        if (inputdata == null || inputdata.length == 0) {
            return null;
        }
        ArrayBucket data = new ArrayBucket(inputdata);
        return FecTools.generateCHK(data, metalength);
    }

    public static String generateCHK(Bucket inputbucket) {
        return FecTools.generateCHK(inputbucket, 0L);
    }

    public static String generateCHK(Bucket inputbucket, long metalength) {
        if (inputbucket == null || inputbucket.size() <= 0L) {
            return null;
        }
        try {
            long size = inputbucket.size();
            ClientCHK chk = new ClientCHK();
            byte[] tmpStorage = new byte[(int)chk.getTotalLength(size)];
            ArrayBucket ctBucket = new ArrayBucket(tmpStorage);
            String chkKey = null;
            chk.encode(inputbucket, metalength, (Bucket)ctBucket).close();
            chkKey = chk.getURI().toString();
            return chkKey;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in FecTools.generateCHK()", t);
            return null;
        }
    }

    public static FecSplitfile prepareFECSplitfile(File inputFile) throws Throwable {
        if (inputFile == null || !inputFile.isFile() || inputFile.length() == 0L) {
            return null;
        }
        FecSplitfile splitfile = new FecSplitfile(inputFile);
        try {
            splitfile.encode();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error while encoding FEC splitfile", t);
            return null;
        }
        List<FecBlock> datab = splitfile.getDataBlocks();
        List<FecBlock> checkb = splitfile.getCheckBlocks();
        int cnt = 0;
        for (FecBlock b : datab) {
            logger.finer("data_" + cnt + ": '" + b.getChkKey() + "'");
            ++cnt;
        }
        cnt = 0;
        for (FecBlock b : checkb) {
            logger.finer("check_" + cnt + ": '" + b.getChkKey() + "'");
            ++cnt;
        }
        return splitfile;
    }
}

