/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07;

import frost.MainFrame;
import frost.fcp.FcpResultPut;
import frost.fcp.fcp07.FcpConnection;
import frost.fcp.fcp07.FcpFactory;
import frost.fileTransfer.upload.FrostUploadItem;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class FcpInsert {
    private static final Logger logger = Logger.getLogger(FcpInsert.class.getName());

    public static FcpResultPut putFile(int type, String uri, File file, boolean doMime, FrostUploadItem ulItem) {
        if (file.length() == 0L) {
            logger.log(Level.SEVERE, "Error: Can't upload empty file: " + file.getPath());
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "FcpInsert: File " + file.getPath() + " is empty!", "Warning", 2);
            return FcpResultPut.ERROR_RESULT;
        }
        try {
            FcpConnection connection;
            try {
                connection = FcpFactory.getFcpConnectionInstance();
            }
            catch (ConnectException e1) {
                connection = null;
            }
            if (connection == null) {
                return FcpResultPut.NO_CONNECTION_RESULT;
            }
            FcpResultPut result = connection.putKeyFromFile(type, uri, file, false, doMime, ulItem);
            return result;
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "UnknownHostException", e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Throwable", e);
        }
        return FcpResultPut.ERROR_RESULT;
    }

    public static String generateCHK(File file) {
        if (file.length() == 0L) {
            logger.log(Level.SEVERE, "Error: Can't generate CHK for empty file: " + file.getPath());
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "FcpInsert: File " + file.getPath() + " is empty!", "Warning", 2);
            return null;
        }
        try {
            FcpConnection connection;
            try {
                connection = FcpFactory.getFcpConnectionInstance();
            }
            catch (ConnectException e1) {
                connection = null;
            }
            if (connection == null) {
                return null;
            }
            String generatedCHK = connection.generateCHK(file);
            return generatedCHK;
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "UnknownHostException", e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Throwable", e);
        }
        return null;
    }
}

