/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07;

import frost.fcp.NodeAddress;
import frost.fcp.fcp07.NodeMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FcpSocket {
    private static final Logger logger = Logger.getLogger(FcpSocket.class.getName());
    private static final int TIMEOUT = 3600000;
    private final NodeAddress nodeAddress;
    private Socket fcpSock;
    private BufferedInputStream fcpIn;
    private PrintStream fcpOut;
    private final BufferedOutputStream fcpRawOut;
    private boolean useDDA;
    private static long staticFcpConnectionId = 0L;

    public static synchronized String getNextFcpId() {
        StringBuilder sb = new StringBuilder().append("fcps-").append(System.currentTimeMillis()).append(staticFcpConnectionId++);
        return sb.toString();
    }

    public FcpSocket(NodeAddress na) throws UnknownHostException, IOException {
        this.nodeAddress = na;
        this.fcpSock = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpSock.setKeepAlive(true);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpRawOut = new BufferedOutputStream(this.fcpSock.getOutputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream(), false, "UTF-8");
        this.useDDA = na.isDirectDiskAccessTested() ? na.isDirectDiskAccessPossible() : false;
        this.doHandshake();
    }

    public static FcpSocket create(NodeAddress na) {
        try {
            FcpSocket newSocket = new FcpSocket(na);
            return newSocket;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception catched", t);
            return null;
        }
    }

    public NodeAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public boolean isDDA() {
        return this.useDDA;
    }

    public BufferedInputStream getFcpIn() {
        return this.fcpIn;
    }

    public PrintStream getFcpOut() {
        return this.fcpOut;
    }

    public BufferedOutputStream getFcpRawOut() {
        return this.fcpRawOut;
    }

    public Socket getFcpSock() {
        return this.fcpSock;
    }

    public void close() {
        if (this.fcpIn != null) {
            try {
                this.fcpIn.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.fcpIn = null;
        }
        if (this.fcpOut != null) {
            try {
                this.fcpOut.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.fcpOut = null;
        }
        if (this.fcpSock != null) {
            try {
                this.fcpSock.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fcpSock = null;
        }
    }

    public void doHandshake() throws IOException, ConnectException {
        this.fcpOut.println("ClientHello");
        this.fcpOut.println("Name=hello-" + FcpSocket.getNextFcpId());
        this.fcpOut.println("ExpectedVersion=2.0");
        this.fcpOut.println("EndMessage");
        this.fcpOut.flush();
        boolean isSuccess = false;
        NodeMessage nodeMsg = NodeMessage.readMessage(this.fcpIn);
        if (nodeMsg != null && nodeMsg.isMessageName("NodeHello")) {
            isSuccess = true;
        }
        if (!isSuccess) {
            throw new ConnectException();
        }
    }
}

