/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07.filepersistence;

import frost.fcp.fcp07.FcpMultiRequestConnectionTools;
import frost.fcp.fcp07.NodeMessage;
import frost.fcp.fcp07.NodeMessageListener;
import frost.fcp.fcp07.filepersistence.FcpPersistentGet;
import frost.fcp.fcp07.filepersistence.FcpPersistentPut;
import frost.fcp.fcp07.filepersistence.IFcpPersistentRequestsHandler;
import frost.util.Logging;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpPersistentQueue
implements NodeMessageListener {
    private final FcpMultiRequestConnectionTools fcpTools;
    private final IFcpPersistentRequestsHandler persistenceHandler;
    private final HashMap<String, FcpPersistentPut> uploadRequests = new HashMap();
    private final HashMap<String, FcpPersistentGet> downloadRequests = new HashMap();

    public FcpPersistentQueue(FcpMultiRequestConnectionTools tools, IFcpPersistentRequestsHandler pman) {
        this.fcpTools = tools;
        this.persistenceHandler = pman;
    }

    public void startThreads() {
        this.fcpTools.getFcpPersistentConnection().addNodeMessageListener(this);
        this.fcpTools.watchGlobal(true);
        this.fcpTools.listPersistentRequests();
    }

    public Map<String, FcpPersistentPut> getUploadRequests() {
        return this.getUploadRequestsCopy();
    }

    public Map<String, FcpPersistentGet> getDownloadRequests() {
        return this.getDownloadRequestsCopy();
    }

    public boolean isIdInGlobalQueue(String id) {
        if (this.downloadRequests.containsKey(id)) {
            return true;
        }
        return this.uploadRequests.containsKey(id);
    }

    public synchronized Map<String, FcpPersistentPut> getUploadRequestsCopy() {
        return (Map)this.uploadRequests.clone();
    }

    public synchronized Map<String, FcpPersistentGet> getDownloadRequestsCopy() {
        return (Map)this.downloadRequests.clone();
    }

    @Override
    public void connected() {
        this.persistenceHandler.connected();
        this.fcpTools.watchGlobal(true);
        this.fcpTools.listPersistentRequests();
    }

    @Override
    public void disconnected() {
        this.persistenceHandler.disconnected();
        this.uploadRequests.clear();
        this.downloadRequests.clear();
    }

    @Override
    public void handleNodeMessage(NodeMessage nm) {
    }

    @Override
    public void handleNodeMessage(String id, NodeMessage nm) {
        if (Logging.inst().doLogFcp2Messages()) {
            System.out.println(">>>RCV>>>>");
            System.out.println("MSG=" + nm);
            System.out.println("<<<<<<<<<<");
        }
        if (nm.isMessageName("PersistentGet")) {
            this.onPersistentGet(id, nm);
        } else if (nm.isMessageName("DataFound")) {
            this.onDataFound(id, nm);
        } else if (nm.isMessageName("GetFailed")) {
            this.onGetFailed(id, nm);
        } else if (nm.isMessageName("PersistentPut")) {
            this.onPersistentPut(id, nm);
        } else if (nm.isMessageName("PutSuccessful")) {
            this.onPutSuccessful(id, nm);
        } else if (nm.isMessageName("PutFailed")) {
            this.onPutFailed(id, nm);
        } else if (nm.isMessageName("SimpleProgress")) {
            this.onSimpleProgress(id, nm);
        } else if (nm.isMessageName("PersistentRequestRemoved")) {
            this.onPersistentRequestRemoved(id, nm);
        } else if (nm.isMessageName("PersistentRequestModified")) {
            this.onPersistentRequestModified(id, nm);
        } else if (nm.isMessageName("IdentifierCollision")) {
            this.onIdentifierCollision(id, nm);
        } else if (nm.isMessageName("ProtocolError")) {
            this.onProtocolError(id, nm);
        } else {
            System.out.println("### INFO - Unhandled msg: " + nm);
        }
    }

    protected void onPersistentGet(String id, NodeMessage nm) {
        if (this.downloadRequests.containsKey(id)) {
            FcpPersistentGet pg = this.downloadRequests.get(id);
            pg.setRequest(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
            return;
        }
        FcpPersistentGet fpg = new FcpPersistentGet(nm, id);
        this.downloadRequests.put(id, fpg);
        this.persistenceHandler.persistentRequestAdded(fpg);
    }

    protected void onDataFound(String id, NodeMessage nm) {
        if (!this.downloadRequests.containsKey(id)) {
            System.out.println("No item in download queue: " + nm);
        } else {
            FcpPersistentGet pg = this.downloadRequests.get(id);
            pg.setSuccess(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
        }
    }

    protected void onGetFailed(String id, NodeMessage nm) {
        if (!this.downloadRequests.containsKey(id)) {
            System.out.println("No item in download queue: " + nm);
        } else {
            FcpPersistentGet pg = this.downloadRequests.get(id);
            pg.setFailed(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
        }
    }

    protected void onPersistentPut(String id, NodeMessage nm) {
        if (this.uploadRequests.containsKey(id)) {
            FcpPersistentPut pg = this.uploadRequests.get(id);
            pg.setRequest(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
        } else {
            FcpPersistentPut fpg = new FcpPersistentPut(nm, id);
            this.uploadRequests.put(id, fpg);
            this.persistenceHandler.persistentRequestAdded(fpg);
        }
    }

    protected void onPutSuccessful(String id, NodeMessage nm) {
        if (!this.uploadRequests.containsKey(id)) {
            System.out.println("No item in upload queue: " + nm);
            return;
        }
        FcpPersistentPut pg = this.uploadRequests.get(id);
        pg.setSuccess(nm);
        this.persistenceHandler.persistentRequestUpdated(pg);
    }

    protected void onPutFailed(String id, NodeMessage nm) {
        if (!this.uploadRequests.containsKey(id)) {
            System.out.println("No item in upload queue: " + nm);
            return;
        }
        FcpPersistentPut pp = this.uploadRequests.get(id);
        pp.setFailed(nm);
        this.persistenceHandler.persistentRequestUpdated(pp);
    }

    protected void onSimpleProgress(String id, NodeMessage nm) {
        if (this.downloadRequests.containsKey(id)) {
            FcpPersistentGet pg = this.downloadRequests.get(id);
            pg.setProgress(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
        } else if (this.uploadRequests.containsKey(id)) {
            FcpPersistentPut pg = this.uploadRequests.get(id);
            pg.setProgress(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
        } else {
            System.out.println("No item in queue: " + nm);
            return;
        }
    }

    protected void onPersistentRequestRemoved(String id, NodeMessage nm) {
        if (this.downloadRequests.containsKey(id)) {
            FcpPersistentGet pg = this.downloadRequests.remove(id);
            this.persistenceHandler.persistentRequestRemoved(pg);
        } else if (this.uploadRequests.containsKey(id)) {
            FcpPersistentPut pg = this.uploadRequests.remove(id);
            this.persistenceHandler.persistentRequestRemoved(pg);
        } else {
            System.out.println("No item in queue: " + nm);
            return;
        }
    }

    protected void onPersistentRequestModified(String id, NodeMessage nm) {
        if (nm.isValueSet("PriorityClass")) {
            int newPriorityClass = nm.getIntValue("PriorityClass");
            if (this.downloadRequests.containsKey(id)) {
                FcpPersistentGet pg = this.downloadRequests.get(id);
                pg.setPriority(newPriorityClass);
                this.persistenceHandler.persistentRequestModified(pg);
            } else if (this.uploadRequests.containsKey(id)) {
                FcpPersistentPut pg = this.uploadRequests.get(id);
                pg.setPriority(newPriorityClass);
                this.persistenceHandler.persistentRequestModified(pg);
            } else {
                System.out.println("No item in queue: " + nm);
                return;
            }
        }
    }

    protected void onProtocolError(String id, NodeMessage nm) {
        if (this.downloadRequests.containsKey(id)) {
            FcpPersistentGet pg = this.downloadRequests.get(id);
            pg.setFailed(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
        } else if (this.uploadRequests.containsKey(id)) {
            FcpPersistentPut pg = this.uploadRequests.get(id);
            pg.setFailed(nm);
            this.persistenceHandler.persistentRequestUpdated(pg);
        } else {
            System.out.println("No item in queue, calling error handler: " + nm);
            this.persistenceHandler.persistentRequestError(id, nm);
        }
    }

    protected void onIdentifierCollision(String id, NodeMessage nm) {
        System.out.println("### ATTENTION ###: " + nm);
    }
}

