/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.fcp.FcpHandler;
import frost.fileTransfer.FilePointerFileContent;
import frost.util.FileAccess;
import frost.util.XMLTools;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class FilePointerFile {
    private static final Logger logger = Logger.getLogger(FilePointerFile.class.getName());
    private static final String TAG_FrostFilePointerFile = "FrostFilePointerFile";
    private static final String TAG_timestamp = "timestamp";
    private static final String TAG_CHKKeys = "CHKKeys";
    private static final String TAG_chk = "chk";

    public static boolean writePointerFile(FilePointerFileContent content, File targetFile) {
        Document doc = XMLTools.createDomDocument();
        if (doc == null) {
            logger.severe("Error - writePointerFile: factory could'nt create XML Document.");
            return false;
        }
        Element rootElement = doc.createElement(TAG_FrostFilePointerFile);
        doc.appendChild(rootElement);
        Element timeStampElement = doc.createElement(TAG_timestamp);
        Text timeStampText = doc.createTextNode(Long.toString(content.getTimestamp()));
        timeStampElement.appendChild(timeStampText);
        rootElement.appendChild(timeStampElement);
        Element rootChkElement = doc.createElement(TAG_CHKKeys);
        rootElement.appendChild(rootChkElement);
        for (String chkKey : content.getChkKeyStrings()) {
            Element nameElement = doc.createElement(TAG_chk);
            Text text = doc.createTextNode(chkKey);
            nameElement.appendChild(text);
            rootChkElement.appendChild(nameElement);
        }
        boolean writeOK = false;
        try {
            writeOK = XMLTools.writeXmlFile(doc, targetFile);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in writePointerFile/writeXmlFile", t);
        }
        if (writeOK && FcpHandler.isFreenet05()) {
            File tmp = new File(targetFile.getPath() + ".wfpftmp");
            if (!FileAccess.compressFileGZip(targetFile, tmp)) {
                return false;
            }
            targetFile.delete();
            if (!tmp.renameTo(targetFile)) {
                logger.severe("Error: rename failed: " + tmp.getPath() + "','" + targetFile.getPath() + "'");
                return false;
            }
        }
        return writeOK;
    }

    public static FilePointerFileContent readPointerFile(File sourceFile) {
        if (!sourceFile.isFile() || sourceFile.length() <= 0L) {
            return null;
        }
        if (FcpHandler.isFreenet05()) {
            File tmp = new File(sourceFile.getPath() + ".fpftmp");
            if (!FileAccess.decompressFileGZip(sourceFile, tmp)) {
                return null;
            }
            sourceFile.delete();
            if (!tmp.renameTo(sourceFile)) {
                logger.severe("Error: rename failed: " + tmp.getPath() + "','" + sourceFile.getPath() + "'");
                return null;
            }
        }
        Document d = null;
        try {
            d = XMLTools.parseXmlFile(sourceFile.getPath(), false);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in readPointerFile, during XML parsing", t);
            return null;
        }
        if (d == null) {
            logger.log(Level.SEVERE, "Could'nt parse the pointer file");
            return null;
        }
        Element rootNode = d.getDocumentElement();
        if (!rootNode.getTagName().equals(TAG_FrostFilePointerFile)) {
            logger.severe("Error: xml pointer file does not contain the root tag 'FrostFilePointerFile'");
            return null;
        }
        String timeStampStr = XMLTools.getChildElementsTextValue(rootNode, TAG_timestamp);
        if (timeStampStr == null) {
            logger.severe("Error: xml file does not contain the tag 'timestamp'");
            return null;
        }
        long timestamp = Long.parseLong(timeStampStr);
        List<Element> nodelist = XMLTools.getChildElementsByTagName(rootNode, TAG_CHKKeys);
        if (nodelist.size() != 1) {
            logger.severe("Error: xml pointer files must contain only one element 'CHKKeys'");
            return null;
        }
        Element rootChkNode = nodelist.get(0);
        LinkedList<String> chkKeyList = new LinkedList<String>();
        List<Element> xmlKeys = XMLTools.getChildElementsByTagName(rootChkNode, TAG_chk);
        for (Element el : xmlKeys) {
            Text txtname = (Text)el.getFirstChild();
            if (txtname == null) continue;
            String chkKey = txtname.getData();
            chkKeyList.add(chkKey);
        }
        FilePointerFileContent content = new FilePointerFileContent(timestamp, chkKeyList);
        return content;
    }
}

