/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.fcp.FcpHandler;
import frost.fileTransfer.FileRequestFileContent;
import frost.util.FileAccess;
import frost.util.XMLTools;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class FileRequestFile {
    private static final Logger logger = Logger.getLogger(FileRequestFile.class.getName());
    private static final String TAG_FrostFileRequestFile = "FrostFileRequestFile";
    private static final String TAG_timestamp = "timestamp";
    private static final String TAG_shaList = "shaList";
    private static final String TAG_sha = "sha";

    public static boolean writeRequestFile(FileRequestFileContent content, File targetFile) {
        Document doc = XMLTools.createDomDocument();
        if (doc == null) {
            logger.severe("Error - writeRequestFile: factory could'nt create XML Document.");
            return false;
        }
        Element rootElement = doc.createElement(TAG_FrostFileRequestFile);
        doc.appendChild(rootElement);
        Element timeStampElement = doc.createElement(TAG_timestamp);
        Text timeStampText = doc.createTextNode(Long.toString(content.getTimestamp()));
        timeStampElement.appendChild(timeStampText);
        rootElement.appendChild(timeStampElement);
        Element rootChkElement = doc.createElement(TAG_shaList);
        rootElement.appendChild(rootChkElement);
        for (String chkKey : content.getShaStrings()) {
            Element nameElement = doc.createElement(TAG_sha);
            Text text = doc.createTextNode(chkKey);
            nameElement.appendChild(text);
            rootChkElement.appendChild(nameElement);
        }
        boolean writeOK = false;
        try {
            writeOK = XMLTools.writeXmlFile(doc, targetFile);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in writeRequestFile/writeXmlFile", t);
        }
        if (writeOK && FcpHandler.isFreenet05()) {
            File tmp = new File(targetFile.getPath() + ".frftmp");
            if (!FileAccess.compressFileGZip(targetFile, tmp)) {
                return false;
            }
            targetFile.delete();
            if (!tmp.renameTo(targetFile)) {
                logger.severe("Error: rename failed: " + tmp.getPath() + "','" + targetFile.getPath() + "'");
                return false;
            }
        }
        return writeOK;
    }

    public static void main(String[] args) {
        File targetFile = new File("D:\\abc.def");
        File tmp = new File(targetFile.getPath() + ".frftmp");
        if (!FileAccess.compressFileGZip(targetFile, tmp)) {
            return;
        }
        targetFile.delete();
        tmp.renameTo(targetFile);
    }

    public static FileRequestFileContent readRequestFile(File sourceFile) {
        if (!sourceFile.isFile() || sourceFile.length() <= 0L) {
            return null;
        }
        if (FcpHandler.isFreenet05()) {
            File tmp = new File(sourceFile.getPath() + ".frftmp");
            if (!FileAccess.decompressFileGZip(sourceFile, tmp)) {
                return null;
            }
            sourceFile.delete();
            if (!tmp.renameTo(sourceFile)) {
                logger.severe("Error: rename failed: " + tmp.getPath() + "','" + sourceFile.getPath() + "'");
                return null;
            }
        }
        Document d = null;
        try {
            d = XMLTools.parseXmlFile(sourceFile.getPath(), false);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in readRequestFile, during XML parsing", t);
            return null;
        }
        if (d == null) {
            logger.log(Level.SEVERE, "Could'nt parse the request file");
            return null;
        }
        Element rootNode = d.getDocumentElement();
        if (!rootNode.getTagName().equals(TAG_FrostFileRequestFile)) {
            logger.severe("Error: xml request file does not contain the root tag 'FrostFileRequestFile'");
            return null;
        }
        String timeStampStr = XMLTools.getChildElementsTextValue(rootNode, TAG_timestamp);
        if (timeStampStr == null) {
            logger.severe("Error: xml file does not contain the tag 'timestamp'");
            return null;
        }
        long timestamp = Long.parseLong(timeStampStr);
        List<Element> nodelist = XMLTools.getChildElementsByTagName(rootNode, TAG_shaList);
        if (nodelist.size() != 1) {
            logger.severe("Error: xml request files must contain only one element 'shaList'");
            return null;
        }
        Element rootShaNode = nodelist.get(0);
        LinkedList<String> shaList = new LinkedList<String>();
        List<Element> xmlKeys = XMLTools.getChildElementsByTagName(rootShaNode, TAG_sha);
        for (Element el : xmlKeys) {
            Text txtname = (Text)el.getFirstChild();
            if (txtname == null) continue;
            String sha = txtname.getData();
            shaList.add(sha);
        }
        FileRequestFileContent content = new FileRequestFileContent(timestamp, shaList);
        return content;
    }
}

