/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.fileTransfer.FileRequestFileContent;
import frost.fileTransfer.FileSharingManager;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.SharedFilesCHKKeyManager;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.storage.perst.filelist.FileListStorage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRequestsManager {
    private static final Logger logger = Logger.getLogger(SharedFilesCHKKeyManager.class.getName());
    private static final int MAX_SHA_PER_REQUESTFILE = 350;
    private static final long MIN_LAST_UPLOADED = 10L;

    public static List<String> getRequestsToSend() {
        if (FileSharingManager.getFileListDownloadQueueSize() > 3) {
            return Collections.emptyList();
        }
        long now = System.currentTimeMillis();
        long before23hours = now - 82800000L;
        long before3days = now - 259200000L;
        long time12hoursInSeconds = 43200L;
        LinkedList<String> mustSendRequests = new LinkedList<String>();
        List<FrostDownloadItem> downloadModelItems = FileTransferManager.inst().getDownloadManager().getDownloadItemList();
        for (FrostDownloadItem dlItem : downloadModelItems) {
            FrostFileListFileObject sfo;
            if (!dlItem.isSharedFile() || !dlItem.isEnabled().booleanValue() || (sfo = dlItem.getFileListFileObject()).getLastReceived() < before3days || sfo.getRequestLastSent() > before23hours || sfo.getRequestLastReceived() > before23hours || dlItem.getKey() != null && dlItem.getKey().length() > 0 && dlItem.getState() != 4 && (long)dlItem.getRuntimeSecondsWithoutProgress() < 43200L) continue;
            mustSendRequests.add(sfo.getSha());
            if (mustSendRequests.size() != 350) continue;
            break;
        }
        return mustSendRequests;
    }

    public static void updateRequestsWereSuccessfullySent(List<String> requests) {
        long now = System.currentTimeMillis();
        List<FrostDownloadItem> downloadModelItems = FileTransferManager.inst().getDownloadManager().getDownloadItemList();
        for (String sha : requests) {
            for (FrostDownloadItem dlItem : downloadModelItems) {
                FrostFileListFileObject sfo;
                if (!dlItem.isSharedFile() || !(sfo = dlItem.getFileListFileObject()).getSha().equals(sha)) continue;
                sfo.setRequestsSentCount(sfo.getRequestsSentCount() + 1);
                sfo.setRequestLastSent(now);
            }
        }
        if (!FileListStorage.inst().beginExclusiveThreadTransaction()) {
            logger.severe("Failed to begin an EXCLUSIVE thread transaction, aborting.");
            return;
        }
        for (String sha : requests) {
            FileListStorage.inst().updateFrostFileListFileObjectAfterRequestSent(sha, now);
        }
        FileListStorage.inst().endThreadTransaction();
    }

    public static void processReceivedRequests(FileRequestFileContent content) {
        if (content == null || content.getShaStrings() == null || content.getShaStrings().size() == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long minDiff = 864000000L;
        long minLastUploaded = now - 864000000L;
        List<FrostDownloadItem> downloadModelItems = FileTransferManager.inst().getDownloadManager().getDownloadItemList();
        List<FrostSharedFileItem> sharedFilesModelItems = FileTransferManager.inst().getSharedFilesManager().getSharedFileItemList();
        for (String sha : content.getShaStrings()) {
            for (FrostDownloadItem dlItem : downloadModelItems) {
                FrostFileListFileObject sfo;
                if (!dlItem.isSharedFile() || !(sfo = dlItem.getFileListFileObject()).getSha().equals(sha)) continue;
                sfo.setRequestsReceivedCount(sfo.getRequestsReceivedCount() + 1);
                if (sfo.getRequestLastReceived() >= content.getTimestamp()) continue;
                sfo.setRequestLastReceived(content.getTimestamp());
            }
            for (FrostSharedFileItem sfo : sharedFilesModelItems) {
                if (!sfo.getSha().equals(sha)) continue;
                if (sfo.getRequestLastReceived() < content.getTimestamp()) {
                    sfo.setRequestLastReceived(content.getTimestamp());
                }
                sfo.setRequestsReceived(sfo.getRequestsReceived() + 1);
                if (sfo.isCurrentlyUploading() || !sfo.isValid() || sfo.getLastUploaded() >= minLastUploaded || sfo.getLastUploaded() >= content.getTimestamp()) continue;
                FileTransferManager.inst().getUploadManager().getModel().addNewUploadItemFromSharedFile(sfo);
                logger.log(Level.SEVERE, "INFO: Shared file upload started, file='" + sfo.getFilename() + "', timeNow=" + now + ", minLastUploaded=" + minLastUploaded + ", requestTimestamp=" + content.getTimestamp() + ", lastUploaded=" + sfo.getLastUploaded());
            }
        }
        if (!FileListStorage.inst().beginExclusiveThreadTransaction()) {
            logger.severe("Failed to begin an EXCLUSIVE thread transaction, aborting.");
            return;
        }
        for (String sha : content.getShaStrings()) {
            FileListStorage.inst().updateFrostFileListFileObjectAfterRequestReceived(sha, content.getTimestamp());
        }
        FileListStorage.inst().endThreadTransaction();
    }
}

