/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.download.DownloadTicker;
import frost.fileTransfer.download.FrostDownloadItem;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadThread
extends Thread {
    private static final Logger logger = Logger.getLogger(DownloadThread.class.getName());
    private final DownloadTicker ticker;
    private final String filename;
    private final Long size;
    private final String key;
    private final File targetFile;
    private final FrostDownloadItem downloadItem;

    public DownloadThread(DownloadTicker newTicker, FrostDownloadItem item, File target) {
        this.filename = item.getFilename();
        this.size = item.getFileSize();
        this.key = item.getKey();
        this.ticker = newTicker;
        this.downloadItem = item;
        this.targetFile = target;
    }

    public void run() {
        this.ticker.threadStarted();
        if (this.key == null) {
            this.ticker.threadFinished();
            return;
        }
        try {
            logger.info("FILEDN: Download of '" + this.filename + "' started.");
            FcpResultGet result = null;
            try {
                result = FcpHandler.inst().getFile(2, this.key, this.size, this.targetFile, true, false, -1, -1, false, this.downloadItem);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception thrown in getFile()", t);
            }
            boolean retryNow = FileTransferManager.inst().getDownloadManager().notifyDownloadFinished(this.downloadItem, result, this.targetFile);
            if (retryNow) {
                FileTransferManager.inst().getDownloadManager().startDownload(this.downloadItem);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Oo. EXCEPTION in requestThread.run", t);
        }
        this.ticker.threadFinished();
    }
}

