/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Core;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.PersistenceManager;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadPanel;
import frost.fileTransfer.download.DownloadThread;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.util.Mixed;
import java.io.File;

public class DownloadTicker
extends Thread {
    private final DownloadPanel panel;
    private int allocatedThreads = 0;
    private int runningThreads = 0;
    private int seconds = 0;
    private final Object threadCountLock = new Object();

    public DownloadTicker(DownloadPanel newPanel) {
        super("Download");
        this.panel = newPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateDownloadThread() {
        Object object = this.threadCountLock;
        synchronized (object) {
            ++this.allocatedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canAllocateDownloadThread() {
        Object object = this.threadCountLock;
        synchronized (object) {
            if (this.allocatedThreads < Core.frostSettings.getIntValue("downloadThreads")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseThread() {
        Object object = this.threadCountLock;
        synchronized (object) {
            if (this.allocatedThreads > 0) {
                --this.allocatedThreads;
            }
        }
    }

    public int getRunningThreads() {
        return this.runningThreads;
    }

    public void run() {
        super.run();
        while (true) {
            Mixed.wait(1000);
            if (!PersistenceManager.isPersistenceEnabled()) {
                this.startDownloadThread();
            }
            ++this.seconds;
            if (this.seconds <= 60) continue;
            this.seconds = 0;
            this.increaseDownloadItemRuntime(60);
        }
    }

    private void increaseDownloadItemRuntime(int incSecs) {
        if (FileTransferManager.inst().getPersistenceManager() != null && !FileTransferManager.inst().getPersistenceManager().isConnected()) {
            return;
        }
        DownloadModel model = FileTransferManager.inst().getDownloadManager().getModel();
        for (int x = 0; x < model.getItemCount(); ++x) {
            FrostDownloadItem item = (FrostDownloadItem)model.getItemAt(x);
            if (item == null || !item.isSharedFile() || item.getState() != 5) continue;
            item.addToRuntimeSecondsWithoutProgress(incSecs);
        }
    }

    void threadFinished() {
        --this.runningThreads;
        this.releaseThread();
    }

    void threadStarted() {
        ++this.runningThreads;
    }

    private void startDownloadThread() {
        if (Core.isFreenetOnline() && this.panel.isDownloadingActivated() && this.canAllocateDownloadThread()) {
            FrostDownloadItem dlItem = FileTransferManager.inst().getDownloadManager().selectNextDownloadItem();
            this.startDownload(dlItem);
        }
    }

    public boolean startDownload(FrostDownloadItem dlItem) {
        if (!Core.isFreenetOnline()) {
            return false;
        }
        if (dlItem == null || dlItem.getState() != 1) {
            return false;
        }
        dlItem.setDownloadStartedTime(System.currentTimeMillis());
        this.allocateDownloadThread();
        dlItem.setState(2);
        File targetFile = new File(Core.frostSettings.getValue("downloadDirectory") + dlItem.getFilename());
        DownloadThread newRequest = new DownloadThread(this, dlItem, targetFile);
        newRequest.start();
        return true;
    }
}

