/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Core;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.storage.perst.filelist.FileListStorage;
import frost.util.CopyToClipboardItem;
import frost.util.Mixed;
import frost.util.model.ModelItem;

public class FrostDownloadItem
extends ModelItem
implements CopyToClipboardItem {
    public static final transient int STATE_WAITING = 1;
    public static final transient int STATE_TRYING = 2;
    public static final transient int STATE_DONE = 3;
    public static final transient int STATE_FAILED = 4;
    public static final transient int STATE_PROGRESS = 5;
    public static final transient int STATE_DECODING = 6;
    private String fileName = null;
    private String targetPath = null;
    private long fileSize = -1L;
    private String key = null;
    private Boolean enabled = Boolean.TRUE;
    private int state = 1;
    private long downloadAddedTime = 0L;
    private long downloadStartedTime = 0L;
    private long downloadFinishedTime = 0L;
    private int retries = 0;
    private long lastDownloadStopTime = 0L;
    private String gqIdentifier = null;
    private boolean isLoggedToFile = false;
    private int runtimeSecondsWithoutProgress = 0;
    private int oldDoneBlocks = 0;
    private transient FrostFileListFileObject fileListFileObject = null;
    private transient int doneBlocks = 0;
    private transient int requiredBlocks = 0;
    private transient int totalBlocks = 0;
    private transient Boolean isFinalized = null;
    private transient String errorCodeDescription = null;
    private transient int priority = -1;
    private transient boolean isDirect = false;
    private transient boolean isExternal = false;
    private transient boolean internalRemoveExpected = false;
    private transient boolean stateShouldBeProgress = false;

    public FrostDownloadItem(String fileName, String key) {
        fileName = FileTransferManager.inst().getDownloadManager().ensureUniqueFilename(fileName);
        this.fileName = Mixed.makeFilename(fileName);
        this.key = key;
        this.gqIdentifier = this.buildGqIdentifier(fileName);
        this.downloadAddedTime = System.currentTimeMillis();
        this.state = 1;
    }

    public FrostDownloadItem(String fileName, String key, long s) {
        this(fileName, key);
        this.fileSize = s;
    }

    public FrostDownloadItem(FrostFileListFileObject newSfo, String newName) {
        newName = FileTransferManager.inst().getDownloadManager().ensureUniqueFilename(newName);
        FrostFileListFileObject sfo = null;
        FrostFileListFileObject updatedSfo = FileListStorage.inst().getFileBySha(newSfo.getSha());
        sfo = updatedSfo != null ? updatedSfo : newSfo;
        this.fileName = newName;
        this.fileSize = sfo.getSize();
        this.key = sfo.getKey();
        this.gqIdentifier = this.buildGqIdentifier(this.fileName);
        this.setFileListFileObject(sfo);
        this.downloadAddedTime = System.currentTimeMillis();
        this.state = 1;
    }

    public FrostDownloadItem(String newFilename, String newTargetPath, long newSize, String newKey, Boolean newEnabledownload, int newState, long newDownloadAddedTime, long newDownloadStartedTime, long newDownloadFinishedTime, int newRetries, long newLastDownloadStopTime, String newGqId, boolean newIsLoggedToFile, int newRuntimeSecondsWithoutProgress, int newOldDoneBlocks) {
        this.fileName = newFilename;
        this.targetPath = newTargetPath;
        this.fileSize = newSize;
        this.key = newKey;
        this.enabled = newEnabledownload;
        this.state = newState;
        this.downloadAddedTime = newDownloadAddedTime;
        this.downloadStartedTime = newDownloadStartedTime;
        this.downloadFinishedTime = newDownloadFinishedTime;
        this.retries = newRetries;
        this.lastDownloadStopTime = newLastDownloadStopTime;
        this.gqIdentifier = newGqId;
        this.isLoggedToFile = newIsLoggedToFile;
        this.runtimeSecondsWithoutProgress = newRuntimeSecondsWithoutProgress;
        this.oldDoneBlocks = newOldDoneBlocks;
        if (this.state == 5) {
            this.stateShouldBeProgress = true;
        }
        if (this.state != 3 && this.state != 4) {
            this.state = 1;
        }
    }

    public boolean isSharedFile() {
        return this.getFileListFileObject() != null;
    }

    public void setFileName(String s) {
        this.fileName = s;
    }

    public String getFilename() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long newFileSize) {
        this.fileSize = newFileSize;
        this.fireChange();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String newKey) {
        this.setKey(newKey, true);
    }

    public void setKey(String newKey, boolean fireChange) {
        this.key = newKey;
        if (fireChange) {
            this.fireChange();
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        this.state = newState;
        this.fireChange();
    }

    public long getLastDownloadStopTime() {
        return this.lastDownloadStopTime;
    }

    public void setLastDownloadStopTime(long val) {
        this.lastDownloadStopTime = val;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int newRetries) {
        this.retries = newRetries;
        this.fireChange();
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean newEnabled) {
        if (newEnabled == null && this.enabled != null) {
            boolean enable = this.enabled;
            newEnabled = new Boolean(!enable);
        }
        this.enabled = newEnabled;
        this.fireChange();
    }

    public int getDoneBlocks() {
        return this.doneBlocks;
    }

    public void setDoneBlocks(int newDoneBlocks) {
        this.doneBlocks = newDoneBlocks;
    }

    public int getRequiredBlocks() {
        return this.requiredBlocks;
    }

    public void setRequiredBlocks(int newRequiredBlocks) {
        this.requiredBlocks = newRequiredBlocks;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public void setTotalBlocks(int newTotalBlocks) {
        this.totalBlocks = newTotalBlocks;
    }

    public Boolean isFinalized() {
        return this.isFinalized;
    }

    public void setFinalized(boolean finalized) {
        this.isFinalized = finalized ? Boolean.TRUE : Boolean.FALSE;
    }

    public long getDownloadAddedMillis() {
        return this.downloadAddedTime;
    }

    public long getDownloadFinishedMillis() {
        return this.downloadFinishedTime;
    }

    public void setDownloadFinishedTime(long downloadFinishedTime) {
        this.downloadFinishedTime = downloadFinishedTime;
    }

    public long getDownloadStartedMillis() {
        return this.downloadStartedTime;
    }

    public void setDownloadStartedTime(long downloadStartedTime) {
        this.downloadStartedTime = downloadStartedTime;
    }

    public String getGqIdentifier() {
        return this.gqIdentifier;
    }

    public void setGqIdentifier(String gqId) {
        this.gqIdentifier = gqId;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public long getLastReceived() {
        if (this.getFileListFileObject() == null) {
            return 0L;
        }
        return this.getFileListFileObject().getLastReceived();
    }

    public long getLastUploaded() {
        if (this.getFileListFileObject() == null) {
            return 0L;
        }
        return this.getFileListFileObject().getLastUploaded();
    }

    public FrostFileListFileObject getFileListFileObject() {
        return this.fileListFileObject;
    }

    public void setFileListFileObject(FrostFileListFileObject sharedFileObject) {
        if (this.fileListFileObject != null) {
            this.fileListFileObject.removeListener(this);
        }
        int newState = -1;
        if (sharedFileObject != null && this.fileListFileObject != null && this.getState() == 4) {
            newState = 1;
        }
        this.fileListFileObject = sharedFileObject;
        if (this.fileListFileObject != null) {
            this.fileListFileObject.addListener(this);
        }
        this.fireValueChanged();
        if (newState > -1) {
            this.setState(newState);
        }
    }

    public void fireValueChanged() {
        if (this.fileListFileObject != null && this.fileListFileObject.getKey() != null && this.fileListFileObject.getKey().length() > 0) {
            this.setKey(this.fileListFileObject.getKey(), false);
        }
        if (this.isSharedFile() && this.getState() == 5 && this.oldDoneBlocks != this.getDoneBlocks()) {
            this.oldDoneBlocks = this.getDoneBlocks();
            this.resetRuntimeSecondsWithoutProgress();
        }
        super.fireChange();
    }

    private String buildGqIdentifier(String filename) {
        if (FcpHandler.isFreenet07()) {
            return "Frost-" + filename.replace(' ', '_') + "-" + System.currentTimeMillis() + Core.getCrypto().getSecureRandom().nextInt(10);
        }
        return null;
    }

    public String getErrorCodeDescription() {
        return this.errorCodeDescription;
    }

    public void setErrorCodeDescription(String errorCodeDescription) {
        this.errorCodeDescription = errorCodeDescription;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean e) {
        this.isExternal = e;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setDirect(boolean d) {
        this.isDirect = d;
        super.fireChange();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        super.fireChange();
    }

    public boolean isInternalRemoveExpected() {
        return this.internalRemoveExpected;
    }

    public void setInternalRemoveExpected(boolean internalRemoveExpected) {
        this.internalRemoveExpected = internalRemoveExpected;
        if (this.isSharedFile() && internalRemoveExpected) {
            this.resetRuntimeSecondsWithoutProgress();
        }
    }

    public String toString() {
        return this.getFilename();
    }

    public boolean isLoggedToFile() {
        return this.isLoggedToFile;
    }

    public void setLoggedToFile(boolean isLoggedToFile) {
        this.isLoggedToFile = isLoggedToFile;
    }

    public synchronized int getRuntimeSecondsWithoutProgress() {
        return this.runtimeSecondsWithoutProgress;
    }

    public synchronized void resetRuntimeSecondsWithoutProgress() {
        this.runtimeSecondsWithoutProgress = 0;
    }

    public synchronized void addToRuntimeSecondsWithoutProgress(int s) {
        this.runtimeSecondsWithoutProgress += s;
    }

    public int getOldDoneBlocks() {
        return this.oldDoneBlocks;
    }

    public boolean isStateShouldBeProgress() {
        return this.stateShouldBeProgress;
    }
}

