/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.search.FrostSearchItem;
import frost.util.model.ModelItem;
import frost.util.model.SortedModel;
import frost.util.model.SortedTableFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchModel
extends SortedModel {
    static final Logger logger = Logger.getLogger(SearchModel.class.getName());

    public SearchModel(SortedTableFormat f) {
        super(f);
    }

    public void addSearchItem(FrostSearchItem searchItem) {
        this.addItem(searchItem);
    }

    public void addItemsToDownloadTable(ModelItem[] selectedItems) {
        if (selectedItems == null) {
            return;
        }
        DownloadModel downloadModel = FileTransferManager.inst().getDownloadManager().getModel();
        for (int i = selectedItems.length - 1; i >= 0; --i) {
            FrostSearchItem searchItem = (FrostSearchItem)selectedItems[i];
            FrostFileListFileObject flf = searchItem.getFrostFileListFileObject();
            String filename = flf.getDisplayName();
            if (filename.indexOf("%") > 0) {
                try {
                    filename = URLDecoder.decode(filename, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    logger.log(Level.SEVERE, "Decode of HTML code failed", ex);
                }
            }
            FrostDownloadItem dlItem = new FrostDownloadItem(flf, filename);
            downloadModel.addDownloadItem(dlItem);
            searchItem.updateState();
        }
    }
}

