/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.sharing;

import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.SharedFileXmlFile;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.threads.FileListUploadThread;
import frost.util.CopyToClipboardItem;
import frost.util.DateFun;
import frost.util.model.ModelItem;
import java.io.File;
import java.util.List;

public class FrostSharedFileItem
extends ModelItem
implements CopyToClipboardItem {
    String sha = null;
    File file = null;
    long fileSize = 0L;
    String key = null;
    String owner = null;
    String comment = null;
    int rating = 0;
    String keywords = null;
    long lastUploaded = 0L;
    int uploadCount = 0;
    long refLastSent = 0L;
    long requestLastReceived = 0L;
    int requestsReceived = 0;
    long lastModified = 0L;
    boolean isValid = true;

    public FrostSharedFileItem(File newFile, String newOwner, String newSha) {
        this.file = newFile;
        this.fileSize = this.file.length();
        this.lastModified = newFile.lastModified();
        this.owner = newOwner;
        this.sha = newSha;
    }

    public FrostSharedFileItem(File newFile, long newFilesize, String newKey, String newSha, String newOwner, String newComment, int newRating, String newKeywords, long newLastUploaded, int newUploadCount, long newRefLastSent, long newRequestLastReceived, int newRequestsReceived, long newLastModified, boolean newIsValid) {
        this.sha = newSha;
        this.file = newFile;
        this.fileSize = newFilesize;
        this.key = newKey;
        this.owner = newOwner;
        this.comment = newComment;
        this.rating = newRating;
        this.keywords = newKeywords;
        this.lastUploaded = newLastUploaded;
        this.uploadCount = newUploadCount;
        this.refLastSent = newRefLastSent;
        this.requestLastReceived = newRequestLastReceived;
        this.requestsReceived = newRequestsReceived;
        this.lastModified = newLastModified;
        this.isValid = newIsValid;
    }

    public SharedFileXmlFile getSharedFileXmlFileInstance() {
        SharedFileXmlFile sfxf = new SharedFileXmlFile();
        sfxf.setSha(this.getSha());
        sfxf.setSize(this.getFileSize());
        sfxf.setKey(this.getKey());
        sfxf.setFilename(this.getFile().getName());
        if (this.getLastUploaded() != 0L) {
            sfxf.setLastUploaded(DateFun.FORMAT_DATE_EXT.print(this.getLastUploaded()));
        } else {
            sfxf.setLastUploaded(null);
        }
        sfxf.setComment(this.getComment());
        sfxf.setRating(this.getRating());
        sfxf.setKeywords(this.getKeywords());
        sfxf.ensureValidity();
        return sfxf;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.fireChange();
        this.itemWasChanged();
        this.userActionOccured();
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
        this.fireChange();
        this.itemWasChanged();
        this.userActionOccured();
    }

    public long getRefLastSent() {
        return this.refLastSent;
    }

    public void setRefLastSent(long refLastSent) {
        this.refLastSent = refLastSent;
    }

    public long getLastUploaded() {
        return this.lastUploaded;
    }

    public void setLastUploaded(long lastUploaded) {
        this.lastUploaded = lastUploaded;
        this.fireChange();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.fireChange();
        this.itemWasChanged();
        this.userActionOccured();
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
        this.fireChange();
        this.itemWasChanged();
        this.userActionOccured();
    }

    public long getRequestLastReceived() {
        return this.requestLastReceived;
    }

    public void setRequestLastReceived(long requestLastReceived) {
        this.requestLastReceived = requestLastReceived;
        this.fireChange();
    }

    public int getRequestsReceived() {
        return this.requestsReceived;
    }

    public void setRequestsReceived(int requestsReceived) {
        this.requestsReceived = requestsReceived;
        this.fireChange();
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void setUploadCount(int uploadCount) {
        this.uploadCount = uploadCount;
        this.fireChange();
    }

    public String getSha() {
        return this.sha;
    }

    public void itemWasChanged() {
        this.refLastSent = 0L;
    }

    public void userActionOccured() {
        FileListUploadThread.getInstance().userActionOccured();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String chkKey) {
        this.key = chkKey;
        this.itemWasChanged();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void notifySuccessfulUpload(String newKey) {
        this.setKey(newKey);
        this.setLastUploaded(System.currentTimeMillis());
        this.setUploadCount(this.getUploadCount() + 1);
        this.itemWasChanged();
    }

    public boolean isCurrentlyUploading() {
        List uploadItems = FileTransferManager.inst().getUploadManager().getModel().getItems();
        for (FrostUploadItem ulItem : uploadItems) {
            FrostSharedFileItem sfi = ulItem.getSharedFileItem();
            if (sfi != this) continue;
            return true;
        }
        return false;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
        if (isValid) {
            this.fireChange();
            this.itemWasChanged();
            this.userActionOccured();
        } else {
            this.fireChange();
        }
    }

    public String toString() {
        return this.getFilename();
    }
}

