/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.sharing;

import frost.Core;
import frost.MainFrame;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.sharing.SharedFilesModel;
import frost.fileTransfer.sharing.SharedFilesPanel;
import frost.fileTransfer.sharing.SharedFilesTableFormat;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFilesManager
implements PropertyChangeListener,
ExitSavable {
    private SharedFilesModel model;
    private SharedFilesPanel panel;

    public void initialize() throws StorageException {
        this.getPanel();
        this.getModel().initialize();
    }

    @Override
    public void exitSave() throws StorageException {
        this.getPanel().getTableFormat().saveTableLayout();
        this.getModel().exitSave();
    }

    public void addPanelToMainFrame(MainFrame mainFrame) {
        mainFrame.addPanel("MainFrame.tabbedPane.sharing", this.getPanel());
        Core.frostSettings.addPropertyChangeListener("disableFilesharing", this);
        this.updateFileSharingStatus();
    }

    public void selectTab() {
        MainFrame.getInstance().selectTabbedPaneTab("MainFrame.tabbedPane.sharing");
    }

    public SharedFilesPanel getPanel() {
        if (this.panel == null) {
            this.panel = new SharedFilesPanel();
            this.panel.setModel(this.getModel());
            this.panel.initialize();
        }
        return this.panel;
    }

    public void selectModelItem(FrostSharedFileItem sfItem) {
        int row = this.model.indexOf(sfItem);
        if (row > -1) {
            this.panel.getModelTable().getTable().getSelectionModel().setSelectionInterval(row, row);
            this.panel.getModelTable().getTable().scrollRectToVisible(this.panel.getModelTable().getTable().getCellRect(row, 0, true));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("disableFilesharing")) {
            this.updateFileSharingStatus();
        }
    }

    private void updateFileSharingStatus() {
        boolean disableFileSharing = Core.frostSettings.getBoolValue("disableFilesharing");
        MainFrame.getInstance().setPanelEnabled("MainFrame.tabbedPane.sharing", !disableFileSharing);
    }

    public List<FrostSharedFileItem> getSharedFileItemList() {
        return this.getModel().getItems();
    }

    public SharedFilesModel getModel() {
        if (this.model == null) {
            this.model = new SharedFilesModel(new SharedFilesTableFormat());
        }
        return this.model;
    }
}

