/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.sharing;

import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.FrostFilesStorage;
import frost.threads.FileListUploadThread;
import frost.util.model.ModelItem;
import frost.util.model.SortedModel;
import frost.util.model.SortedTableFormat;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedFilesModel
extends SortedModel
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(SharedFilesModel.class.getName());
    Timer timer;

    public SharedFilesModel(SortedTableFormat f) {
        super(f);
    }

    public synchronized boolean addNewSharedFile(FrostSharedFileItem itemToAdd, boolean replacePathIfFileExists) {
        for (int x = 0; x < this.getItemCount(); ++x) {
            FrostSharedFileItem item = (FrostSharedFileItem)this.getItemAt(x);
            if (!itemToAdd.getSha().equals(item.getSha())) continue;
            if (!replacePathIfFileExists) {
                return false;
            }
            File file = itemToAdd.getFile();
            item.setLastModified(file.lastModified());
            item.setFile(file);
            item.setValid(true);
            return true;
        }
        this.addItem(itemToAdd);
        FileListUploadThread.getInstance().userActionOccured();
        return true;
    }

    private synchronized void addConsistentSharedFileItem(FrostSharedFileItem itemToAdd) {
        this.addItem(itemToAdd);
    }

    public synchronized boolean containsItemWithSha(String sha) {
        for (int x = 0; x < this.getItemCount(); ++x) {
            FrostSharedFileItem sfItem = (FrostSharedFileItem)this.getItemAt(x);
            if (sfItem.getSha() == null || !sfItem.getSha().equals(sha)) continue;
            return true;
        }
        return false;
    }

    public synchronized void requestAllItems() {
        for (FrostSharedFileItem sfItem : this.data) {
            if (sfItem.isCurrentlyUploading()) continue;
            FileTransferManager.inst().getUploadManager().getModel().addNewUploadItemFromSharedFile(sfItem);
        }
    }

    public void requestItems(ModelItem[] items) {
        for (ModelItem element : items) {
            FrostSharedFileItem sfItem = (FrostSharedFileItem)element;
            if (sfItem.isCurrentlyUploading()) continue;
            FileTransferManager.inst().getUploadManager().getModel().addNewUploadItemFromSharedFile(sfItem);
        }
    }

    public void initialize() throws StorageException {
        List<FrostSharedFileItem> uploadItems;
        try {
            uploadItems = FrostFilesStorage.inst().loadSharedFiles();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error loading shared file items", e);
            throw new StorageException("Error loading shared file items");
        }
        for (FrostSharedFileItem di : uploadItems) {
            this.addConsistentSharedFileItem(di);
        }
    }

    public void exitSave() throws StorageException {
        List itemList = this.getItems();
        try {
            FrostFilesStorage.inst().saveSharedFiles(itemList);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error saving shared file items", e);
            throw new StorageException("Error saving shared file items");
        }
    }
}

