/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.sharing;

import frost.Core;
import frost.identities.LocalIdentity;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SharedFilesOwnerDialog
extends JDialog {
    public static int OK = 1;
    public static int CANCEL = 2;
    private final String title;
    private int returnCode = CANCEL;
    private String choosedIdentity = null;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel mainPanel = null;
    private JButton Bcancel = null;
    private JButton Bok = null;
    private JLabel LaskForIdentity = null;
    private JComboBox CBidentities = null;
    private JLabel LaskIfToReplace = null;
    private JRadioButton RBignoreExistingFile = null;
    private JRadioButton RBreplaceExistingFilePath = null;
    private ButtonGroup BGaskIfToReplace = null;
    private final Frame parent;
    private boolean replacePathIfFileExists = false;
    private final Language language = Language.getInstance();

    public SharedFilesOwnerDialog(Frame newParent, String newTitle) {
        super(newParent);
        this.title = newTitle;
        this.parent = newParent;
        this.setModal(true);
        this.initialize();
        this.pack();
    }

    private void initialize() {
        this.setSize(397, 213);
        this.setTitle(this.title);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getBok(), null);
            this.buttonPanel.add((Component)this.getBcancel(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.LaskForIdentity = new JLabel(this.language.getString("SharedFilesOwnerDialog.askForIdentity") + ":");
            this.LaskIfToReplace = new JLabel(this.language.getString("SharedFilesOwnerDialog.askIfToReplace") + ":");
            this.RBignoreExistingFile = new JRadioButton(this.language.getString("SharedFilesOwnerDialog.ignoreNewFile"));
            this.RBreplaceExistingFilePath = new JRadioButton(this.language.getString("SharedFilesOwnerDialog.replaceExistingFilePath"));
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            this.mainPanel.add((Component)this.LaskForIdentity, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 20, 10, 5);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            this.mainPanel.add((Component)this.getCBidentities(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            this.mainPanel.add((Component)this.LaskIfToReplace, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 20, 0, 5);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            this.mainPanel.add((Component)this.RBignoreExistingFile, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(2, 20, 10, 5);
            this.mainPanel.add((Component)this.RBreplaceExistingFilePath, gridBagConstraints);
            this.BGaskIfToReplace = new ButtonGroup();
            this.BGaskIfToReplace.add(this.RBignoreExistingFile);
            this.BGaskIfToReplace.add(this.RBreplaceExistingFilePath);
            this.RBignoreExistingFile.setSelected(true);
        }
        return this.mainPanel;
    }

    private JButton getBcancel() {
        if (this.Bcancel == null) {
            this.Bcancel = new JButton(this.language.getString("Common.cancel"));
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SharedFilesOwnerDialog.this.returnCode = CANCEL;
                    SharedFilesOwnerDialog.this.setVisible(false);
                }
            });
        }
        return this.Bcancel;
    }

    private JButton getBok() {
        if (this.Bok == null) {
            this.Bok = new JButton(this.language.getString("Common.ok"));
            this.Bok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SharedFilesOwnerDialog.this.returnCode = OK;
                    SharedFilesOwnerDialog.this.choosedIdentity = (String)SharedFilesOwnerDialog.this.getCBidentities().getSelectedItem();
                    SharedFilesOwnerDialog.this.replacePathIfFileExists = SharedFilesOwnerDialog.this.RBreplaceExistingFilePath.isSelected();
                    SharedFilesOwnerDialog.this.setVisible(false);
                }
            });
        }
        return this.Bok;
    }

    private JComboBox getCBidentities() {
        if (this.CBidentities == null) {
            this.CBidentities = new JComboBox();
            Iterator<LocalIdentity> i$ = Core.getIdentities().getLocalIdentities().iterator();
            while (i$.hasNext()) {
                LocalIdentity localIdentity;
                LocalIdentity id = localIdentity = i$.next();
                this.CBidentities.addItem(id.getUniqueName());
            }
        }
        return this.CBidentities;
    }

    public String getChoosedIdentityName() {
        return this.choosedIdentity;
    }

    public int showDialog() {
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
        return this.returnCode;
    }

    public boolean isReplacePathIfFileExists() {
        return this.replacePathIfFileExists;
    }
}

