/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.sharing;

import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.gui.RatingStringProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SharedFilesPropertiesDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel mainPanel = null;
    private JButton Bok = null;
    private JButton Bcancel = null;
    private JLabel descLabel = null;
    private JLabel Lcomment = null;
    private JLabel Lkeywords = null;
    private JLabel Lrating = null;
    private JComboBox CBrating = null;
    private JTextField TFcomment = null;
    private JTextField TFkeywords = null;
    private boolean exitState;
    private String comment = null;
    private String keywords = null;
    private int rating = 0;

    public SharedFilesPropertiesDialog(Frame owner) {
        super(owner, true);
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void initialize() {
        this.setTitle("Shared files properties");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getBok(), null);
            this.buttonPanel.add((Component)this.getBcancel(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(3, 3, 5, 3);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(3, 3, 0, 3);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 3, 0, 3);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(3, 5, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            this.Lrating = new JLabel();
            this.Lrating.setText("Rating:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(3, 5, 5, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 3;
            this.Lkeywords = new JLabel();
            this.Lkeywords.setText("Keywords:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(3, 5, 0, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 2;
            this.Lcomment = new JLabel();
            this.Lcomment.setText("Comment:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridy = 0;
            this.descLabel = new JLabel();
            this.descLabel.setText("Edit properties of file 'abc' / multiple files");
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.descLabel, gridBagConstraints);
            this.mainPanel.add((Component)this.Lcomment, gridBagConstraints1);
            this.mainPanel.add((Component)this.Lkeywords, gridBagConstraints2);
            this.mainPanel.add((Component)this.Lrating, gridBagConstraints3);
            this.mainPanel.add((Component)this.getCBrating(), gridBagConstraints4);
            this.mainPanel.add((Component)this.getTFcomment(), gridBagConstraints5);
            this.mainPanel.add((Component)this.getTFkeywords(), gridBagConstraints6);
        }
        return this.mainPanel;
    }

    private JButton getBok() {
        if (this.Bok == null) {
            this.Bok = new JButton();
            this.Bok.setText("Ok");
            this.Bok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String str = SharedFilesPropertiesDialog.this.getTFcomment().getText().trim();
                    if (str.length() > 0) {
                        SharedFilesPropertiesDialog.this.comment = str;
                    } else {
                        SharedFilesPropertiesDialog.this.comment = null;
                    }
                    str = SharedFilesPropertiesDialog.this.getTFkeywords().getText().trim();
                    if (str.length() > 0) {
                        SharedFilesPropertiesDialog.this.keywords = str;
                    } else {
                        SharedFilesPropertiesDialog.this.keywords = null;
                    }
                    int selIx = SharedFilesPropertiesDialog.this.getCBrating().getSelectedIndex();
                    SharedFilesPropertiesDialog.this.rating = selIx;
                    SharedFilesPropertiesDialog.this.exitState = true;
                    SharedFilesPropertiesDialog.this.setVisible(false);
                }
            });
        }
        return this.Bok;
    }

    private JButton getBcancel() {
        if (this.Bcancel == null) {
            this.Bcancel = new JButton();
            this.Bcancel.setText("Cancel");
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SharedFilesPropertiesDialog.this.exitState = false;
                    SharedFilesPropertiesDialog.this.setVisible(false);
                }
            });
        }
        return this.Bcancel;
    }

    private JComboBox getCBrating() {
        if (this.CBrating == null) {
            this.CBrating = new JComboBox();
            for (int x = 0; x < RatingStringProvider.ratingStrings.length; ++x) {
                this.CBrating.addItem(RatingStringProvider.ratingStrings[x]);
            }
        }
        return this.CBrating;
    }

    private JTextField getTFcomment() {
        if (this.TFcomment == null) {
            this.TFcomment = new JTextField();
            this.TFcomment.setColumns(32);
            this.TFcomment.setDocument(new RestrictSizeDocument(100));
        }
        return this.TFcomment;
    }

    private JTextField getTFkeywords() {
        if (this.TFkeywords == null) {
            this.TFkeywords = new JTextField();
            this.TFkeywords.setColumns(32);
            this.TFkeywords.setDocument(new RestrictSizeDocument(100));
        }
        return this.TFkeywords;
    }

    public boolean startDialog(String fileName, int fileCount, FrostSharedFileItem defaults) {
        String labelText = fileName != null ? "Edit properties of file '" + fileName + "':" : "Edit properties of " + fileCount + " files:";
        this.descLabel.setText(labelText);
        if (defaults != null) {
            if (defaults.getComment() != null) {
                this.getTFcomment().setText(defaults.getComment());
            }
            if (defaults.getKeywords() != null) {
                this.getTFkeywords().setText(defaults.getKeywords());
            }
            this.getCBrating().setSelectedIndex(defaults.getRating());
        }
        this.exitState = false;
        this.setVisible(true);
        return this.exitState;
    }

    public String getComment() {
        return this.comment;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public int getRating() {
        return this.rating;
    }

    protected class RestrictSizeDocument
    extends PlainDocument {
        int maxChars;

        public RestrictSizeDocument(int maxChars) {
            this.maxChars = maxChars;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int availableSpace = this.maxChars - this.getLength();
            if (availableSpace > 0) {
                if (str.length() > availableSpace) {
                    str = str.substring(0, availableSpace);
                }
                super.insertString(offs, str, a);
            }
        }
    }
}

