/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultPut;
import frost.fcp.fcp05.FcpInsert;
import frost.fileTransfer.FileTransferInformation;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModel;
import frost.fileTransfer.upload.UploadPanel;
import frost.fileTransfer.upload.UploadTableFormat;
import frost.fileTransfer.upload.UploadTicker;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.util.FileAccess;
import frost.util.Mixed;
import frost.util.model.ModelItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadManager
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(UploadManager.class.getName());
    private UploadModel model;
    private UploadPanel panel;
    private UploadTicker ticker;
    private static final Comparator<FrostUploadItem> nextItemCmp = new Comparator<FrostUploadItem>(){

        @Override
        public int compare(FrostUploadItem value1, FrostUploadItem value2) {
            int blocksTodo2;
            int cmp1 = Mixed.compareLong(value1.getUploadAddedMillis(), value2.getUploadAddedMillis());
            if (cmp1 != 0) {
                return cmp1;
            }
            int blocksTodo1 = value1.getTotalBlocks() > 0 && value1.getDoneBlocks() > 0 ? value1.getTotalBlocks() - value1.getDoneBlocks() : (FcpHandler.isFreenet05() && value1.getFileSize() <= 786432L ? 1 : Integer.MAX_VALUE);
            int cmp2 = Mixed.compareInt(blocksTodo1, blocksTodo2 = value2.getTotalBlocks() > 0 && value2.getDoneBlocks() > 0 ? value2.getTotalBlocks() - value2.getDoneBlocks() : (FcpHandler.isFreenet05() && value2.getFileSize() <= 786432L ? 1 : Integer.MAX_VALUE));
            if (cmp2 != 0) {
                return cmp2;
            }
            return Mixed.compareLong(value1.getFileSize(), value2.getFileSize());
        }
    };

    public void initialize(List<FrostSharedFileItem> sharedFiles) throws StorageException {
        this.getPanel();
        this.getModel().initialize(sharedFiles);
        if (FcpHandler.isFreenet05()) {
            for (int x = 0; x < this.getModel().getItemCount(); ++x) {
                FrostUploadItem item = (FrostUploadItem)this.getModel().getItemAt(x);
                FcpInsert.updateProgress(item);
            }
        }
    }

    public void updateFileTransferInformation(FileTransferInformation infos) {
        int waitingItems = 0;
        int runningItems = 0;
        for (int x = 0; x < this.model.getItemCount(); ++x) {
            FrostUploadItem ulItem = (FrostUploadItem)this.model.getItemAt(x);
            if (ulItem.getState() != 1 && ulItem.getState() != 8) {
                ++waitingItems;
            }
            if (ulItem.getState() != 4) continue;
            ++runningItems;
        }
        infos.setUploadsRunning(runningItems);
        infos.setUploadsWaiting(waitingItems);
    }

    public void startTicker() {
        if (Core.isFreenetOnline()) {
            this.getTicker().start();
        }
    }

    @Override
    public void exitSave() throws StorageException {
        this.getPanel().getTableFormat().saveTableLayout();
        this.getModel().exitSave();
    }

    public void addPanelToMainFrame(MainFrame mainFrame) {
        mainFrame.addPanel("MainFrame.tabbedPane.uploads", this.getPanel());
    }

    public UploadPanel getPanel() {
        if (this.panel == null) {
            this.panel = new UploadPanel();
            this.panel.setModel(this.getModel());
            this.panel.initialize();
        }
        return this.panel;
    }

    private UploadTicker getTicker() {
        if (this.ticker == null) {
            this.ticker = new UploadTicker(this.getModel());
        }
        return this.ticker;
    }

    public UploadModel getModel() {
        if (this.model == null) {
            this.model = new UploadModel(new UploadTableFormat());
        }
        return this.model;
    }

    public void notifyUploadFinished(FrostUploadItem uploadItem, FcpResultPut result) {
        if (result != null && (result.isSuccess() || result.isKeyCollision())) {
            logger.info("Upload of " + uploadItem.getFile().getName() + " was successful.");
            uploadItem.setKey(result.getChkKey());
            if (uploadItem.isSharedFile()) {
                uploadItem.getSharedFileItem().notifySuccessfulUpload(result.getChkKey());
            }
            uploadItem.setEnabled(Boolean.FALSE);
            uploadItem.setState(1);
            uploadItem.setUploadFinishedMillis(System.currentTimeMillis());
            if (uploadItem.isSharedFile()) {
                this.getModel().notifySharedFileUploadWasSuccessful(uploadItem);
            } else if (Core.frostSettings.getBoolValue("logUploads") && !uploadItem.isLoggedToFile()) {
                String line = uploadItem.getKey() + "/" + uploadItem.getFile().getName();
                String fileName = Core.frostSettings.getValue("localdata.dir") + "Frost-Uploads.log";
                File targetFile = new File(fileName);
                FileAccess.appendLineToTextfile(targetFile, line);
                uploadItem.setLoggedToFile(true);
            }
            if (Core.frostSettings.getBoolValue("removeFinishedUploads")) {
                this.getModel().removeFinishedUploads();
            }
        } else {
            logger.warning("Upload of " + uploadItem.getFile().getName() + " was NOT successful.");
            if (result != null && result.isFatal()) {
                uploadItem.setEnabled(Boolean.FALSE);
                uploadItem.setState(8);
            } else {
                uploadItem.setRetries(uploadItem.getRetries() + 1);
                if (uploadItem.getRetries() > Core.frostSettings.getIntValue("uploadMaxRetries")) {
                    uploadItem.setEnabled(Boolean.FALSE);
                    uploadItem.setState(8);
                } else {
                    uploadItem.setState(7);
                }
            }
            if (result != null) {
                uploadItem.setErrorCodeDescription(result.getCodeDescription());
            }
        }
        uploadItem.setLastUploadStopTimeMillis(System.currentTimeMillis());
    }

    public boolean startUpload(FrostUploadItem ulItem) {
        if (FileTransferManager.inst().getPersistenceManager() != null) {
            return FileTransferManager.inst().getPersistenceManager().startUpload(ulItem);
        }
        return this.ticker.startUpload(ulItem);
    }

    public FrostUploadItem selectNextUploadItem() {
        ArrayList<FrostUploadItem> waitingItems = new ArrayList<FrostUploadItem>();
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < this.model.getItemCount(); ++i) {
            boolean itemIsEnabled;
            FrostUploadItem ulItem = (FrostUploadItem)this.model.getItemAt(i);
            boolean bl = itemIsEnabled = ulItem.isEnabled() == null ? true : ulItem.isEnabled();
            if (!itemIsEnabled || ulItem.isExternal() || FileTransferManager.inst().getPersistenceManager() != null && FileTransferManager.inst().getPersistenceManager().isDirectTransferInProgress(ulItem) || ulItem.getState() != 7 || FcpHandler.isFreenet05() && ulItem.getKey() == null) continue;
            long waittimeMillis = (long)Core.frostSettings.getIntValue("uploadRetriesWaitTime") * 60L * 1000L;
            if (currentTime - ulItem.getLastUploadStopTimeMillis() < waittimeMillis) continue;
            waitingItems.add(ulItem);
        }
        if (waitingItems.size() == 0) {
            return null;
        }
        if (waitingItems.size() > 1) {
            Collections.sort(waitingItems, nextItemCmp);
        }
        return (FrostUploadItem)waitingItems.get(0);
    }

    public void notifyUploadItemEnabledStateChanged(FrostUploadItem ulItem) {
        boolean itemIsEnabled;
        if (FileTransferManager.inst().getPersistenceManager() == null) {
            return;
        }
        if (ulItem.isExternal()) {
            return;
        }
        if (ulItem.getState() != 4) {
            return;
        }
        boolean bl = itemIsEnabled = ulItem.isEnabled() == null ? true : ulItem.isEnabled();
        if (itemIsEnabled) {
            int prio = Core.frostSettings.getIntValue("fcp2.defaultPriorityFileUpload");
            FileTransferManager.inst().getPersistenceManager().changeItemPriorites(new ModelItem[]{ulItem}, prio);
        } else {
            FileTransferManager.inst().getPersistenceManager().changeItemPriorites(new ModelItem[]{ulItem}, 6);
        }
    }
}

