/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.boards.Board;
import frost.gui.BoardsChooser;
import frost.gui.MessageWindow;
import frost.gui.SearchMessagesConfig;
import frost.gui.SearchMessagesResultTable;
import frost.gui.model.SearchMessagesTableModel;
import frost.messages.FrostMessageObject;
import frost.messages.FrostSearchResultMessageObject;
import frost.threads.SearchMessagesThread;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.JTranslatableTabbedPane;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.gui.tristatecheckbox.TristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMessagesDialog
extends JFrame
implements LanguageListener {
    private final Language language = Language.getInstance();
    private SearchMessagesConfig searchMessagesConfig = null;
    private String resultCountPrefix = null;
    private String startSearchStr = null;
    private String stopSearchStr = null;
    List<Board> chosedBoardsList = new ArrayList<Board>();
    SearchMessagesThread runningSearchThread = null;
    int resultCount;
    private JLabel LresultCount = null;
    private JRadioButton date_RBall = null;
    private JPanel PbuttonsRight = null;
    private JPanel PbuttonsLeft = null;
    private JButton BopenMsg = null;
    private JPanel Pattachments = null;
    private JCheckBox attachment_CBmustContainBoards = null;
    private JCheckBox attachment_CBmustContainFiles = null;
    private JButton Bhelp = null;
    private JPanel jContentPane = null;
    private JPanel contentPanel = null;
    private JPanel Pbuttons = null;
    private JButton Bsearch = null;
    private JButton Bcancel = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel Psearch = null;
    private JPanel PsearchResult = null;
    private JLabel Lsender = null;
    private JLabel Lcontent = null;
    private JTextField search_TFsender = null;
    private JTextField search_TFcontent = null;
    private JPanel Pdate = null;
    private JRadioButton date_RBdisplayed = null;
    private JRadioButton date_RBbetweenDates = null;
    private MDateEntryField date_TFstartDate = null;
    private JLabel date_Lto = null;
    private MDateEntryField date_TFendDate = null;
    private JRadioButton date_RBdaysBackward = null;
    private JTextField date_TFdaysBackward = null;
    private JPanel PtrustState = null;
    private JRadioButton truststate_RBdisplayed = null;
    private JRadioButton truststate_RBall = null;
    private JRadioButton truststate_RBchosed = null;
    private JPanel truststate_PtrustStates = null;
    private JCheckBox truststate_CBgood = null;
    private JCheckBox truststate_CBobserve = null;
    private JCheckBox truststate_CBcheck = null;
    private JCheckBox truststate_CBbad = null;
    private JCheckBox truststate_CBnone = null;
    private JCheckBox truststate_CBtampered = null;
    private JPanel Parchive = null;
    private JRadioButton archive_RBkeypoolAndArchive = null;
    private JRadioButton archive_RBkeypoolOnly = null;
    private JRadioButton archive_RBarchiveOnly = null;
    private JPanel Pboards = null;
    private JRadioButton boards_RBdisplayed = null;
    private JRadioButton boards_RBchosed = null;
    private JButton boards_Bchoose = null;
    private JTextField boards_TFchosedBoards = null;
    private TristateCheckBox search_CBprivateMsgsOnly = null;
    private TristateCheckBox search_CBflaggedMsgsOnly = null;
    private TristateCheckBox search_CBstarredMsgsOnly = null;
    private TristateCheckBox search_CBrepliedMsgsOnly = null;
    private JLabel LsearchResult = null;
    private JScrollPane jScrollPane = null;
    private SearchMessagesResultTable searchResultTable = null;
    private SearchMessagesTableModel searchMessagesTableModel = null;
    private ButtonGroup boards_buttonGroup = null;
    private ButtonGroup date_buttonGroup = null;
    private ButtonGroup truststate_buttonGroup = null;
    private ButtonGroup archive_buttonGroup = null;
    private JLabel Lsubject = null;
    private JTextField search_TFsubject = null;
    private final JCheckBox senderCaseCheckBox = new JCheckBox("");
    private final JCheckBox subjectCaseCheckBox = new JCheckBox("");
    private final JCheckBox contentCaseCheckBox = new JCheckBox("");
    HashSet previouslyEnabledComponents = new HashSet();

    public SearchMessagesDialog() {
        this.enableEvents(64L);
        this.initialize();
        this.languageChanged(null);
        this.loadWindowState();
        this.initializeWithDefaults();
        this.language.addLanguageListener(this);
    }

    public void startDialog() {
        this.getBoards_RBdisplayed().doClick();
        this.updateBoardTextField(null);
        this.setVisible(true);
    }

    public void startDialog(List<Board> l) {
        this.getBoards_RBchosed().doClick();
        this.updateBoardTextField(l);
        this.clearSearchResultTable();
        this.setVisible(true);
    }

    private JTextField getSearch_TFsubject() {
        if (this.search_TFsubject == null) {
            this.search_TFsubject = new JTextField();
        }
        return this.search_TFsubject;
    }

    private void initialize() {
        this.setTitle(this.language.getString("SearchMessages.title"));
        this.setIconImage(MiscToolkit.loadImageIcon("/data/toolbar/edit-find.png").getImage());
        this.setSize(new Dimension(700, 550));
        this.setContentPane(this.getJContentPane());
        this.getDate_buttonGroup();
        this.getBoards_buttonGroup();
        this.getTruststate_buttonGroup();
        this.getArchive_buttonGroup();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getContentPanel(), "Center");
            this.jContentPane.add((Component)this.getPbuttons(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add((Component)this.getJTabbedPane(), "North");
            this.contentPanel.add((Component)this.getPsearchResult(), "Center");
        }
        return this.contentPanel;
    }

    private JPanel getPbuttons() {
        if (this.Pbuttons == null) {
            this.Pbuttons = new JPanel();
            this.Pbuttons.setLayout(new BorderLayout());
            this.Pbuttons.add((Component)this.getPbuttonsRight(), "West");
            this.Pbuttons.add((Component)this.getJPanel(), "East");
        }
        return this.Pbuttons;
    }

    private JButton getBsearch() {
        if (this.Bsearch == null) {
            this.Bsearch = new JButton();
            this.Bsearch.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "startStopSearch");
            AbstractAction action = new AbstractAction(){

                public void actionPerformed(ActionEvent arg0) {
                    if (SearchMessagesDialog.this.getBsearch().isEnabled()) {
                        SearchMessagesDialog.this.startOrStopSearching();
                    }
                }
            };
            this.Bsearch.getActionMap().put("startStopSearch", action);
            this.Bsearch.addActionListener(action);
        }
        return this.Bsearch;
    }

    private JButton getBcancel() {
        if (this.Bcancel == null) {
            this.Bcancel = new JButton();
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SearchMessagesDialog.this.closePressed();
                }
            });
        }
        return this.Bcancel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTranslatableTabbedPane(this.language);
            this.jTabbedPane.addTab("SearchMessages.search", null, this.getPsearch(), null);
            this.jTabbedPane.addTab("SearchMessages.boards", null, this.getPboards(), null);
            this.jTabbedPane.addTab("SearchMessages.date", null, this.getPdate(), null);
            this.jTabbedPane.addTab("SearchMessages.trustState", null, this.getPtrustState(), null);
            this.jTabbedPane.addTab("SearchMessages.archive", null, this.getParchive(), null);
            this.jTabbedPane.addTab("SearchMessages.attachments", null, this.getPattachments(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getPsearch() {
        if (this.Psearch == null) {
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.fill = 2;
            gridBagConstraints29.gridy = 1;
            gridBagConstraints29.weightx = 1.0;
            gridBagConstraints29.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints29.gridx = 1;
            gridBagConstraints29.gridwidth = 4;
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.gridx = 0;
            gridBagConstraints110.insets = new Insets(1, 5, 1, 0);
            gridBagConstraints110.anchor = 17;
            gridBagConstraints110.gridy = 1;
            this.Lsubject = new JLabel();
            GridBagConstraints gridBagConstraints101 = new GridBagConstraints();
            gridBagConstraints101.gridx = 1;
            gridBagConstraints101.anchor = 18;
            gridBagConstraints101.insets = new Insets(1, 1, 1, 5);
            gridBagConstraints101.fill = 0;
            gridBagConstraints101.weighty = 1.0;
            gridBagConstraints101.gridy = 3;
            GridBagConstraints gridBagConstraints102 = new GridBagConstraints();
            gridBagConstraints102.gridx = 2;
            gridBagConstraints102.anchor = 18;
            gridBagConstraints102.insets = new Insets(1, 1, 1, 5);
            gridBagConstraints102.fill = 0;
            gridBagConstraints102.weighty = 1.0;
            gridBagConstraints102.gridy = 3;
            GridBagConstraints gridBagConstraints103 = new GridBagConstraints();
            gridBagConstraints103.gridx = 3;
            gridBagConstraints103.anchor = 18;
            gridBagConstraints103.insets = new Insets(1, 1, 1, 5);
            gridBagConstraints103.fill = 0;
            gridBagConstraints103.weighty = 1.0;
            gridBagConstraints103.gridy = 3;
            GridBagConstraints gridBagConstraints104 = new GridBagConstraints();
            gridBagConstraints104.gridx = 4;
            gridBagConstraints104.anchor = 18;
            gridBagConstraints104.insets = new Insets(1, 1, 1, 5);
            gridBagConstraints104.fill = 0;
            gridBagConstraints104.weighty = 1.0;
            gridBagConstraints104.gridy = 3;
            GridBagConstraints gridBagConstraints91 = new GridBagConstraints();
            gridBagConstraints91.gridx = -1;
            gridBagConstraints91.gridy = -1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridwidth = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridwidth = 1;
            gridBagConstraints11.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridwidth = 4;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(1, 5, 1, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 2;
            this.Lcontent = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(1, 5, 1, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.Lsender = new JLabel();
            this.Psearch = new JPanel();
            this.Psearch.setLayout(new GridBagLayout());
            this.Psearch.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder(1)));
            this.Psearch.add((Component)this.Lsender, gridBagConstraints);
            this.Psearch.add((Component)this.Lcontent, gridBagConstraints1);
            this.Psearch.add((Component)this.getSearch_CBprivateMsgsOnly(), gridBagConstraints101);
            this.Psearch.add((Component)this.getSearch_CBflaggedMsgsOnly(), gridBagConstraints102);
            this.Psearch.add((Component)this.getSearch_CBstarredMsgsOnly(), gridBagConstraints103);
            this.Psearch.add((Component)this.getSearch_CBrepliedMsgsOnly(), gridBagConstraints104);
            this.Psearch.add((Component)this.Lsubject, gridBagConstraints110);
            JPanel dummyPanel = new JPanel();
            dummyPanel.setLayout(new BoxLayout(dummyPanel, 0));
            dummyPanel.add(this.getSearch_TFsender());
            dummyPanel.add(this.senderCaseCheckBox);
            this.Psearch.add((Component)dummyPanel, gridBagConstraints11);
            dummyPanel = new JPanel();
            dummyPanel.setLayout(new BoxLayout(dummyPanel, 0));
            dummyPanel.add(this.getSearch_TFcontent());
            dummyPanel.add(this.contentCaseCheckBox);
            this.Psearch.add((Component)dummyPanel, gridBagConstraints2);
            dummyPanel = new JPanel();
            dummyPanel.setLayout(new BoxLayout(dummyPanel, 0));
            dummyPanel.add(this.getSearch_TFsubject());
            dummyPanel.add(this.subjectCaseCheckBox);
            this.Psearch.add((Component)dummyPanel, gridBagConstraints29);
        }
        return this.Psearch;
    }

    private JPanel getPsearchResult() {
        if (this.PsearchResult == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints6.gridy = 0;
            this.LresultCount = new JLabel("");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.ipadx = 239;
            gridBagConstraints4.ipady = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 0;
            this.LsearchResult = new JLabel();
            this.PsearchResult = new JPanel();
            this.PsearchResult.setLayout(new GridBagLayout());
            this.PsearchResult.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder(1)));
            this.PsearchResult.add((Component)this.LsearchResult, gridBagConstraints3);
            this.PsearchResult.add((Component)this.getJScrollPane(), gridBagConstraints4);
            this.PsearchResult.add((Component)this.LresultCount, gridBagConstraints6);
        }
        return this.PsearchResult;
    }

    private JTextField getSearch_TFsender() {
        if (this.search_TFsender == null) {
            this.search_TFsender = new JTextField();
        }
        return this.search_TFsender;
    }

    private JTextField getSearch_TFcontent() {
        if (this.search_TFcontent == null) {
            this.search_TFcontent = new JTextField();
        }
        return this.search_TFcontent;
    }

    private JPanel getPdate() {
        if (this.Pdate == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.insets = new Insets(1, 5, 0, 5);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.anchor = 18;
            gridBagConstraints15.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints15.gridwidth = 3;
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.gridy = 3;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.fill = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints14.gridy = 3;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.anchor = 18;
            gridBagConstraints14.gridx = 0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.anchor = 18;
            gridBagConstraints13.insets = new Insets(1, 5, 0, 5);
            gridBagConstraints13.gridx = 3;
            gridBagConstraints13.gridy = 2;
            gridBagConstraints13.weightx = 0.0;
            gridBagConstraints13.fill = 0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.insets = new Insets(1, 2, 0, 2);
            this.date_Lto = new JLabel();
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.anchor = 18;
            gridBagConstraints10.insets = new Insets(1, 5, 0, 5);
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 2;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.fill = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 18;
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 2;
            gridBagConstraints9.insets = new Insets(1, 5, 0, 5);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.gridwidth = 4;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.insets = new Insets(1, 5, 0, 5);
            this.Pdate = new JPanel();
            this.Pdate.setLayout(new GridBagLayout());
            this.Pdate.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder(1)));
            this.Pdate.add((Component)this.getDate_RBdisplayed(), gridBagConstraints5);
            this.Pdate.add((Component)this.getDate_RBbetweenDates(), gridBagConstraints9);
            this.Pdate.add((Component)this.getDate_TFstartDate(), gridBagConstraints10);
            this.Pdate.add((Component)this.date_Lto, gridBagConstraints12);
            this.Pdate.add((Component)this.getDate_TFendDate(), gridBagConstraints13);
            this.Pdate.add((Component)this.getDate_RBdaysBackward(), gridBagConstraints14);
            this.Pdate.add((Component)this.getDate_TFdaysBackward(), gridBagConstraints15);
            this.Pdate.add((Component)this.getDate_RBall(), gridBagConstraints7);
        }
        return this.Pdate;
    }

    private JRadioButton getDate_RBdisplayed() {
        if (this.date_RBdisplayed == null) {
            this.date_RBdisplayed = new JRadioButton();
            this.date_RBdisplayed.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.date_RBitemStateChanged();
                }
            });
        }
        return this.date_RBdisplayed;
    }

    private JRadioButton getDate_RBbetweenDates() {
        if (this.date_RBbetweenDates == null) {
            this.date_RBbetweenDates = new JRadioButton();
            this.date_RBbetweenDates.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.date_RBitemStateChanged();
                }
            });
        }
        return this.date_RBbetweenDates;
    }

    private MDateEntryField getDate_TFstartDate() {
        if (this.date_TFstartDate == null) {
            this.date_TFstartDate = new MDateEntryField();
            MDefaultPullDownConstraints c = new MDefaultPullDownConstraints();
            c.firstDay = 2;
            c.changerStyle = 3;
            this.date_TFstartDate.setConstraints(c);
        }
        return this.date_TFstartDate;
    }

    private MDateEntryField getDate_TFendDate() {
        if (this.date_TFendDate == null) {
            this.date_TFendDate = new MDateEntryField();
            MDefaultPullDownConstraints c = new MDefaultPullDownConstraints();
            c.firstDay = 2;
            c.changerStyle = 3;
            this.date_TFendDate.setConstraints(c);
        }
        return this.date_TFendDate;
    }

    private JRadioButton getDate_RBdaysBackward() {
        if (this.date_RBdaysBackward == null) {
            this.date_RBdaysBackward = new JRadioButton();
            this.date_RBdaysBackward.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.date_RBitemStateChanged();
                }
            });
        }
        return this.date_RBdaysBackward;
    }

    private void date_RBitemStateChanged() {
        if (this.getDate_RBdisplayed().isSelected()) {
            this.getDate_TFdaysBackward().setEnabled(false);
            this.getDate_TFendDate().setEnabled(false);
            this.getDate_TFstartDate().setEnabled(false);
        } else if (this.getDate_RBbetweenDates().isSelected()) {
            this.getDate_TFdaysBackward().setEnabled(false);
            this.getDate_TFendDate().setEnabled(true);
            this.getDate_TFstartDate().setEnabled(true);
        } else if (this.getDate_RBdaysBackward().isSelected()) {
            this.getDate_TFdaysBackward().setEnabled(true);
            this.getDate_TFendDate().setEnabled(false);
            this.getDate_TFstartDate().setEnabled(false);
        }
    }

    private JTextField getDate_TFdaysBackward() {
        if (this.date_TFdaysBackward == null) {
            this.date_TFdaysBackward = new JTextField();
            this.date_TFdaysBackward.setColumns(6);
            this.date_TFdaysBackward.setDocument(new WholeNumberDocument());
        }
        return this.date_TFdaysBackward;
    }

    private JPanel getPtrustState() {
        if (this.PtrustState == null) {
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.insets = new Insets(0, 25, 0, 0);
            gridBagConstraints25.gridwidth = 3;
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.gridy = 3;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.weighty = 1.0;
            gridBagConstraints25.fill = 0;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.anchor = 18;
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.gridy = 2;
            gridBagConstraints18.insets = new Insets(1, 5, 0, 5);
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.anchor = 18;
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.gridy = 1;
            gridBagConstraints17.insets = new Insets(1, 5, 0, 5);
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.anchor = 18;
            gridBagConstraints16.insets = new Insets(1, 5, 0, 5);
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.fill = 0;
            this.PtrustState = new JPanel();
            this.PtrustState.setLayout(new GridBagLayout());
            this.PtrustState.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder(1)));
            this.PtrustState.add((Component)this.getTruststate_RBdisplayed(), gridBagConstraints16);
            this.PtrustState.add((Component)this.getTruststate_RBall(), gridBagConstraints17);
            this.PtrustState.add((Component)this.getTruststate_RBchosed(), gridBagConstraints18);
            this.PtrustState.add((Component)this.getTruststate_PtrustStates(), gridBagConstraints25);
        }
        return this.PtrustState;
    }

    private JRadioButton getTruststate_RBdisplayed() {
        if (this.truststate_RBdisplayed == null) {
            this.truststate_RBdisplayed = new JRadioButton();
            this.truststate_RBdisplayed.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.trustState_RBitemStateChanged();
                }
            });
        }
        return this.truststate_RBdisplayed;
    }

    private void trustState_RBitemStateChanged() {
        Component[] comps;
        boolean enableTtrustStatesPanel = this.getTruststate_RBchosed().isSelected();
        for (Component element : comps = this.getTruststate_PtrustStates().getComponents()) {
            element.setEnabled(enableTtrustStatesPanel);
        }
    }

    private JRadioButton getTruststate_RBall() {
        if (this.truststate_RBall == null) {
            this.truststate_RBall = new JRadioButton();
            this.truststate_RBall.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.trustState_RBitemStateChanged();
                }
            });
        }
        return this.truststate_RBall;
    }

    private JRadioButton getTruststate_RBchosed() {
        if (this.truststate_RBchosed == null) {
            this.truststate_RBchosed = new JRadioButton();
            this.truststate_RBchosed.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.trustState_RBitemStateChanged();
                }
            });
        }
        return this.truststate_RBchosed;
    }

    private JPanel getTruststate_PtrustStates() {
        if (this.truststate_PtrustStates == null) {
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 0;
            gridBagConstraints24.gridx = 5;
            gridBagConstraints24.gridy = 0;
            gridBagConstraints24.weightx = 0.0;
            gridBagConstraints24.insets = new Insets(1, 5, 1, 5);
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints23.gridy = 0;
            gridBagConstraints23.gridx = 4;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints22.gridy = 0;
            gridBagConstraints22.gridx = 3;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints21.gridy = 0;
            gridBagConstraints21.gridx = 2;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.insets = new Insets(1, 5, 1, 5);
            gridBagConstraints20.gridy = 0;
            gridBagConstraints20.gridx = 1;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.anchor = 10;
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.gridy = 0;
            gridBagConstraints19.insets = new Insets(1, 0, 1, 5);
            this.truststate_PtrustStates = new JPanel();
            this.truststate_PtrustStates.setLayout(new GridBagLayout());
            this.truststate_PtrustStates.add((Component)this.getTruststate_CBgood(), gridBagConstraints19);
            this.truststate_PtrustStates.add((Component)this.getTruststate_CBobserve(), gridBagConstraints20);
            this.truststate_PtrustStates.add((Component)this.getTruststate_CBcheck(), gridBagConstraints21);
            this.truststate_PtrustStates.add((Component)this.getTruststate_CBbad(), gridBagConstraints22);
            this.truststate_PtrustStates.add((Component)this.getTruststate_CBnone(), gridBagConstraints23);
            this.truststate_PtrustStates.add((Component)this.getTruststate_CBtampered(), gridBagConstraints24);
        }
        return this.truststate_PtrustStates;
    }

    private JCheckBox getTruststate_CBgood() {
        if (this.truststate_CBgood == null) {
            this.truststate_CBgood = new JCheckBox();
        }
        return this.truststate_CBgood;
    }

    private JCheckBox getTruststate_CBobserve() {
        if (this.truststate_CBobserve == null) {
            this.truststate_CBobserve = new JCheckBox();
        }
        return this.truststate_CBobserve;
    }

    private JCheckBox getTruststate_CBcheck() {
        if (this.truststate_CBcheck == null) {
            this.truststate_CBcheck = new JCheckBox();
        }
        return this.truststate_CBcheck;
    }

    private JCheckBox getTruststate_CBbad() {
        if (this.truststate_CBbad == null) {
            this.truststate_CBbad = new JCheckBox();
        }
        return this.truststate_CBbad;
    }

    private JCheckBox getTruststate_CBnone() {
        if (this.truststate_CBnone == null) {
            this.truststate_CBnone = new JCheckBox();
        }
        return this.truststate_CBnone;
    }

    private JCheckBox getTruststate_CBtampered() {
        if (this.truststate_CBtampered == null) {
            this.truststate_CBtampered = new JCheckBox();
        }
        return this.truststate_CBtampered;
    }

    private JPanel getParchive() {
        if (this.Parchive == null) {
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.anchor = 18;
            gridBagConstraints28.gridx = 0;
            gridBagConstraints28.gridy = 2;
            gridBagConstraints28.fill = 0;
            gridBagConstraints28.weighty = 1.0;
            gridBagConstraints28.insets = new Insets(3, 5, 1, 5);
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.anchor = 18;
            gridBagConstraints27.gridx = 0;
            gridBagConstraints27.gridy = 1;
            gridBagConstraints27.fill = 0;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.insets = new Insets(3, 5, 1, 5);
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.anchor = 18;
            gridBagConstraints26.insets = new Insets(3, 5, 1, 5);
            gridBagConstraints26.gridx = 0;
            gridBagConstraints26.gridy = 0;
            gridBagConstraints26.weighty = 0.0;
            gridBagConstraints26.fill = 0;
            this.Parchive = new JPanel();
            this.Parchive.setLayout(new GridBagLayout());
            this.Parchive.setPreferredSize(new Dimension(517, 25));
            this.Parchive.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder(1)));
            this.Parchive.add((Component)this.getArchive_RBkeypoolOnly(), gridBagConstraints27);
            this.Parchive.add((Component)this.getArchive_RBarchiveOnly(), gridBagConstraints28);
            this.Parchive.add((Component)this.getArchive_RBkeypoolAndArchive(), gridBagConstraints26);
        }
        return this.Parchive;
    }

    private JRadioButton getArchive_RBkeypoolAndArchive() {
        if (this.archive_RBkeypoolAndArchive == null) {
            this.archive_RBkeypoolAndArchive = new JRadioButton();
            this.archive_RBkeypoolAndArchive.setPreferredSize(new Dimension(195, 20));
        }
        return this.archive_RBkeypoolAndArchive;
    }

    private JRadioButton getArchive_RBkeypoolOnly() {
        if (this.archive_RBkeypoolOnly == null) {
            this.archive_RBkeypoolOnly = new JRadioButton();
            this.archive_RBkeypoolOnly.setPreferredSize(new Dimension(152, 20));
        }
        return this.archive_RBkeypoolOnly;
    }

    private JRadioButton getArchive_RBarchiveOnly() {
        if (this.archive_RBarchiveOnly == null) {
            this.archive_RBarchiveOnly = new JRadioButton();
            this.archive_RBarchiveOnly.setPreferredSize(new Dimension(150, 20));
        }
        return this.archive_RBarchiveOnly;
    }

    private JPanel getPboards() {
        if (this.Pboards == null) {
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.anchor = 18;
            gridBagConstraints35.insets = new Insets(1, 25, 1, 5);
            gridBagConstraints35.gridwidth = 2;
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.gridy = 3;
            gridBagConstraints35.weightx = 1.0;
            gridBagConstraints35.weighty = 1.0;
            gridBagConstraints35.fill = 2;
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.anchor = 18;
            gridBagConstraints34.gridx = 1;
            gridBagConstraints34.gridy = 2;
            gridBagConstraints34.insets = new Insets(1, 5, 0, 5);
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.anchor = 18;
            gridBagConstraints33.gridx = 0;
            gridBagConstraints33.gridy = 2;
            gridBagConstraints33.insets = new Insets(1, 5, 0, 5);
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.anchor = 18;
            gridBagConstraints32.gridwidth = 2;
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.gridy = 1;
            gridBagConstraints32.insets = new Insets(1, 5, 0, 5);
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.anchor = 18;
            gridBagConstraints31.gridwidth = 2;
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridy = 0;
            gridBagConstraints31.insets = new Insets(1, 5, 0, 5);
            this.Pboards = new JPanel();
            this.Pboards.setLayout(new GridBagLayout());
            this.Pboards.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder(1)));
            this.Pboards.add((Component)this.getBoards_RBdisplayed(), gridBagConstraints31);
            this.Pboards.add((Component)this.getBoards_RBchosed(), gridBagConstraints33);
            this.Pboards.add((Component)this.getBoards_Bchoose(), gridBagConstraints34);
            this.Pboards.add((Component)this.getBoards_TFchosedBoards(), gridBagConstraints35);
        }
        return this.Pboards;
    }

    private JRadioButton getBoards_RBdisplayed() {
        if (this.boards_RBdisplayed == null) {
            this.boards_RBdisplayed = new JRadioButton();
            this.boards_RBdisplayed.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.boards_RBitemStateChanged();
                }
            });
        }
        return this.boards_RBdisplayed;
    }

    private JRadioButton getBoards_RBchosed() {
        if (this.boards_RBchosed == null) {
            this.boards_RBchosed = new JRadioButton();
            this.boards_RBchosed.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SearchMessagesDialog.this.boards_RBitemStateChanged();
                }
            });
        }
        return this.boards_RBchosed;
    }

    private void boards_RBitemStateChanged() {
        boolean enableChooseControls = this.getBoards_RBchosed().isSelected();
        this.getBoards_Bchoose().setEnabled(enableChooseControls);
        this.getBoards_TFchosedBoards().setEnabled(enableChooseControls);
    }

    private JButton getBoards_Bchoose() {
        if (this.boards_Bchoose == null) {
            this.boards_Bchoose = new JButton();
            this.boards_Bchoose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SearchMessagesDialog.this.chooseBoards();
                }
            });
        }
        return this.boards_Bchoose;
    }

    private JTextField getBoards_TFchosedBoards() {
        if (this.boards_TFchosedBoards == null) {
            this.boards_TFchosedBoards = new JTextField();
            this.boards_TFchosedBoards.setText("");
            this.boards_TFchosedBoards.setEditable(false);
        }
        return this.boards_TFchosedBoards;
    }

    private TristateCheckBox getSearch_CBprivateMsgsOnly() {
        if (this.search_CBprivateMsgsOnly == null) {
            this.search_CBprivateMsgsOnly = new TristateCheckBox();
        }
        return this.search_CBprivateMsgsOnly;
    }

    private TristateCheckBox getSearch_CBflaggedMsgsOnly() {
        if (this.search_CBflaggedMsgsOnly == null) {
            this.search_CBflaggedMsgsOnly = new TristateCheckBox();
        }
        return this.search_CBflaggedMsgsOnly;
    }

    private TristateCheckBox getSearch_CBstarredMsgsOnly() {
        if (this.search_CBstarredMsgsOnly == null) {
            this.search_CBstarredMsgsOnly = new TristateCheckBox();
        }
        return this.search_CBstarredMsgsOnly;
    }

    private TristateCheckBox getSearch_CBrepliedMsgsOnly() {
        if (this.search_CBrepliedMsgsOnly == null) {
            this.search_CBrepliedMsgsOnly = new TristateCheckBox();
        }
        return this.search_CBrepliedMsgsOnly;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setWheelScrollingEnabled(true);
            this.jScrollPane.setForeground(new Color(51, 51, 51));
            this.jScrollPane.setViewportView(this.getSearchResultTable());
        }
        return this.jScrollPane;
    }

    private SearchMessagesResultTable getSearchResultTable() {
        if (this.searchResultTable == null) {
            this.searchResultTable = new SearchMessagesResultTable(this.getSearchMessagesTableModel());
            this.searchResultTable.setAutoCreateColumnsFromModel(true);
            this.searchResultTable.setSelectionMode(0);
            this.searchResultTable.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        SearchMessagesDialog.this.openSelectedMessage();
                    }
                }
            });
            this.searchResultTable.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "openMessage");
            AbstractAction action = new AbstractAction(){

                public void actionPerformed(ActionEvent arg0) {
                    if (SearchMessagesDialog.this.getBopenMsg().isEnabled()) {
                        SearchMessagesDialog.this.openSelectedMessage();
                    }
                }
            };
            this.searchResultTable.getActionMap().put("openMessage", action);
        }
        return this.searchResultTable;
    }

    private SearchMessagesTableModel getSearchMessagesTableModel() {
        if (this.searchMessagesTableModel == null) {
            this.searchMessagesTableModel = new SearchMessagesTableModel();
        }
        return this.searchMessagesTableModel;
    }

    private ButtonGroup getBoards_buttonGroup() {
        if (this.boards_buttonGroup == null) {
            this.boards_buttonGroup = new ButtonGroup();
            this.boards_buttonGroup.add(this.getBoards_RBdisplayed());
            this.boards_buttonGroup.add(this.getBoards_RBchosed());
        }
        return this.boards_buttonGroup;
    }

    private ButtonGroup getDate_buttonGroup() {
        if (this.date_buttonGroup == null) {
            this.date_buttonGroup = new ButtonGroup();
            this.date_buttonGroup.add(this.getDate_RBbetweenDates());
            this.date_buttonGroup.add(this.getDate_RBdaysBackward());
            this.date_buttonGroup.add(this.getDate_RBdisplayed());
            this.date_buttonGroup.add(this.getDate_RBall());
        }
        return this.date_buttonGroup;
    }

    private ButtonGroup getTruststate_buttonGroup() {
        if (this.truststate_buttonGroup == null) {
            this.truststate_buttonGroup = new ButtonGroup();
            this.truststate_buttonGroup.add(this.getTruststate_RBdisplayed());
            this.truststate_buttonGroup.add(this.getTruststate_RBall());
            this.truststate_buttonGroup.add(this.getTruststate_RBchosed());
        }
        return this.truststate_buttonGroup;
    }

    private ButtonGroup getArchive_buttonGroup() {
        if (this.archive_buttonGroup == null) {
            this.archive_buttonGroup = new ButtonGroup();
            this.archive_buttonGroup.add(this.getArchive_RBkeypoolOnly());
            this.archive_buttonGroup.add(this.getArchive_RBarchiveOnly());
            this.archive_buttonGroup.add(this.getArchive_RBkeypoolAndArchive());
        }
        return this.archive_buttonGroup;
    }

    private void chooseBoards() {
        LinkedList<Board> allBoards = MainFrame.getInstance().getTofTreeModel().getAllBoards();
        if (allBoards.size() == 0) {
            JOptionPane.showMessageDialog(this, this.language.getString("SearchMessages.errorDialogs.noBoardsToChoose"), this.language.getString("SearchMessages.errorDialogs.title"), 0);
            return;
        }
        Collections.sort(allBoards);
        BoardsChooser bc = new BoardsChooser((Frame)this, allBoards, this.chosedBoardsList);
        List<Board> resultBoards = bc.runDialog();
        if (resultBoards != null) {
            this.chosedBoardsList = resultBoards;
            this.updateBoardTextField(this.chosedBoardsList);
        }
    }

    private void updateBoardTextField(List<Board> boards) {
        StringBuilder txt = new StringBuilder();
        if (boards != null) {
            Iterator<Board> i = boards.iterator();
            while (i.hasNext()) {
                Board b = i.next();
                txt.append(b.getName());
                if (!i.hasNext()) continue;
                txt.append("; ");
            }
            this.chosedBoardsList = boards;
        } else {
            this.chosedBoardsList = Collections.emptyList();
        }
        this.getBoards_TFchosedBoards().setText(txt.toString());
    }

    private void initializeWithDefaults() {
        this.getBoards_RBdisplayed().doClick();
        this.getDate_RBdisplayed().doClick();
        this.getTruststate_RBdisplayed().doClick();
        this.getArchive_RBkeypoolAndArchive().doClick();
        this.getDate_TFdaysBackward().setText("0");
    }

    private SearchMessagesConfig getSearchConfig() {
        SearchMessagesConfig scfg;
        block26: {
            scfg = new SearchMessagesConfig();
            scfg.setSenderString(this.getSearch_TFsender().getText().trim(), !this.senderCaseCheckBox.isSelected());
            scfg.setSubjectString(this.getSearch_TFsubject().getText().trim(), !this.subjectCaseCheckBox.isSelected());
            scfg.setContentString(this.getSearch_TFcontent().getText().trim(), !this.contentCaseCheckBox.isSelected());
            scfg.searchPrivateMsgsOnly = this.getSearch_CBprivateMsgsOnly().getBooleanState();
            scfg.searchFlaggedMsgsOnly = this.getSearch_CBflaggedMsgsOnly().getBooleanState();
            scfg.searchStarredMsgsOnly = this.getSearch_CBstarredMsgsOnly().getBooleanState();
            scfg.searchRepliedMsgsOnly = this.getSearch_CBrepliedMsgsOnly().getBooleanState();
            if (this.getBoards_RBdisplayed().isSelected()) {
                scfg.searchBoards = 1;
            } else if (this.getBoards_RBchosed().isSelected()) {
                if (this.chosedBoardsList.size() == 0) {
                    JOptionPane.showMessageDialog(this, this.language.getString("SearchMessages.errorDialogs.noBoardsChosen"), this.language.getString("SearchMessages.errorDialogs.title"), 0);
                    return null;
                }
                scfg.searchBoards = 3;
                scfg.chosedBoards = this.chosedBoardsList;
            }
            if (this.getDate_RBdisplayed().isSelected()) {
                scfg.searchDates = 1;
            } else if (this.getDate_RBall().isSelected()) {
                scfg.searchDates = 2;
            } else {
                if (this.getDate_RBbetweenDates().isSelected()) {
                    scfg.searchDates = 3;
                    try {
                        scfg.startDate = this.getDate_TFstartDate().getValue().getTime();
                        scfg.endDate = this.getDate_TFendDate().getValue().getTime();
                        if (scfg.startDate > scfg.endDate) {
                            JOptionPane.showMessageDialog(this, this.language.getString("SearchMessages.errorDialogs.startDateIsAfterEndDate"), this.language.getString("SearchMessages.errorDialogs.title"), 0);
                            return null;
                        }
                        break block26;
                    }
                    catch (ParseException ex) {
                        JOptionPane.showMessageDialog(this, this.language.getString("SearchMessages.errorDialogs.invalidStartOrEndDate"), this.language.getString("SearchMessages.errorDialogs.title"), 0);
                        return null;
                    }
                }
                if (this.getDate_RBdaysBackward().isSelected()) {
                    scfg.searchDates = 4;
                    try {
                        scfg.daysBackward = Integer.parseInt(this.getDate_TFdaysBackward().getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.getTruststate_RBdisplayed().isSelected()) {
            scfg.searchTruststates = 1;
        } else if (this.getTruststate_RBall().isSelected()) {
            scfg.searchTruststates = 2;
        } else if (this.getTruststate_RBchosed().isSelected()) {
            scfg.searchTruststates = 3;
            scfg.trust_good = this.getTruststate_CBgood().isSelected();
            scfg.trust_observe = this.getTruststate_CBobserve().isSelected();
            scfg.trust_check = this.getTruststate_CBcheck().isSelected();
            scfg.trust_bad = this.getTruststate_CBbad().isSelected();
            scfg.trust_none = this.getTruststate_CBnone().isSelected();
            scfg.trust_tampered = this.getTruststate_CBtampered().isSelected();
            if (!(scfg.trust_good || scfg.trust_observe || scfg.trust_check || scfg.trust_bad || scfg.trust_none || scfg.trust_tampered)) {
                JOptionPane.showMessageDialog(this, this.language.getString("SearchMessages.errorDialogs.noTrustStateSelected"), this.language.getString("SearchMessages.errorDialogs.title"), 0);
                return null;
            }
        }
        if (this.getArchive_RBkeypoolOnly().isSelected()) {
            scfg.searchInKeypool = true;
            scfg.searchInArchive = false;
        } else if (this.getArchive_RBarchiveOnly().isSelected()) {
            scfg.searchInKeypool = false;
            scfg.searchInArchive = true;
        } else if (this.getArchive_RBkeypoolAndArchive().isSelected()) {
            scfg.searchInKeypool = true;
            scfg.searchInArchive = true;
        }
        scfg.msgMustContainBoards = this.getAttachment_CBmustContainBoards().isSelected();
        scfg.msgMustContainFiles = this.getAttachment_CBmustContainFiles().isSelected();
        return scfg;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closePressed();
        } else {
            super.processWindowEvent(e);
        }
    }

    private SearchMessagesThread getRunningSearchThread() {
        return this.runningSearchThread;
    }

    private void setRunningSearchThread(SearchMessagesThread t) {
        this.runningSearchThread = t;
    }

    private void disableInputPanels() {
        this.previouslyEnabledComponents.clear();
        for (int x = 0; x < this.getJTabbedPane().getTabCount(); ++x) {
            JPanel c = (JPanel)this.getJTabbedPane().getComponentAt(x);
            this.disableInputPanels(c);
        }
    }

    private void disableInputPanels(Container c) {
        Component[] cs;
        for (Component element : cs = c.getComponents()) {
            if (element instanceof Container) {
                this.disableInputPanels((Container)element);
            }
            if (!element.isEnabled()) continue;
            this.previouslyEnabledComponents.add(element);
            element.setEnabled(false);
        }
    }

    private void enableInputPanels() {
        for (int x = 0; x < this.getJTabbedPane().getTabCount(); ++x) {
            JPanel c = (JPanel)this.getJTabbedPane().getComponentAt(x);
            this.enableInputPanels(c);
        }
        this.previouslyEnabledComponents.clear();
    }

    private void enableInputPanels(Container c) {
        Component[] cs;
        for (Component element : cs = c.getComponents()) {
            if (element instanceof Container) {
                this.enableInputPanels((Container)element);
            }
            if (!this.previouslyEnabledComponents.contains(element)) continue;
            element.setEnabled(true);
        }
    }

    public void notifySearchThreadFinished() {
        this.setRunningSearchThread(null);
        this.enableInputPanels();
        this.getBcancel().setEnabled(true);
        this.getBsearch().setText(this.startSearchStr);
    }

    private void closePressed() {
        if (this.getRunningSearchThread() != null) {
            JOptionPane.showMessageDialog(this, this.language.getString("SearchMessages.errorDialog.stopSearchBeforeClose"), this.language.getString("SearchMessages.errorDialogs.title"), 0);
            return;
        }
        this.saveWindowState();
        this.language.removeLanguageListener(this);
        ((JTranslatableTabbedPane)this.getJTabbedPane()).close();
        this.setVisible(false);
    }

    private void startOrStopSearching() {
        if (this.getRunningSearchThread() != null) {
            this.getRunningSearchThread().requestStop();
            return;
        }
        this.searchMessagesConfig = this.getSearchConfig();
        if (this.searchMessagesConfig == null) {
            return;
        }
        this.clearSearchResultTable();
        this.disableInputPanels();
        this.getBcancel().setEnabled(false);
        this.getBsearch().setText(this.stopSearchStr);
        this.getBopenMsg().setEnabled(false);
        this.setRunningSearchThread(new SearchMessagesThread(this, this.searchMessagesConfig));
        this.getRunningSearchThread().setPriority(1);
        this.getRunningSearchThread().start();
    }

    private void clearSearchResultTable() {
        this.getSearchMessagesTableModel().clearDataModel();
        this.resultCount = 0;
        this.updateResultCountLabel(this.resultCount);
    }

    private void updateResultCountLabel(int rs) {
        this.LresultCount.setText(this.resultCountPrefix + rs);
    }

    public void addFoundMessage(final FrostSearchResultMessageObject msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMessagesDialog.this.getSearchMessagesTableModel().addRow(msg);
                ++SearchMessagesDialog.this.resultCount;
                SearchMessagesDialog.this.updateResultCountLabel(SearchMessagesDialog.this.resultCount);
                if (!SearchMessagesDialog.this.getBopenMsg().isEnabled()) {
                    SearchMessagesDialog.this.getBopenMsg().setEnabled(true);
                }
            }
        });
    }

    private void openSelectedMessage() {
        int row = this.getSearchResultTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        FrostSearchResultMessageObject msg = (FrostSearchResultMessageObject)this.getSearchMessagesTableModel().getRow(row);
        if (msg == null) {
            return;
        }
        FrostMessageObject mo = msg.getMessageObject();
        MessageWindow messageWindow = new MessageWindow((Window)this, mo, this.getSize(), this.searchMessagesConfig);
        messageWindow.setVisible(true);
    }

    private JRadioButton getDate_RBall() {
        if (this.date_RBall == null) {
            this.date_RBall = new JRadioButton();
        }
        return this.date_RBall;
    }

    private void saveWindowState() {
        Rectangle bounds = this.getBounds();
        boolean isMaximized = (this.getExtendedState() & 6) != 0;
        Core.frostSettings.setValue("searchMessagesDialog.lastFrameMaximized", isMaximized);
        if (!isMaximized) {
            Core.frostSettings.setValue("searchMessagesDialog.lastFrameHeight", bounds.height);
            Core.frostSettings.setValue("searchMessagesDialog.lastFrameWidth", bounds.width);
            Core.frostSettings.setValue("searchMessagesDialog.lastFramePosX", bounds.x);
            Core.frostSettings.setValue("searchMessagesDialog.lastFramePosY", bounds.y);
        }
    }

    private void loadWindowState() {
        int lastHeight = Core.frostSettings.getIntValue("searchMessagesDialog.lastFrameHeight");
        int lastWidth = Core.frostSettings.getIntValue("searchMessagesDialog.lastFrameWidth");
        int lastPosX = Core.frostSettings.getIntValue("searchMessagesDialog.lastFramePosX");
        int lastPosY = Core.frostSettings.getIntValue("searchMessagesDialog.lastFramePosY");
        boolean lastMaximized = Core.frostSettings.getBoolValue("searchMessagesDialog.lastFrameMaximized");
        if (lastHeight <= 0 || lastWidth <= 0) {
            this.setSize(700, 550);
            this.setLocationRelativeTo(MainFrame.getInstance());
            return;
        }
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (lastWidth < 100) {
            lastWidth = 700;
        }
        if (lastHeight < 100) {
            lastHeight = 550;
        }
        if (lastPosX + lastWidth > scrSize.width) {
            this.setSize(700, 550);
            this.setLocationRelativeTo(MainFrame.getInstance());
            return;
        }
        if (lastPosY + lastHeight > scrSize.height) {
            this.setSize(700, 550);
            this.setLocationRelativeTo(MainFrame.getInstance());
            return;
        }
        this.setBounds(lastPosX, lastPosY, lastWidth, lastHeight);
        if (lastMaximized) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    private JPanel getJPanel() {
        if (this.PbuttonsRight == null) {
            this.PbuttonsRight = new JPanel();
            this.PbuttonsRight.add((Component)this.getBsearch(), null);
            this.PbuttonsRight.add((Component)this.getBcancel(), null);
        }
        return this.PbuttonsRight;
    }

    private JPanel getPbuttonsRight() {
        if (this.PbuttonsLeft == null) {
            this.PbuttonsLeft = new JPanel();
            this.PbuttonsLeft.add((Component)this.getBhelp(), null);
            this.PbuttonsLeft.add((Component)this.getBopenMsg(), null);
        }
        return this.PbuttonsLeft;
    }

    private JButton getBopenMsg() {
        if (this.BopenMsg == null) {
            this.BopenMsg = new JButton();
            this.BopenMsg.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SearchMessagesDialog.this.openSelectedMessage();
                }
            });
            this.BopenMsg.setEnabled(false);
        }
        return this.BopenMsg;
    }

    @Override
    public void languageChanged(LanguageEvent e) {
        this.resultCountPrefix = this.language.getString("SearchMessages.label.results") + ": ";
        this.startSearchStr = this.language.getString("SearchMessages.button.search");
        this.stopSearchStr = this.language.getString("SearchMessages.button.stopSearch");
        if (this.getRunningSearchThread() != null) {
            this.getBsearch().setText(this.stopSearchStr);
        } else {
            this.getBsearch().setText(this.startSearchStr);
        }
        this.getBopenMsg().setText(this.language.getString("SearchMessages.button.openMessage"));
        this.getBhelp().setText(this.language.getString("SearchMessages.button.help"));
        this.getBcancel().setText(this.language.getString("SearchMessages.button.close"));
        this.Lsender.setText(this.language.getString("SearchMessages.search.sender"));
        this.Lcontent.setText(this.language.getString("SearchMessages.search.content"));
        this.Lsubject.setText(this.language.getString("SearchMessages.search.subject"));
        this.senderCaseCheckBox.setToolTipText(this.language.getString("SearchMessages.search.tooltip.caseSensitiv"));
        this.subjectCaseCheckBox.setToolTipText(this.language.getString("SearchMessages.search.tooltip.caseSensitiv"));
        this.contentCaseCheckBox.setToolTipText(this.language.getString("SearchMessages.search.tooltip.caseSensitiv"));
        this.LsearchResult.setText(this.language.getString("SearchMessages.label.searchResult"));
        this.date_Lto.setText(this.language.getString("SearchMessages.date.to"));
        this.getDate_RBbetweenDates().setText(this.language.getString("SearchMessages.date.searchBetweenDates"));
        this.getDate_RBdisplayed().setText(this.language.getString("SearchMessages.date.searchInMessagesThatWouldBeDisplayed"));
        this.getDate_RBdaysBackward().setText(this.language.getString("SearchMessages.date.searchNumberOfDaysBackward"));
        this.getDate_RBall().setText(this.language.getString("SearchMessages.date.searchAllDates"));
        this.getTruststate_RBall().setText(this.language.getString("SearchMessages.trustState.searchAllMessages"));
        this.getTruststate_RBdisplayed().setText(this.language.getString("SearchMessages.trustState.searchInMessagesThatWouldBeDisplayed"));
        this.getTruststate_RBchosed().setText(this.language.getString("SearchMessages.trustState.searchOnlyInMessagesWithFollowingTrustState"));
        this.getTruststate_CBtampered().setText(this.language.getString("SearchMessages.trustState.tampered"));
        this.getTruststate_CBnone().setText(this.language.getString("SearchMessages.trustState.none"));
        this.getTruststate_CBbad().setText(this.language.getString("SearchMessages.trustState.bad"));
        this.getTruststate_CBcheck().setText(this.language.getString("SearchMessages.trustState.check"));
        this.getTruststate_CBobserve().setText(this.language.getString("SearchMessages.trustState.observe"));
        this.getTruststate_CBgood().setText(this.language.getString("SearchMessages.trustState.good"));
        this.getArchive_RBarchiveOnly().setText(this.language.getString("SearchMessages.archive.searchOnlyInArchive"));
        this.getArchive_RBkeypoolOnly().setText(this.language.getString("SearchMessages.archive.searchOnlyInKeypool"));
        this.getArchive_RBkeypoolAndArchive().setText(this.language.getString("SearchMessages.archive.searchInKeypoolAndArchive"));
        this.getBoards_RBchosed().setText(this.language.getString("SearchMessages.boards.searchFollowingBoards"));
        this.getBoards_RBdisplayed().setText(this.language.getString("SearchMessages.boards.searchInDisplayedBoards"));
        this.getSearch_CBprivateMsgsOnly().setText(this.language.getString("SearchMessages.search.searchPrivateMessagesOnly"));
        this.getSearch_CBflaggedMsgsOnly().setText(this.language.getString("SearchMessages.search.searchFlaggedMessagesOnly"));
        this.getSearch_CBstarredMsgsOnly().setText(this.language.getString("SearchMessages.search.searchStarredMessagesOnly"));
        this.getSearch_CBrepliedMsgsOnly().setText(this.language.getString("SearchMessages.search.searchRepliedMessagesOnly"));
        this.getBoards_Bchoose().setText(this.language.getString("SearchMessages.boards.chooseBoards") + "...");
        this.getAttachment_CBmustContainBoards().setText(this.language.getString("SearchMessages.attachments.messageMustContainBoardAttachments"));
        this.getAttachment_CBmustContainFiles().setText(this.language.getString("SearchMessages.attachments.messageMustContainFileAttachments"));
    }

    private JPanel getPattachments() {
        if (this.Pattachments == null) {
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 0;
            gridBagConstraints30.insets = new Insets(3, 5, 1, 5);
            gridBagConstraints30.anchor = 18;
            gridBagConstraints30.weighty = 1.0;
            gridBagConstraints30.weightx = 1.0;
            gridBagConstraints30.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 18;
            gridBagConstraints8.insets = new Insets(3, 5, 1, 5);
            gridBagConstraints8.gridy = 0;
            this.Pattachments = new JPanel();
            this.Pattachments.setLayout(new GridBagLayout());
            this.Pattachments.add((Component)this.getAttachment_CBmustContainBoards(), gridBagConstraints8);
            this.Pattachments.add((Component)this.getAttachment_CBmustContainFiles(), gridBagConstraints30);
        }
        return this.Pattachments;
    }

    private JCheckBox getAttachment_CBmustContainBoards() {
        if (this.attachment_CBmustContainBoards == null) {
            this.attachment_CBmustContainBoards = new JCheckBox();
        }
        return this.attachment_CBmustContainBoards;
    }

    private JCheckBox getAttachment_CBmustContainFiles() {
        if (this.attachment_CBmustContainFiles == null) {
            this.attachment_CBmustContainFiles = new JCheckBox();
        }
        return this.attachment_CBmustContainFiles;
    }

    private JButton getBhelp() {
        if (this.Bhelp == null) {
            this.Bhelp = new JButton();
            if (!Core.isHelpHtmlSecure()) {
                this.Bhelp.setEnabled(false);
            } else {
                this.Bhelp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MainFrame.getInstance().showHtmlHelp("searchDialog.html");
                    }
                });
            }
        }
        return this.Bhelp;
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (!Character.isDigit(source[i])) continue;
                result[j++] = source[i];
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

