/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.util.gui.MiscToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class Splashscreen
extends JDialog {
    private static String SPLASH_LOGO_FILENAME = "/data/splash.png";
    private final ImageIcon frostLogo = MiscToolkit.loadImageIcon(SPLASH_LOGO_FILENAME);
    JPanel mainPanel = new JPanel(new BorderLayout());
    JLabel pictureLabel = new JLabel();
    JProgressBar progressBar = new JProgressBar(0, 100);
    private boolean noSplash;

    public Splashscreen(boolean hideSplashScreen) {
        this.noSplash = hideSplashScreen;
        this.init();
    }

    public void closeMe() {
        if (!this.noSplash) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void init() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.pictureLabel.setIcon(this.frostLogo);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Starting...");
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.pictureLabel, "Center");
        this.mainPanel.add((Component)this.progressBar, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension splashscreenSize = this.getSize();
        if (splashscreenSize.height > screenSize.height) {
            splashscreenSize.height = screenSize.height;
        }
        if (splashscreenSize.width > screenSize.width) {
            splashscreenSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - splashscreenSize.width) / 2, (screenSize.height - splashscreenSize.height) / 2);
    }

    public void setProgress(int progress) {
        if (!this.noSplash) {
            this.progressBar.setValue(progress);
        }
    }

    public void setText(String text) {
        if (!this.noSplash) {
            this.progressBar.setString(text);
        }
    }

    public void setVisible(boolean b) {
        if (!this.noSplash) {
            super.setVisible(b);
        }
    }
}

