/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.boards.AbstractNode;
import frost.boards.Folder;
import frost.boards.TofTreeModel;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class TargetFolderChooser
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel buttonsPanel = null;
    private JTree folderTree = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private final DefaultTreeModel treeModel;
    private Folder choosedFolder = null;
    private JScrollPane jScrollPane = null;
    private final Language language;

    public TargetFolderChooser(TofTreeModel origModel) {
        MyTreeNode rootNode = this.buildTree(origModel);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.language = Language.getInstance();
        this.initialize();
    }

    private MyTreeNode buildTree(TofTreeModel origModel) {
        MyTreeNode rootNode = new MyTreeNode((Folder)origModel.getRoot());
        this.addNodesRecursiv(rootNode, origModel.getRoot());
        return rootNode;
    }

    private void addNodesRecursiv(MyTreeNode addNode, DefaultMutableTreeNode origNode) {
        for (int x = 0; x < origNode.getChildCount(); ++x) {
            AbstractNode b = (AbstractNode)origNode.getChildAt(x);
            if (!b.isFolder()) continue;
            MyTreeNode newNode = new MyTreeNode((Folder)b);
            addNode.add(newNode);
            this.addNodesRecursiv(newNode, b);
        }
    }

    private void initialize() {
        int dlgSizeX = 350;
        int dlgSizeY = 400;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - 350) / 2;
        int y = (screen.height - 400) / 2;
        this.setBounds(x, y, 350, 400);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle(this.language.getString("TargetFolderChooser.title"));
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TargetFolderChooser.this.cancelButtonPressed();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getButtonsPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(flowLayout);
            this.buttonsPanel.add((Component)this.getOkButton(), null);
            this.buttonsPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonsPanel;
    }

    private JTree getFolderTree() {
        if (this.folderTree == null) {
            this.folderTree = new JTree(this.treeModel);
            this.folderTree.setCellRenderer(new CellRenderer());
            this.folderTree.setSelectionRow(0);
        }
        return this.folderTree;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(this.language.getString("Common.ok"));
            this.okButton.setSelected(false);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TargetFolderChooser.this.okButtonPressed();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(this.language.getString("Common.cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TargetFolderChooser.this.cancelButtonPressed();
                }
            });
        }
        return this.cancelButton;
    }

    private void okButtonPressed() {
        this.choosedFolder = ((MyTreeNode)this.getFolderTree().getSelectionPath().getLastPathComponent()).getFolder();
        this.setVisible(false);
    }

    private void cancelButtonPressed() {
        this.choosedFolder = null;
        this.setVisible(false);
    }

    public Folder startDialog() {
        this.setVisible(true);
        return this.choosedFolder;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBackground(Color.white);
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder(1)));
            this.jScrollPane.setViewportView(this.getFolderTree());
        }
        return this.jScrollPane;
    }

    private class MyTreeNode
    extends DefaultMutableTreeNode {
        Folder folder;

        public MyTreeNode(Folder usrObj) {
            super(usrObj);
            this.folder = usrObj;
        }

        public String toString() {
            return this.folder.getName();
        }

        public Folder getFolder() {
            return this.folder;
        }
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon boardIcon = MiscToolkit.loadImageIcon("/data/folder-open.png");

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean lHasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, lHasFocus);
            this.setIcon(this.boardIcon);
            return this;
        }
    }
}

