/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.help;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CheckHtmlIntegrity {
    private static final Logger logger = Logger.getLogger(CheckHtmlIntegrity.class.getName());
    private boolean isHtmlSecure = false;

    public boolean isHtmlSecure() {
        return this.isHtmlSecure;
    }

    public boolean scanZipFile(String fileName) {
        File file = new File(fileName);
        if (!file.isFile() || file.length() == 0L) {
            logger.log(Level.SEVERE, "Zip file does not exist: " + file.getPath());
            return this.isHtmlSecure;
        }
        byte[] zipData = new byte[4096];
        try {
            ZipFile zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                int len;
                ZipEntry ze = e.nextElement();
                String zn = ze.getName();
                if (!zn.endsWith(".html") && !zn.endsWith(".htm")) continue;
                InputStream is = zf.getInputStream(ze);
                ByteArrayOutputStream out = new ByteArrayOutputStream((int)ze.getSize());
                while ((len = is.read(zipData)) >= 0) {
                    out.write(zipData, 0, len);
                }
                is.close();
                String htmlStr = new String(out.toByteArray(), "UTF-8").toLowerCase();
                if (htmlStr.indexOf("http://") <= -1 && htmlStr.indexOf("ftp://") <= -1 && htmlStr.indexOf("nntp://") <= -1) continue;
                logger.log(Level.SEVERE, "Unsecure HTML file in help.zip found: " + zn);
                return this.isHtmlSecure;
            }
            logger.log(Level.WARNING, "NO unsecure HTML file in help.zip found, all is ok.");
            this.isHtmlSecure = true;
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Exception while reading help.zip. File is invalid.", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception while reading help.zip. File is invalid.", e);
        }
        return this.isHtmlSecure;
    }
}

