/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.messagetreetable;

import frost.MainFrame;
import frost.gui.messagetreetable.TreeTableModel;
import frost.messages.FrostMessageObject;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class MessageTreeTableModel
extends DefaultTreeModel
implements TreeTableModel,
LanguageListener {
    private Language language = Language.getInstance();
    public static final int COLUMN_INDEX_FLAGGED = 0;
    public static final int COLUMN_INDEX_STARRED = 1;
    public static final int COLUMN_INDEX_SUBJECT = 2;
    public static final int COLUMN_INDEX_FROM = 3;
    public static final int COLUMN_INDEX_INDEX = 4;
    public static final int COLUMN_INDEX_JUNK = 5;
    public static final int COLUMN_INDEX_SIG = 6;
    public static final int COLUMN_INDEX_DATE = 7;
    public static final int MAX_COLUMN_INDEX = 7;
    protected static final String[] columnNames = new String[8];

    public MessageTreeTableModel(TreeNode root) {
        super(root);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        MessageTreeTableModel.columnNames[0] = "!";
        MessageTreeTableModel.columnNames[1] = "*";
        MessageTreeTableModel.columnNames[2] = this.language.getString("MessagePane.messageTable.subject");
        MessageTreeTableModel.columnNames[3] = this.language.getString("MessagePane.messageTable.from");
        MessageTreeTableModel.columnNames[4] = this.language.getString("MessagePane.messageTable.index");
        MessageTreeTableModel.columnNames[5] = "J";
        MessageTreeTableModel.columnNames[6] = this.language.getString("MessagePane.messageTable.sig");
        MessageTreeTableModel.columnNames[7] = this.language.getString("MessagePane.messageTable.date");
        try {
            TableColumnModel tcm = MainFrame.getInstance().getMessagePanel().getMessageTable().getTableHeader().getColumnModel();
            for (int x = 0; x < tcm.getColumnCount(); ++x) {
                TableColumn tc = tcm.getColumn(x);
                tc.setHeaderValue(columnNames[tc.getModelIndex()]);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    public Object getChild(Object node, int i) {
        return ((TreeNode)node).getChildAt(i);
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int column) {
        if (columnNames == null || column < 0 || column >= columnNames.length) {
            return null;
        }
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        if (column == 2) {
            return TreeTableModel.class;
        }
        if (column == 0 || column == 1 || column == 5) {
            return Boolean.class;
        }
        return String.class;
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof FrostMessageObject) {
            FrostMessageObject mo = (FrostMessageObject)node;
            if (mo.isDummy()) {
                switch (column) {
                    case 0: {
                        return Boolean.FALSE;
                    }
                    case 1: {
                        return Boolean.FALSE;
                    }
                    case 3: {
                        return "";
                    }
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return Boolean.FALSE;
                    }
                    case 6: {
                        return "";
                    }
                    case 7: {
                        return "";
                    }
                }
                return "*ERR*";
            }
            switch (column) {
                case 0: {
                    return mo.isFlagged();
                }
                case 1: {
                    return mo.isStarred();
                }
                case 3: {
                    return mo.getFromName();
                }
                case 4: {
                    return Integer.toString(mo.getIndex());
                }
                case 5: {
                    return mo.isJunk();
                }
                case 6: {
                    return mo.getMessageStatusString();
                }
                case 7: {
                    return mo.getDateAndTimeString();
                }
            }
            return "*ERR*";
        }
        return "*ERR*";
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 2;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }
}

