/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.model;

import frost.boards.Board;
import frost.messages.BoardAttachment;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class AttachedBoardTableModel
extends DefaultTableModel
implements LanguageListener {
    private Language language = Language.getInstance();
    protected static final String[] columnNames = new String[3];
    protected static final Class[] columnClasses = new Class[]{String.class, String.class, String.class};

    public AttachedBoardTableModel() {
        this.language.addLanguageListener(this);
        this.refreshLanguage();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        AttachedBoardTableModel.columnNames[0] = this.language.getString("MessagePane.boardAttachmentTable.boardName");
        AttachedBoardTableModel.columnNames[1] = this.language.getString("MessagePane.boardAttachmentTable.accessRights");
        AttachedBoardTableModel.columnNames[2] = this.language.getString("MessagePane.boardAttachmentTable.description");
        this.fireTableStructureChanged();
    }

    public void setData(List boardAttachments) {
        this.setRowCount(0);
        for (BoardAttachment attachment : boardAttachments) {
            Board board = attachment.getBoardObj();
            Object[] row = new Object[3];
            if (board.getName() == null) continue;
            row[0] = board.getName();
            row[1] = board.getPublicKey() == null && board.getPrivateKey() == null ? "public" : (board.getPublicKey() != null && board.getPrivateKey() == null ? "read - only" : "read / write");
            row[2] = board.getDescription() == null ? "Not present" : board.getDescription();
            this.addRow(row);
        }
    }

    public String getColumnName(int column) {
        if (column >= 0 && column < columnNames.length) {
            return columnNames[column];
        }
        return null;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int column) {
        if (column >= 0 && column < columnClasses.length) {
            return columnClasses[column];
        }
        return null;
    }
}

