/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.model;

import frost.messages.FileAttachment;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class AttachedFilesTableModel
extends DefaultTableModel
implements LanguageListener {
    private Language language = null;
    NumberFormat numberFormat = NumberFormat.getInstance();
    protected static final String[] columnNames = new String[3];
    protected static final Class[] columnClasses = new Class[]{String.class, String.class, String.class};

    public AttachedFilesTableModel() {
        this.language = Language.getInstance();
        this.language.addLanguageListener(this);
        this.refreshLanguage();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        AttachedFilesTableModel.columnNames[0] = this.language.getString("MessagePane.fileAttachmentTable.filename");
        AttachedFilesTableModel.columnNames[1] = this.language.getString("MessagePane.fileAttachmentTable.size");
        AttachedFilesTableModel.columnNames[2] = this.language.getString("MessagePane.fileAttachmentTable.key");
        this.fireTableStructureChanged();
    }

    public void setData(List fileAttachments) {
        this.setRowCount(0);
        for (FileAttachment attachment : fileAttachments) {
            String key = attachment.getKey() != null && attachment.getKey().length() > 40 ? attachment.getKey() : "?";
            if (attachment.getFilename() == null || attachment.getFilename().length() <= 0) continue;
            Object[] row = new Object[]{attachment.getFilename(), this.numberFormat.format(attachment.getFileSize()), key};
            this.addRow(row);
        }
    }

    public String getColumnName(int column) {
        if (column >= 0 && column < columnNames.length) {
            return columnNames[column];
        }
        return null;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int column) {
        if (column >= 0 && column < columnClasses.length) {
            return columnClasses[column];
        }
        return null;
    }

    public void configureTable(JTable t) {
        TableColumn c = t.getColumnModel().getColumn(1);
        c.setCellRenderer(new NumberRightRenderer());
    }

    private class NumberRightRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 3));
            return this;
        }
    }
}

