/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayMessagesPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private final JCheckBox messageBodyAACheckBox = new JCheckBox();
    private final JCheckBox msgTableMultilineSelectCheckBox = new JCheckBox();
    private final JCheckBox msgTableScrollHorizontalCheckBox = new JCheckBox();
    private final JCheckBox sortThreadRootMsgsAscendingCheckBox = new JCheckBox();
    private final JCheckBox showCollapsedThreadsCheckBox = new JCheckBox();
    private final JCheckBox showDeletedMessagesCheckBox = new JCheckBox();
    private final JCheckBox dontShowOwnMessagesAsNewCheckBox = new JCheckBox();
    private final JCheckBox dontShowOwnMessagesAsMECheckBox = new JCheckBox();
    private JPanel indicateLowReceivedMessagesPanel = null;
    private final JCheckBox indicateLowReceivedMessagesCheckBox = new JCheckBox();
    private final JLabel LindicateLowReceivedMessagesCountRed = new JLabel();
    private final JLabel LindicateLowReceivedMessagesCountLightRed = new JLabel();
    private final JTextField TFindicateLowReceivedMessagesCountRed = new JTextField(8);
    private final JTextField TFindicateLowReceivedMessagesCountLightRed = new JTextField(8);
    private final Listener listener = new Listener();

    protected DisplayMessagesPanel(JDialog owner, SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    public void cancel() {
    }

    private JPanel getIndicateLowReceivedMessagesPanel() {
        if (this.indicateLowReceivedMessagesPanel == null) {
            this.indicateLowReceivedMessagesPanel = new JPanel(new GridBagLayout());
            this.indicateLowReceivedMessagesPanel.setBorder(new EmptyBorder(5, 30, 5, 5));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(0, 5, 5, 5);
            constraints.weighty = 0.0;
            constraints.weightx = 0.0;
            constraints.anchor = 18;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.weightx = 0.5;
            this.indicateLowReceivedMessagesPanel.add((Component)this.LindicateLowReceivedMessagesCountRed, constraints);
            constraints.fill = 0;
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            this.indicateLowReceivedMessagesPanel.add((Component)this.TFindicateLowReceivedMessagesCountRed, constraints);
            constraints.fill = 2;
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.weightx = 0.5;
            this.indicateLowReceivedMessagesPanel.add((Component)this.LindicateLowReceivedMessagesCountLightRed, constraints);
            constraints.fill = 0;
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            this.indicateLowReceivedMessagesPanel.add((Component)this.TFindicateLowReceivedMessagesCountLightRed, constraints);
        }
        return this.indicateLowReceivedMessagesPanel;
    }

    private void initialize() {
        Insets inset5511;
        this.setName("DisplayPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.insets = inset5511 = new Insets(5, 5, 1, 1);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.messageBodyAACheckBox, constraints);
        constraints.insets = inset5511;
        ++constraints.gridy;
        this.add((Component)this.msgTableMultilineSelectCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.msgTableScrollHorizontalCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.sortThreadRootMsgsAscendingCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.showCollapsedThreadsCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.showDeletedMessagesCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.dontShowOwnMessagesAsNewCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.dontShowOwnMessagesAsMECheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.indicateLowReceivedMessagesCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.getIndicateLowReceivedMessagesPanel(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)new JLabel(""), constraints);
        this.indicateLowReceivedMessagesCheckBox.addChangeListener(this.listener);
    }

    private void loadSettings() {
        this.messageBodyAACheckBox.setSelected(this.settings.getBoolValue("messageBodyAA"));
        this.msgTableMultilineSelectCheckBox.setSelected(this.settings.getBoolValue("messageTableMultilineSelect"));
        this.msgTableScrollHorizontalCheckBox.setSelected(this.settings.getBoolValue("messageTableScrollHorizontal"));
        this.sortThreadRootMsgsAscendingCheckBox.setSelected(this.settings.getBoolValue("sortThreadRootMessagesAscending"));
        this.showCollapsedThreadsCheckBox.setSelected(this.settings.getBoolValue("messageTableShowCollapsedThreads"));
        this.showDeletedMessagesCheckBox.setSelected(this.settings.getBoolValue("showDeletedMessages"));
        this.dontShowOwnMessagesAsNewCheckBox.setSelected(this.settings.getBoolValue("handleOwnMessagesAsNewDisabled"));
        this.dontShowOwnMessagesAsMECheckBox.setSelected(this.settings.getBoolValue("showOwnMessagesAsMeDisabled"));
        this.TFindicateLowReceivedMessagesCountRed.setText(this.settings.getValue("MessagePanel.indicateLowReceivedMessages.redCount"));
        this.TFindicateLowReceivedMessagesCountLightRed.setText(this.settings.getValue("MessagePanel.indicateLowReceivedMessages.lightRedCount"));
        this.indicateLowReceivedMessagesCheckBox.setSelected(this.settings.getBoolValue("MessagePanel.indicateLowReceivedMessages"));
        this.indicateLowReceivedMessagesChanged();
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.messageBodyAACheckBox.setText(this.language.getString("Options.display.enableAntialiasingForMessageBody"));
        this.msgTableScrollHorizontalCheckBox.setText(this.language.getString("Options.display.showHorizontalScrollbarInMessageTable"));
        this.msgTableMultilineSelectCheckBox.setText(this.language.getString("Options.display.enableMultilineSelectionsInMessageTable"));
        this.sortThreadRootMsgsAscendingCheckBox.setText(this.language.getString("Options.display.sortThreadRootMsgsAscending"));
        this.showCollapsedThreadsCheckBox.setText(this.language.getString("Options.display.showCollapsedThreads"));
        this.showDeletedMessagesCheckBox.setText(this.language.getString("Options.news.3.showDeletedMessages"));
        this.dontShowOwnMessagesAsNewCheckBox.setText(this.language.getString("Options.news.3.dontHandleOwnMessagesAsNew"));
        this.dontShowOwnMessagesAsMECheckBox.setText(this.language.getString("Options.news.3.dontShowOwnMessagesAsMe"));
        this.indicateLowReceivedMessagesCheckBox.setText(this.language.getString("Options.display.indicateLowReceivedMessages"));
        this.LindicateLowReceivedMessagesCountRed.setText(this.language.getString("Options.display.indicateLowReceivedMessagesCountRed"));
        this.LindicateLowReceivedMessagesCountLightRed.setText(this.language.getString("Options.display.indicateLowReceivedMessagesCountLightRed"));
    }

    private void saveSettings() {
        this.settings.setValue("messageBodyAA", this.messageBodyAACheckBox.isSelected());
        this.settings.setValue("messageTableMultilineSelect", this.msgTableMultilineSelectCheckBox.isSelected());
        this.settings.setValue("messageTableScrollHorizontal", this.msgTableScrollHorizontalCheckBox.isSelected());
        this.settings.setValue("sortThreadRootMessagesAscending", this.sortThreadRootMsgsAscendingCheckBox.isSelected());
        this.settings.setValue("messageTableShowCollapsedThreads", this.showCollapsedThreadsCheckBox.isSelected());
        this.settings.setValue("showDeletedMessages", this.showDeletedMessagesCheckBox.isSelected());
        this.settings.setValue("handleOwnMessagesAsNewDisabled", this.dontShowOwnMessagesAsNewCheckBox.isSelected());
        this.settings.setValue("showOwnMessagesAsMeDisabled", this.dontShowOwnMessagesAsMECheckBox.isSelected());
        this.settings.setValue("MessagePanel.indicateLowReceivedMessages.redCount", this.TFindicateLowReceivedMessagesCountRed.getText());
        this.settings.setValue("MessagePanel.indicateLowReceivedMessages.lightRedCount", this.TFindicateLowReceivedMessagesCountLightRed.getText());
        this.settings.setValue("MessagePanel.indicateLowReceivedMessages", this.indicateLowReceivedMessagesCheckBox.isSelected());
    }

    private void indicateLowReceivedMessagesChanged() {
        MiscToolkit.setContainerEnabled(this.getIndicateLowReceivedMessagesPanel(), this.indicateLowReceivedMessagesCheckBox.isSelected());
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == DisplayMessagesPanel.this.indicateLowReceivedMessagesCheckBox) {
                DisplayMessagesPanel.this.indicateLowReceivedMessagesChanged();
            }
        }
    }
}

