/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.FontChooser;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class DisplayPanel
extends JPanel {
    private JDialog owner = null;
    private SettingsClass settings = null;
    private Language language = null;
    private final Listener listener = new Listener();
    private final JLabel fontsLabel = new JLabel();
    private final JCheckBox saveSortStatesCheckBox = new JCheckBox();
    private final JCheckBox showColoredRowsCheckBox = new JCheckBox();
    private final JCheckBox confirmMarkAllMsgsReadCheckBox = new JCheckBox();
    private final JLabel messageBodyLabel = new JLabel();
    private final JLabel fileListLabel = new JLabel();
    private final JLabel messageListLabel = new JLabel();
    private final JButton fileListButton = new JButton();
    private final JButton messageListButton = new JButton();
    private final JButton messageBodyButton = new JButton();
    private final JLabel selectedFileListFontLabel = new JLabel();
    private final JLabel selectedMessageBodyFontLabel = new JLabel();
    private final JLabel selectedMessageListFontLabel = new JLabel();
    private Font selectedBodyFont = null;
    private Font selectedFileListFont = null;
    private Font selectedMessageListFont = null;

    protected DisplayPanel(JDialog owner, SettingsClass settings) {
        this.owner = owner;
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    public void cancel() {
    }

    private void fileListButtonPressed() {
        FontChooser fontChooser = new FontChooser((Dialog)this.owner, this.language);
        fontChooser.setModal(true);
        fontChooser.setSelectedFont(this.selectedFileListFont);
        fontChooser.setVisible(true);
        Font selectedFontTemp = fontChooser.getSelectedFont();
        if (selectedFontTemp != null) {
            this.selectedFileListFont = selectedFontTemp;
            this.selectedFileListFontLabel.setText(this.getFontLabel(this.selectedFileListFont));
        }
    }

    private String getFontLabel(Font font) {
        if (font == null) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        returnValue.append(font.getFamily());
        if (font.isBold()) {
            returnValue.append(" " + this.language.getString("Options.display.fontChooser.bold"));
        }
        if (font.isItalic()) {
            returnValue.append(" " + this.language.getString("Options.display.fontChooser.italic"));
        }
        returnValue.append(", " + font.getSize());
        return returnValue.toString();
    }

    private JPanel getFontsPanel() {
        JPanel fontsPanel = new JPanel(new GridBagLayout());
        fontsPanel.setBorder(new EmptyBorder(5, 20, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        Insets inset1515 = new Insets(1, 5, 1, 5);
        Insets inset1519 = new Insets(1, 5, 1, 9);
        constraints.insets = inset1515;
        constraints.gridx = 0;
        constraints.gridy = 0;
        fontsPanel.add((Component)this.messageBodyLabel, constraints);
        constraints.insets = inset1519;
        constraints.gridx = 1;
        constraints.gridy = 0;
        fontsPanel.add((Component)this.messageBodyButton, constraints);
        constraints.insets = inset1515;
        constraints.gridx = 2;
        constraints.gridy = 0;
        fontsPanel.add((Component)this.selectedMessageBodyFontLabel, constraints);
        constraints.insets = inset1515;
        constraints.gridx = 0;
        constraints.gridy = 1;
        fontsPanel.add((Component)this.messageListLabel, constraints);
        constraints.insets = inset1519;
        constraints.gridx = 1;
        constraints.gridy = 1;
        fontsPanel.add((Component)this.messageListButton, constraints);
        constraints.insets = inset1515;
        constraints.gridx = 2;
        constraints.gridy = 1;
        fontsPanel.add((Component)this.selectedMessageListFontLabel, constraints);
        constraints.insets = inset1515;
        constraints.gridx = 0;
        constraints.gridy = 2;
        fontsPanel.add((Component)this.fileListLabel, constraints);
        constraints.insets = inset1519;
        constraints.gridx = 1;
        constraints.gridy = 2;
        fontsPanel.add((Component)this.fileListButton, constraints);
        constraints.insets = inset1515;
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        fontsPanel.add((Component)this.selectedFileListFontLabel, constraints);
        return fontsPanel;
    }

    private void initialize() {
        this.setName("DisplayPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        Insets inset5511 = new Insets(5, 5, 1, 1);
        Insets insets2 = new Insets(15, 5, 1, 1);
        constraints.insets = inset5511;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.fontsLabel, constraints);
        ++constraints.gridy;
        this.add((Component)this.getFontsPanel(), constraints);
        constraints.insets = insets2;
        ++constraints.gridy;
        this.add((Component)this.showColoredRowsCheckBox, constraints);
        constraints.insets = inset5511;
        ++constraints.gridy;
        this.add((Component)this.saveSortStatesCheckBox, constraints);
        constraints.insets = insets2;
        ++constraints.gridy;
        this.add((Component)this.confirmMarkAllMsgsReadCheckBox, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)new JLabel(""), constraints);
        this.messageBodyButton.addActionListener(this.listener);
        this.messageListButton.addActionListener(this.listener);
        this.fileListButton.addActionListener(this.listener);
    }

    private void loadSettings() {
        String fontName = this.settings.getValue("messageBodyFontName");
        int fontSize = this.settings.getIntValue("messageBodyFontSize");
        int fontStyle = this.settings.getIntValue("messageBodyFontStyle");
        this.selectedBodyFont = new Font(fontName, fontStyle, fontSize);
        this.selectedMessageBodyFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        fontName = this.settings.getValue("messageListFontName");
        fontSize = this.settings.getIntValue("messageListFontSize");
        fontStyle = this.settings.getIntValue("messageListFontStyle");
        this.selectedMessageListFont = new Font(fontName, fontStyle, fontSize);
        this.selectedMessageListFontLabel.setText(this.getFontLabel(this.selectedMessageListFont));
        fontName = this.settings.getValue("fileListFontName");
        fontSize = this.settings.getIntValue("fileListFontSize");
        fontStyle = this.settings.getIntValue("fileListFontStyle");
        this.selectedFileListFont = new Font(fontName, fontStyle, fontSize);
        this.selectedFileListFontLabel.setText(this.getFontLabel(this.selectedFileListFont));
        this.saveSortStatesCheckBox.setSelected(this.settings.getBoolValue("saveSortStates"));
        this.showColoredRowsCheckBox.setSelected(this.settings.getBoolValue("showColoredRows"));
        this.confirmMarkAllMsgsReadCheckBox.setSelected(this.settings.getBoolValue("confirm.markAllMessagesRead"));
    }

    private void messageBodyButtonPressed() {
        FontChooser fontChooser = new FontChooser((Dialog)this.owner, this.language);
        fontChooser.setModal(true);
        fontChooser.setSelectedFont(this.selectedBodyFont);
        fontChooser.setVisible(true);
        Font selectedFontTemp = fontChooser.getSelectedFont();
        if (selectedFontTemp != null) {
            this.selectedBodyFont = selectedFontTemp;
            this.selectedMessageBodyFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        }
    }

    private void messageListButtonPressed() {
        FontChooser fontChooser = new FontChooser((Dialog)this.owner, this.language);
        fontChooser.setModal(true);
        fontChooser.setSelectedFont(this.selectedMessageListFont);
        fontChooser.setVisible(true);
        Font selectedFontTemp = fontChooser.getSelectedFont();
        if (selectedFontTemp != null) {
            this.selectedMessageListFont = selectedFontTemp;
            this.selectedMessageListFontLabel.setText(this.getFontLabel(this.selectedMessageListFont));
        }
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        String choose = this.language.getString("Options.display.choose");
        this.fontsLabel.setText(this.language.getString("Options.display.fonts"));
        this.messageBodyLabel.setText(this.language.getString("Options.display.messageBody"));
        this.messageBodyButton.setText(choose);
        this.selectedMessageBodyFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        this.messageListLabel.setText(this.language.getString("Options.display.messageList"));
        this.messageListButton.setText(choose);
        this.selectedMessageListFontLabel.setText(this.getFontLabel(this.selectedMessageListFont));
        this.fileListLabel.setText(this.language.getString("Options.display.fileList"));
        this.fileListButton.setText(choose);
        this.selectedFileListFontLabel.setText(this.getFontLabel(this.selectedFileListFont));
        this.saveSortStatesCheckBox.setText(this.language.getString("Options.display.saveSortStates"));
        this.showColoredRowsCheckBox.setText(this.language.getString("Options.display.showColoredRows"));
        this.confirmMarkAllMsgsReadCheckBox.setText(this.language.getString("Options.display.confirmMarkAllMsgsRead"));
    }

    private void saveSettings() {
        if (this.selectedBodyFont != null) {
            this.settings.setValue("messageBodyFontName", this.selectedBodyFont.getFamily());
            this.settings.setValue("messageBodyFontStyle", this.selectedBodyFont.getStyle());
            this.settings.setValue("messageBodyFontSize", this.selectedBodyFont.getSize());
        }
        if (this.selectedMessageListFont != null) {
            this.settings.setValue("messageListFontName", this.selectedMessageListFont.getFamily());
            this.settings.setValue("messageListFontStyle", this.selectedMessageListFont.getStyle());
            this.settings.setValue("messageListFontSize", this.selectedMessageListFont.getSize());
        }
        if (this.selectedFileListFont != null) {
            this.settings.setValue("fileListFontName", this.selectedFileListFont.getFamily());
            this.settings.setValue("fileListFontStyle", this.selectedFileListFont.getStyle());
            this.settings.setValue("fileListFontSize", this.selectedFileListFont.getSize());
        }
        this.settings.setValue("saveSortStates", this.saveSortStatesCheckBox.isSelected());
        this.settings.setValue("showColoredRows", this.showColoredRowsCheckBox.isSelected());
        this.settings.setValue("confirm.markAllMessagesRead", this.confirmMarkAllMsgsReadCheckBox.isSelected());
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DisplayPanel.this.messageBodyButton) {
                DisplayPanel.this.messageBodyButtonPressed();
            }
            if (e.getSource() == DisplayPanel.this.messageListButton) {
                DisplayPanel.this.messageListButtonPressed();
            }
            if (e.getSource() == DisplayPanel.this.fileListButton) {
                DisplayPanel.this.fileListButtonPressed();
            }
        }
    }
}

