/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.fcp.FcpHandler;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.JTranslatableComboBox;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class MiscPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private final JLabel autoSaveIntervalLabel = new JLabel();
    private final JTextField autoSaveIntervalTextField = new JTextField(8);
    private final JCheckBox autoSaveLocalIdentitiesCheckBox = new JCheckBox();
    private final JLabel availableNodesLabel1 = new JLabel();
    private final JTextField availableNodesTextField = new JTextField();
    private final JCheckBox useDDACheckBox = new JCheckBox();
    private final JCheckBox usePersistenceCheckBox = new JCheckBox();
    private final JCheckBox enableLoggingCheckBox = new JCheckBox();
    private final Listener listener = new Listener();
    private final JLabel logFileSizeLabel = new JLabel();
    private final JTextField logFileSizeTextField = new JTextField(8);
    private JTranslatableComboBox logLevelComboBox = null;
    private final JLabel logLevelLabel = new JLabel();
    private final JCheckBox showSystrayIconCheckBox = new JCheckBox();
    private final JCheckBox minimizeToSystrayCheckBox = new JCheckBox();
    private final JCheckBox splashScreenCheckBox = new JCheckBox();
    private final JCheckBox compactDatabaseAtNextStartupCheckBox = new JCheckBox();

    protected MiscPanel(SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
        if (FcpHandler.isFreenet05()) {
            this.useDDACheckBox.setEnabled(false);
            this.usePersistenceCheckBox.setEnabled(false);
        }
    }

    private JPanel getLoggingPanel() {
        JPanel subPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        Insets insets5035 = new Insets(5, 0, 5, 5);
        Insets insets0_30_5_5 = new Insets(0, 30, 5, 5);
        Insets insets0_5_5_5 = new Insets(0, 5, 5, 5);
        Insets insets0_5_5_0 = new Insets(0, 5, 3, 0);
        constraints.insets = insets5035;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 4;
        subPanel.add((Component)this.enableLoggingCheckBox, constraints);
        constraints.insets = insets0_30_5_5;
        constraints.gridwidth = 1;
        ++constraints.gridy;
        subPanel.add((Component)this.logLevelLabel, constraints);
        constraints.gridx = 1;
        String[] searchComboBoxKeys = new String[]{"Options.miscellaneous.logLevel.veryLow", "Options.miscellaneous.logLevel.low", "Options.miscellaneous.logLevel.medium", "Options.miscellaneous.logLevel.high", "Options.miscellaneous.logLevel.veryHigh"};
        this.logLevelComboBox = new JTranslatableComboBox(this.language, searchComboBoxKeys);
        constraints.insets = insets0_5_5_5;
        subPanel.add((Component)this.logLevelComboBox, constraints);
        constraints.gridx = 2;
        constraints.insets = insets0_30_5_5;
        subPanel.add((Component)this.logFileSizeLabel, constraints);
        constraints.insets = insets0_5_5_0;
        constraints.gridx = 3;
        constraints.weightx = 0.0;
        subPanel.add((Component)this.logFileSizeTextField, constraints);
        return subPanel;
    }

    private void initialize() {
        this.setName("MiscPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.autoSaveIntervalTextField, this.language);
        new TextComponentClipboardMenu(this.availableNodesTextField, this.language);
        new TextComponentClipboardMenu(this.logFileSizeTextField, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        Insets insets5555 = new Insets(5, 5, 5, 5);
        Insets insets0555 = new Insets(0, 5, 5, 5);
        constraints.weightx = 0.0;
        constraints.insets = insets5555;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        this.add((Component)this.availableNodesLabel1, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        this.add((Component)this.availableNodesTextField, constraints);
        constraints.insets = insets0555;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)this.useDDACheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.usePersistenceCheckBox, constraints);
        constraints.insets = insets5555;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)this.autoSaveIntervalLabel, constraints);
        constraints.gridx = 1;
        constraints.fill = 0;
        this.add((Component)this.autoSaveIntervalTextField, constraints);
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)this.autoSaveLocalIdentitiesCheckBox, constraints);
        constraints.insets = insets0555;
        ++constraints.gridy;
        this.add((Component)this.splashScreenCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.showSystrayIconCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.minimizeToSystrayCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.compactDatabaseAtNextStartupCheckBox, constraints);
        constraints.insets = new Insets(0, 5, 0, 5);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 3;
        this.add((Component)this.getLoggingPanel(), constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(""), constraints);
        this.enableLoggingCheckBox.addActionListener(this.listener);
    }

    private void loadSettings() {
        this.showSystrayIconCheckBox.setSelected(this.settings.getBoolValue("showSystrayIcon"));
        this.minimizeToSystrayCheckBox.setSelected(this.settings.getBoolValue("minimizeToSystray"));
        this.compactDatabaseAtNextStartupCheckBox.setSelected(this.settings.getBoolValue("perst.compactStorages"));
        this.availableNodesTextField.setText(this.settings.getValue("availableNodes"));
        this.autoSaveIntervalTextField.setText(Integer.toString(this.settings.getIntValue("autoSaveInterval")));
        this.autoSaveLocalIdentitiesCheckBox.setSelected(this.settings.getBoolValue("autoSaveLocalIdentities"));
        this.enableLoggingCheckBox.setSelected(this.settings.getBoolValue("logToFile"));
        this.logFileSizeTextField.setText(Integer.toString(this.settings.getIntValue("logFileSizeLimit")));
        this.logLevelComboBox.setSelectedKey(this.settings.getDefaultValue("logLevel"));
        this.logLevelComboBox.setSelectedKey(this.settings.getValue("logLevel"));
        this.splashScreenCheckBox.setSelected(this.settings.getBoolValue("disableSplashScreen"));
        this.useDDACheckBox.setSelected(this.settings.getBoolValue("fcp2.useDDA"));
        this.usePersistenceCheckBox.setSelected(this.settings.getBoolValue("fcp2.usePersistence"));
        this.refreshLoggingState();
    }

    public void ok() {
        String nodes = this.availableNodesTextField.getText();
        if (nodes.indexOf(",") > -1 && this.usePersistenceCheckBox.isSelected()) {
            MiscToolkit.showMessage("Persistence is not possible with more than 1 node. Persistence disabled.", 0, "Warning: Persistence is not possible");
            this.usePersistenceCheckBox.setSelected(false);
        }
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.availableNodesLabel1.setText(this.language.getString("Options.miscellaneous.listOfFcpNodes") + " " + this.language.getString("Options.miscellaneous.listOfFcpNodesExplanation"));
        this.useDDACheckBox.setText(this.language.getString("Options.miscellaneous.useDDA"));
        this.useDDACheckBox.setToolTipText(this.language.getString("Options.miscellaneous.useDDA.tooltip"));
        this.usePersistenceCheckBox.setText(this.language.getString("Options.miscellaneous.usePersistence"));
        this.autoSaveIntervalLabel.setText(this.language.getString("Options.miscellaneous.automaticSavingInterval") + " (60 " + this.language.getString("Options.common.minutes") + ")");
        this.autoSaveLocalIdentitiesCheckBox.setText(this.language.getString("Options.miscellaneous.autoSaveLocalIdentities"));
        this.splashScreenCheckBox.setText(this.language.getString("Options.miscellaneous.disableSplashscreen"));
        this.showSystrayIconCheckBox.setText(this.language.getString("Options.miscellaneous.showSysTrayIcon"));
        this.minimizeToSystrayCheckBox.setText(this.language.getString("Options.miscellaneous.minimizeToSystray"));
        this.compactDatabaseAtNextStartupCheckBox.setText(this.language.getString("Options.miscellaneous.compactStoragesDuringNextStartup"));
        this.enableLoggingCheckBox.setText(this.language.getString("Options.miscellaneous.enableLogging"));
        this.logLevelLabel.setText(this.language.getString("Options.miscellaneous.loggingLevel") + " (" + this.language.getString("Options.miscellaneous.logLevel.low") + ") ");
        this.logFileSizeLabel.setText(this.language.getString("Options.miscellaneous.logFileSizeLimit"));
    }

    private void refreshLoggingState() {
        boolean enableLogging = this.enableLoggingCheckBox.isSelected();
        this.logLevelLabel.setEnabled(enableLogging);
        this.logLevelComboBox.setEnabled(enableLogging);
        this.logFileSizeLabel.setEnabled(enableLogging);
        this.logFileSizeTextField.setEnabled(enableLogging);
    }

    private void saveSettings() {
        this.settings.setValue("availableNodes", this.availableNodesTextField.getText());
        this.settings.setValue("showSystrayIcon", this.showSystrayIconCheckBox.isSelected());
        this.settings.setValue("minimizeToSystray", this.minimizeToSystrayCheckBox.isSelected());
        this.settings.setValue("perst.compactStorages", this.compactDatabaseAtNextStartupCheckBox.isSelected());
        this.settings.setValue("autoSaveInterval", this.autoSaveIntervalTextField.getText());
        this.settings.setValue("autoSaveLocalIdentities", this.autoSaveLocalIdentitiesCheckBox.isSelected());
        this.settings.setValue("logToFile", this.enableLoggingCheckBox.isSelected());
        this.settings.setValue("logFileSizeLimit", this.logFileSizeTextField.getText());
        this.settings.setValue("logLevel", this.logLevelComboBox.getSelectedKey());
        this.settings.setValue("disableSplashScreen", this.splashScreenCheckBox.isSelected());
        this.settings.setValue("fcp2.useDDA", this.useDDACheckBox.isSelected());
        this.settings.setValue("fcp2.usePersistence", this.usePersistenceCheckBox.isSelected());
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MiscPanel.this.enableLoggingCheckBox) {
                MiscPanel.this.refreshLoggingState();
            }
        }
    }
}

