/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.gui.preferences.DisplayBoardTreePanel;
import frost.gui.preferences.DisplayMessagesPanel;
import frost.gui.preferences.DisplayPanel;
import frost.gui.preferences.DownloadPanel;
import frost.gui.preferences.ExpirationPanel;
import frost.gui.preferences.JunkPanel;
import frost.gui.preferences.MiscPanel;
import frost.gui.preferences.News2Panel;
import frost.gui.preferences.NewsPanel;
import frost.gui.preferences.SearchPanel;
import frost.gui.preferences.UploadPanel;
import frost.storage.StorageException;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OptionsFrame
extends JDialog
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(OptionsFrame.class.getName());
    private final SettingsClass frostSettings;
    private final Language language;
    private JPanel buttonPanel = null;
    private boolean checkBlock;
    private boolean checkBlockBody;
    private boolean checkHideBadMessages;
    private boolean checkHideCheckMessages;
    private boolean checkHideObserveMessages;
    private boolean checkHideJunkMessages;
    private String checkMaxMessageDisplay;
    private String checkMaxMessageDownload;
    private boolean checkSignedOnly;
    private boolean checkRememberSharedFileDownloaded;
    private boolean checkShowDeletedMessages;
    private boolean showColoredRows;
    private boolean checkShowOwnMessagesAsMeDisabled;
    private boolean checkIndicateLowReceivedMessages;
    private JPanel contentAreaPanel = null;
    private DisplayPanel displayPanel = null;
    private DisplayBoardTreePanel displayBoardTreePanel = null;
    private DisplayMessagesPanel displayMessagesPanel = null;
    private DownloadPanel downloadPanel = null;
    private boolean exitState;
    private JPanel mainPanel = null;
    private MiscPanel miscPanel = null;
    private NewsPanel newsPanel = null;
    private News2Panel news2Panel = null;
    private JunkPanel junkPanel = null;
    private ExpirationPanel expirationPanel = null;
    private JList optionsGroupsList = null;
    private JPanel optionsGroupsPanel = null;
    private SearchPanel searchPanel = null;
    private boolean shouldReloadMessages = false;
    private boolean shouldResetLastBackloadUpdateFinishedMillis = false;
    private boolean shouldResetSharedFilesLastDownloaded = false;
    private UploadPanel uploadPanel = null;
    private static int lastSelectedPanelIndex = 0;

    public OptionsFrame(Frame parent, SettingsClass settings) {
        super(parent);
        this.setModal(true);
        this.language = Language.getInstance();
        this.frostSettings = settings;
        this.setDataElements();
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
        }
        this.optionsGroupsList.setSelectedIndex(lastSelectedPanelIndex);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void cancel() {
        this.exitState = false;
        this.dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.cancel();
    }

    protected Dimension computeMaxSize(ListModel m) {
        if (m == null || m.getSize() == 0) {
            return null;
        }
        int maxX = -1;
        int maxY = -1;
        JDialog dlgdummy = new JDialog();
        for (int x = 0; x < m.getSize(); ++x) {
            ListBoxData lbdata = (ListBoxData)m.getElementAt(x);
            JPanel aPanel = lbdata.getPanel();
            this.contentAreaPanel.removeAll();
            this.contentAreaPanel.add((Component)aPanel, "Center");
            dlgdummy.setContentPane(this.contentAreaPanel);
            dlgdummy.pack();
            int tmpX = this.contentAreaPanel.getWidth();
            int tmpY = this.contentAreaPanel.getHeight();
            maxX = Math.max(maxX, tmpX);
            maxY = Math.max(maxY, tmpY);
        }
        dlgdummy = null;
        this.contentAreaPanel.removeAll();
        return new Dimension(maxX, maxY);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2, 10, 10));
            JButton okButton = new JButton(this.language.getString("Common.ok"));
            JButton cancelButton = new JButton(this.language.getString("Common.cancel"));
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsFrame.this.okButton_actionPerformed(e);
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsFrame.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add(okButton);
            this.buttonPanel.add(cancelButton);
        }
        return this.buttonPanel;
    }

    private DisplayPanel getDisplayPanel() {
        if (this.displayPanel == null) {
            this.displayPanel = new DisplayPanel(this, this.frostSettings);
        }
        return this.displayPanel;
    }

    private DisplayBoardTreePanel getDisplayBoardTreePanel() {
        if (this.displayBoardTreePanel == null) {
            this.displayBoardTreePanel = new DisplayBoardTreePanel(this, this.frostSettings);
        }
        return this.displayBoardTreePanel;
    }

    private DisplayMessagesPanel getDisplayMessagesPanel() {
        if (this.displayMessagesPanel == null) {
            this.displayMessagesPanel = new DisplayMessagesPanel(this, this.frostSettings);
        }
        return this.displayMessagesPanel;
    }

    private DownloadPanel getDownloadPanel() {
        if (this.downloadPanel == null) {
            this.downloadPanel = new DownloadPanel(this, this.frostSettings);
        }
        return this.downloadPanel;
    }

    private MiscPanel getMiscPanel() {
        if (this.miscPanel == null) {
            this.miscPanel = new MiscPanel(this.frostSettings);
        }
        return this.miscPanel;
    }

    private News2Panel getNews2Panel() {
        if (this.news2Panel == null) {
            this.news2Panel = new News2Panel(this.frostSettings);
        }
        return this.news2Panel;
    }

    private JunkPanel getJunkPanel() {
        if (this.junkPanel == null) {
            this.junkPanel = new JunkPanel(this.frostSettings);
        }
        return this.junkPanel;
    }

    private ExpirationPanel getExpirationPanel() {
        if (this.expirationPanel == null) {
            this.expirationPanel = new ExpirationPanel(this, this.frostSettings);
        }
        return this.expirationPanel;
    }

    private NewsPanel getNewsPanel() {
        if (this.newsPanel == null) {
            this.newsPanel = new NewsPanel(this.frostSettings);
        }
        return this.newsPanel;
    }

    protected JPanel getOptionsGroupsPanel() {
        if (this.optionsGroupsPanel == null) {
            Vector<ListBoxData> listData = new Vector<ListBoxData>();
            listData.add(new ListBoxData(" " + this.language.getString("Options.downloads") + " ", this.getDownloadPanel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.uploads") + " ", this.getUploadPanel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.news") + " (1) ", this.getNewsPanel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.news") + " (2) ", this.getNews2Panel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.junk") + " ", this.getJunkPanel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.display") + " ", this.getDisplayPanel()));
            listData.add(new ListBoxData("    " + this.language.getString("Options.boardTree") + " ", this.getDisplayBoardTreePanel()));
            listData.add(new ListBoxData("    " + this.language.getString("Options.messages") + " ", this.getDisplayMessagesPanel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.expiration") + " ", this.getExpirationPanel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.search") + " ", this.getSearchPanel()));
            listData.add(new ListBoxData(" " + this.language.getString("Options.miscellaneous") + " ", this.getMiscPanel()));
            this.optionsGroupsList = new JList(listData);
            this.optionsGroupsList.setSelectionMode(1);
            this.optionsGroupsList.addListSelectionListener(this);
            this.optionsGroupsPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constr = new GridBagConstraints();
            constr.anchor = 18;
            constr.fill = 1;
            constr.weightx = 0.7;
            constr.weighty = 0.7;
            constr.insets = new Insets(5, 5, 5, 5);
            constr.gridx = 0;
            constr.gridy = 0;
            this.optionsGroupsPanel.add((Component)this.optionsGroupsList, constr);
            this.optionsGroupsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
        }
        return this.optionsGroupsPanel;
    }

    private SearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel(this.frostSettings);
        }
        return this.searchPanel;
    }

    private UploadPanel getUploadPanel() {
        if (this.uploadPanel == null) {
            this.uploadPanel = new UploadPanel(this.frostSettings);
        }
        return this.uploadPanel;
    }

    private void Init() throws Exception {
        this.setTitle(this.language.getString("Options.title"));
        this.setResizable(true);
        this.mainPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, null);
        this.contentAreaPanel = new JPanel(new BorderLayout());
        this.contentAreaPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.contentAreaPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5), this.contentAreaPanel.getBorder()));
        this.mainPanel.add((Component)this.getButtonPanel(), "South");
        this.mainPanel.add((Component)this.getOptionsGroupsPanel(), "West");
        Dimension neededSize = this.computeMaxSize(this.optionsGroupsList.getModel());
        this.contentAreaPanel.setMinimumSize(neededSize);
        this.contentAreaPanel.setPreferredSize(neededSize);
        this.mainPanel.add((Component)this.contentAreaPanel, "Center");
    }

    private void ok() {
        this.exitState = true;
        if (this.displayPanel != null) {
            this.displayPanel.ok();
        }
        if (this.displayBoardTreePanel != null) {
            this.displayBoardTreePanel.ok();
        }
        if (this.displayMessagesPanel != null) {
            this.displayMessagesPanel.ok();
        }
        if (this.downloadPanel != null) {
            this.downloadPanel.ok();
        }
        if (this.searchPanel != null) {
            this.searchPanel.ok();
        }
        if (this.uploadPanel != null) {
            this.uploadPanel.ok();
        }
        if (this.miscPanel != null) {
            this.miscPanel.ok();
        }
        if (this.newsPanel != null) {
            this.newsPanel.ok();
        }
        if (this.news2Panel != null) {
            this.news2Panel.ok();
        }
        if (this.junkPanel != null) {
            this.junkPanel.ok();
        }
        if (this.expirationPanel != null) {
            this.expirationPanel.ok();
        }
        this.saveSettings();
        this.dispose();
    }

    private void okButton_actionPerformed(ActionEvent e) {
        this.ok();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    public boolean runDialog() {
        this.exitState = false;
        this.setVisible(true);
        return this.exitState;
    }

    private void saveSettings() {
        try {
            this.frostSettings.exitSave();
        }
        catch (StorageException se) {
            logger.log(Level.SEVERE, "Error while saving the settings.", se);
        }
        if (!this.checkMaxMessageDisplay.equals(this.frostSettings.getValue("maxMessageDisplay")) || this.checkSignedOnly != this.frostSettings.getBoolValue("signedOnly") || this.checkHideBadMessages != this.frostSettings.getBoolValue("hideBadMessages") || this.checkHideCheckMessages != this.frostSettings.getBoolValue("hideCheckMessages") || this.checkHideObserveMessages != this.frostSettings.getBoolValue("hideObserveMessages") || this.checkHideJunkMessages != this.frostSettings.getBoolValue("junk.hideJunkMessages") || this.checkBlock != this.frostSettings.getBoolValue("blockMessageChecked") || this.checkBlockBody != this.frostSettings.getBoolValue("blockMessageBodyChecked") || this.checkShowDeletedMessages != this.frostSettings.getBoolValue("showDeletedMessages") || this.showColoredRows != this.frostSettings.getBoolValue("showColoredRows") || this.checkShowOwnMessagesAsMeDisabled != this.frostSettings.getBoolValue("showOwnMessagesAsMeDisabled") || this.checkIndicateLowReceivedMessages != this.frostSettings.getBoolValue("MessagePanel.indicateLowReceivedMessages")) {
            this.shouldReloadMessages = true;
        }
        if (!this.checkMaxMessageDownload.equals(this.frostSettings.getValue("maxMessageDownload"))) {
            this.shouldResetLastBackloadUpdateFinishedMillis = true;
        }
        if (this.checkRememberSharedFileDownloaded && !this.frostSettings.getBoolValue("rememberSharedFileDownloaded")) {
            this.shouldResetSharedFilesLastDownloaded = true;
        }
    }

    private void setDataElements() {
        this.checkMaxMessageDisplay = this.frostSettings.getValue("maxMessageDisplay");
        this.checkMaxMessageDownload = this.frostSettings.getValue("maxMessageDownload");
        this.checkSignedOnly = this.frostSettings.getBoolValue("signedOnly");
        this.checkHideBadMessages = this.frostSettings.getBoolValue("hideBadMessages");
        this.checkHideCheckMessages = this.frostSettings.getBoolValue("hideCheckMessages");
        this.checkHideObserveMessages = this.frostSettings.getBoolValue("hideObserveMessages");
        this.checkHideJunkMessages = this.frostSettings.getBoolValue("junk.hideJunkMessages");
        this.checkBlock = this.frostSettings.getBoolValue("blockMessageChecked");
        this.checkBlockBody = this.frostSettings.getBoolValue("blockMessageBodyChecked");
        this.checkShowDeletedMessages = this.frostSettings.getBoolValue("showDeletedMessages");
        this.checkShowOwnMessagesAsMeDisabled = this.frostSettings.getBoolValue("showOwnMessagesAsMeDisabled");
        this.checkIndicateLowReceivedMessages = this.frostSettings.getBoolValue("MessagePanel.indicateLowReceivedMessages");
        this.checkRememberSharedFileDownloaded = this.frostSettings.getBoolValue("rememberSharedFileDownloaded");
        this.showColoredRows = this.frostSettings.getBoolValue("showColoredRows");
    }

    public boolean shouldReloadMessages() {
        return this.shouldReloadMessages;
    }

    public boolean shouldResetLastBackloadUpdateFinishedMillis() {
        return this.shouldResetLastBackloadUpdateFinishedMillis;
    }

    public boolean shouldResetSharedFilesLastDownloaded() {
        return this.shouldResetSharedFilesLastDownloaded;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        JList theList = (JList)e.getSource();
        Object Olbdata = theList.getSelectedValue();
        lastSelectedPanelIndex = theList.getSelectedIndex();
        this.contentAreaPanel.removeAll();
        if (Olbdata instanceof ListBoxData) {
            ListBoxData lbdata = (ListBoxData)Olbdata;
            JPanel newPanel = lbdata.getPanel();
            this.contentAreaPanel.add((Component)newPanel, "Center");
            newPanel.revalidate();
            newPanel.repaint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OptionsFrame.this.contentAreaPanel.revalidate();
            }
        });
    }

    class ListBoxData {
        String name;
        JPanel panel;

        public ListBoxData(String n, JPanel p) {
            this.panel = p;
            this.name = n;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public String toString() {
            return this.name;
        }
    }
}

