/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.sentmessages;

import frost.gui.sentmessages.SentMessagesTable;
import frost.messages.FrostMessageObject;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SentMessagesPanel
extends JPanel
implements LanguageListener {
    Language language = Language.getInstance();
    private JLabel sentMsgsLabel;
    private SentMessagesTable sentMessagesTable;
    private boolean isShown = false;

    public SentMessagesPanel() {
        this.language.addLanguageListener(this);
        this.initialize();
        this.refreshLanguage();
    }

    public synchronized void prepareForShow() {
        this.loadTableModel();
        this.isShown = true;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public synchronized void cleanupAfterLeave() {
        this.clearTableModel();
        this.isShown = false;
    }

    public synchronized boolean addSentMessage(FrostMessageObject i) {
        if (this.isShown) {
            this.sentMessagesTable.addSentMessage(i);
            return true;
        }
        return false;
    }

    public void updateSentMessagesCount() {
        this.refreshLanguage();
    }

    public void clearTableModel() {
        this.sentMessagesTable.clearTableModel();
    }

    public void loadTableModel() {
        this.sentMessagesTable.loadTableModel();
        this.refreshLanguage();
    }

    public void saveTableFormat() {
        this.sentMessagesTable.saveTableFormat();
    }

    public void refreshLanguage() {
        this.sentMsgsLabel.setText(this.language.getString("SentMessages.label") + " (" + this.sentMessagesTable.getRowCount() + ")");
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.sentMsgsLabel = new JLabel();
        this.sentMsgsLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.add((Component)this.sentMsgsLabel, "North");
        this.sentMessagesTable = new SentMessagesTable();
        this.sentMessagesTable.getScrollPane().setWheelScrollingEnabled(true);
        this.add((Component)this.sentMessagesTable.getScrollPane(), "Center");
        Font font = this.sentMsgsLabel.getFont();
        font = font.deriveFont(1);
        this.sentMsgsLabel.setFont(font);
    }
}

