/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.sentmessages;

import frost.Core;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.gui.sentmessages.SentMessagesTableItem;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModelTable;
import frost.util.model.SortedTableFormat;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SentMessagesTableFormat
extends SortedTableFormat
implements LanguageListener,
PropertyChangeListener {
    private static final String CFGKEY_SORTSTATE_SORTEDCOLUMN = "SentMessagesTable.sortState.sortedColumn";
    private static final String CFGKEY_SORTSTATE_SORTEDASCENDING = "SentMessagesTable.sortState.sortedAscending";
    private static final String CFGKEY_COLUMN_TABLEINDEX = "SentMessagesTable.tableindex.modelcolumn.";
    private static final String CFGKEY_COLUMN_WIDTH = "SentMessagesTable.columnwidth.modelcolumn.";
    private Language language = Language.getInstance();
    private static final int COLUMN_COUNT = 5;
    private SortedModelTable modelTable;
    private boolean showColoredLines;

    public SentMessagesTableFormat() {
        super(5);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(new BoardComparator(), 0);
        this.setComparator(new SubjectComparator(), 1);
        this.setComparator(new FromComparator(), 2);
        this.setComparator(new ToComparator(), 3);
        this.setComparator(new DateComparator(), 4);
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        Core.frostSettings.addPropertyChangeListener(this);
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("SentMessages.table.board"));
        this.setColumnName(1, this.language.getString("SentMessages.table.subject"));
        this.setColumnName(2, this.language.getString("SentMessages.table.from"));
        this.setColumnName(3, this.language.getString("SentMessages.table.to"));
        this.setColumnName(4, this.language.getString("SentMessages.table.date"));
        this.refreshColumnNames();
    }

    public Object getCellValue(ModelItem item, int columnIndex) {
        if (item == null) {
            return "*null*";
        }
        SentMessagesTableItem searchItem = (SentMessagesTableItem)item;
        switch (columnIndex) {
            case 0: {
                return searchItem.getBoardName();
            }
            case 1: {
                return searchItem.getSubject();
            }
            case 2: {
                return searchItem.getFrom();
            }
            case 3: {
                return searchItem.getTo();
            }
            case 4: {
                return searchItem.getDateAndTimeString();
            }
        }
        return "**ERROR**";
    }

    public int[] getColumnNumbers(int fieldID) {
        return new int[0];
    }

    public void customizeTable(ModelTable lModelTable) {
        super.customizeTable(lModelTable);
        this.modelTable = (SortedModelTable)lModelTable;
        this.modelTable.getTable().setAutoResizeMode(1);
        TableColumnModel columnModel = this.modelTable.getTable().getColumnModel();
        ShowContentTooltipRenderer tooltipRenderer = new ShowContentTooltipRenderer();
        columnModel.getColumn(0).setCellRenderer(tooltipRenderer);
        columnModel.getColumn(1).setCellRenderer(new SubjectRenderer());
        columnModel.getColumn(2).setCellRenderer(tooltipRenderer);
        columnModel.getColumn(3).setCellRenderer(tooltipRenderer);
        columnModel.getColumn(4).setCellRenderer(new ShowColoredLinesRenderer());
        if (!this.loadTableLayout(columnModel)) {
            int[] widths = new int[]{60, 150, 60, 60, 70};
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
        if (Core.frostSettings.getBoolValue("saveSortStates") && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDCOLUMN) != null && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDASCENDING) != null) {
            int sortedColumn = Core.frostSettings.getIntValue(CFGKEY_SORTSTATE_SORTEDCOLUMN);
            boolean isSortedAsc = Core.frostSettings.getBoolValue(CFGKEY_SORTSTATE_SORTEDASCENDING);
            if (sortedColumn > -1) {
                this.modelTable.setSortedColumn(sortedColumn, isSortedAsc);
            }
        } else {
            this.modelTable.setSortedColumn(4, false);
        }
    }

    public void saveTableLayout() {
        TableColumnModel tcm = this.modelTable.getTable().getColumnModel();
        for (int columnIndexInTable = 0; columnIndexInTable < tcm.getColumnCount(); ++columnIndexInTable) {
            TableColumn tc = tcm.getColumn(columnIndexInTable);
            int columnIndexInModel = tc.getModelIndex();
            Core.frostSettings.setValue(CFGKEY_COLUMN_TABLEINDEX + columnIndexInModel, columnIndexInTable);
            int columnWidth = tc.getWidth();
            Core.frostSettings.setValue(CFGKEY_COLUMN_WIDTH + columnIndexInModel, columnWidth);
        }
        if (Core.frostSettings.getBoolValue("saveSortStates") && this.modelTable.getSortedColumn() > -1) {
            int sortedColumn = this.modelTable.getSortedColumn();
            boolean isSortedAsc = this.modelTable.isSortedAscending();
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDCOLUMN, sortedColumn);
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDASCENDING, isSortedAsc);
        }
    }

    private boolean loadTableLayout(TableColumnModel tcm) {
        int x;
        int[] tableToModelIndex = new int[tcm.getColumnCount()];
        int[] columnWidths = new int[tcm.getColumnCount()];
        for (int x2 = 0; x2 < tableToModelIndex.length; ++x2) {
            String indexKey = CFGKEY_COLUMN_TABLEINDEX + x2;
            if (Core.frostSettings.getObjectValue(indexKey) == null) {
                return false;
            }
            int tableIndex = Core.frostSettings.getIntValue(indexKey);
            if (tableIndex < 0 || tableIndex >= tableToModelIndex.length) {
                return false;
            }
            tableToModelIndex[tableIndex] = x2;
            String widthKey = CFGKEY_COLUMN_WIDTH + x2;
            if (Core.frostSettings.getObjectValue(widthKey) == null) {
                return false;
            }
            int columnWidth = Core.frostSettings.getIntValue(widthKey);
            if (columnWidth <= 0) {
                return false;
            }
            columnWidths[x2] = columnWidth;
        }
        TableColumn[] tcms = new TableColumn[tcm.getColumnCount()];
        for (x = tcms.length - 1; x >= 0; --x) {
            tcms[x] = tcm.getColumn(x);
            tcm.removeColumn(tcms[x]);
            tcms[x].setPreferredWidth(columnWidths[x]);
        }
        for (x = 0; x < tableToModelIndex.length; ++x) {
            tcm.addColumn(tcms[tableToModelIndex[x]]);
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showColoredRows")) {
            this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
            this.modelTable.fireTableDataChanged();
        }
    }

    private class ShowColoredLinesRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, SentMessagesTableFormat.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    private class ShowContentTooltipRenderer
    extends ShowColoredLinesRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            if (value != null && (tooltip = value.toString()).length() == 0) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class SubjectRenderer
    extends ShowContentTooltipRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                this.setForeground(Color.BLACK);
                SentMessagesTableItem item = (SentMessagesTableItem)SentMessagesTableFormat.this.modelTable.getItemAt(row);
                if (item != null && item.getFrostMessageObject().containsAttachments()) {
                    this.setForeground(Color.BLUE);
                }
            }
            return this;
        }
    }

    private class BoardComparator
    implements Comparator {
        private BoardComparator() {
        }

        public int compare(Object o1, Object o2) {
            String i1 = ((SentMessagesTableItem)o1).getBoardName();
            String i2 = ((SentMessagesTableItem)o2).getBoardName();
            return i1.compareTo(i2);
        }
    }

    private class SubjectComparator
    implements Comparator {
        private SubjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            String i1 = ((SentMessagesTableItem)o1).getSubject();
            String i2 = ((SentMessagesTableItem)o2).getSubject();
            return i1.compareTo(i2);
        }
    }

    private class FromComparator
    implements Comparator {
        private FromComparator() {
        }

        public int compare(Object o1, Object o2) {
            String i1 = ((SentMessagesTableItem)o1).getFrom();
            String i2 = ((SentMessagesTableItem)o2).getFrom();
            return i1.compareTo(i2);
        }
    }

    private class ToComparator
    implements Comparator {
        private ToComparator() {
        }

        public int compare(Object o1, Object o2) {
            String i1 = ((SentMessagesTableItem)o1).getTo();
            String i2 = ((SentMessagesTableItem)o2).getTo();
            return i1.compareTo(i2);
        }
    }

    private class DateComparator
    implements Comparator {
        private DateComparator() {
        }

        public int compare(Object o1, Object o2) {
            String i1 = ((SentMessagesTableItem)o1).getDateAndTimeString();
            String i2 = ((SentMessagesTableItem)o2).getDateAndTimeString();
            return i1.compareTo(i2);
        }
    }
}

