/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.unsentmessages;

import frost.Core;
import frost.gui.unsentmessages.UnsentMessagesTable;
import frost.messages.FrostUnsentMessageObject;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnsentMessagesPanel
extends JPanel
implements LanguageListener {
    Language language = Language.getInstance();
    private UnsentMessagesTable unsentMessagesTable;
    private JLabel unsentMsgsLabel;
    private JCheckBox disableMessageUpload;
    private boolean isShown = false;

    public UnsentMessagesPanel() {
        this.language.addLanguageListener(this);
        this.initialize();
        this.refreshLanguage();
    }

    public synchronized void prepareForShow() {
        this.loadTableModel();
        this.isShown = true;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public synchronized void cleanupAfterLeave() {
        this.clearTableModel();
        this.isShown = false;
    }

    public synchronized void addUnsentMessage(FrostUnsentMessageObject i) {
        if (this.isShown) {
            this.unsentMessagesTable.addUnsentMessage(i);
        }
    }

    public synchronized void removeUnsentMessage(FrostUnsentMessageObject i) {
        if (this.isShown) {
            this.unsentMessagesTable.removeUnsentMessage(i);
        }
    }

    public synchronized void updateUnsentMessage(FrostUnsentMessageObject i) {
        if (this.isShown) {
            this.unsentMessagesTable.updateUnsentMessage(i);
        }
    }

    public void updateUnsentMessagesCount() {
        this.refreshLanguage();
    }

    public void clearTableModel() {
        this.unsentMessagesTable.clearTableModel();
    }

    public void loadTableModel() {
        this.unsentMessagesTable.loadTableModel();
    }

    public void saveTableFormat() {
        this.unsentMessagesTable.saveTableFormat();
    }

    public void refreshLanguage() {
        this.unsentMsgsLabel.setText(this.language.getString("UnsentMessages.label") + " (" + this.unsentMessagesTable.getRowCount() + ")");
        this.disableMessageUpload.setText(this.language.getString("UnsentMessages.disableMessageUpload"));
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.unsentMsgsLabel = new JLabel();
        this.unsentMsgsLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.disableMessageUpload = new JCheckBox();
        this.disableMessageUpload.setBorder(BorderFactory.createEmptyBorder(2, 16, 2, 2));
        this.disableMessageUpload.setSelected(Core.frostSettings.getBoolValue("messageUploadDisabled"));
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(this.unsentMsgsLabel);
        p.add(this.disableMessageUpload);
        this.add((Component)p, "North");
        this.unsentMessagesTable = new UnsentMessagesTable();
        this.unsentMessagesTable.getScrollPane().setWheelScrollingEnabled(true);
        this.add((Component)this.unsentMessagesTable.getScrollPane(), "Center");
        Font font = this.unsentMsgsLabel.getFont();
        font = font.deriveFont(1);
        this.unsentMsgsLabel.setFont(font);
        this.disableMessageUpload.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Core.frostSettings.setValue("messageUploadDisabled", UnsentMessagesPanel.this.disableMessageUpload.isSelected());
            }
        });
    }
}

