/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.unsentmessages;

import frost.gui.unsentmessages.UnsentMessagesTableItem;
import frost.messages.FrostUnsentMessageObject;
import frost.messages.UnsentMessagesManager;
import frost.util.model.ModelItem;
import frost.util.model.SortedModel;
import frost.util.model.SortedTableFormat;
import java.util.List;

public class UnsentMessagesTableModel
extends SortedModel {
    public UnsentMessagesTableModel(SortedTableFormat f) {
        super(f);
    }

    public void loadTableModel() {
        List<FrostUnsentMessageObject> msgs = UnsentMessagesManager.getUnsentMessages();
        for (FrostUnsentMessageObject mo : msgs) {
            UnsentMessagesTableItem item = new UnsentMessagesTableItem(mo);
            this.addUnsentMessageItem(item);
        }
    }

    public void addUnsentMessageItem(UnsentMessagesTableItem item) {
        this.addItem(item);
    }

    public void addFrostUnsentMessageObject(FrostUnsentMessageObject mo) {
        UnsentMessagesTableItem item = new UnsentMessagesTableItem(mo);
        this.addUnsentMessageItem(item);
    }

    public void removeFrostUnsentMessageObject(FrostUnsentMessageObject mo) {
        for (int x = 0; x < this.getItemCount(); ++x) {
            UnsentMessagesTableItem i = (UnsentMessagesTableItem)this.getItemAt(x);
            if (!i.getFrostUnsentMessageObject().getMessageId().equals(mo.getMessageId())) continue;
            this.removeItems(new ModelItem[]{i});
            return;
        }
    }

    public void updateFrostUnsentMessageObject(FrostUnsentMessageObject mo) {
        for (int x = 0; x < this.getItemCount(); ++x) {
            UnsentMessagesTableItem i = (UnsentMessagesTableItem)this.getItemAt(x);
            if (!i.getFrostUnsentMessageObject().getMessageId().equals(mo.getMessageId())) continue;
            i.fireChange();
            return;
        }
    }

    public FrostUnsentMessageObject deleteItems(ModelItem[] selectedItems) {
        for (int x = 0; x < selectedItems.length; ++x) {
            UnsentMessagesTableItem item = (UnsentMessagesTableItem)selectedItems[x];
            if (!UnsentMessagesManager.deleteMessage(item.getFrostUnsentMessageObject())) {
                return item.getFrostUnsentMessageObject();
            }
            super.removeItems(new ModelItem[]{item});
        }
        return null;
    }
}

