/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.messages.Attachment;
import frost.util.CopyToClipboardItem;
import frost.util.XMLTools;
import java.io.File;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class FileAttachment
extends Attachment
implements CopyToClipboardItem {
    private File file = null;
    private String key = null;
    private long size = 0L;
    private String filename = new String();

    public int getType() {
        return 0;
    }

    public Element getXMLElement(Document doc) {
        Element fileelement = doc.createElement("File");
        Element element = doc.createElement("name");
        CDATASection cdata = doc.createCDATASection(this.getFilename());
        element.appendChild(cdata);
        fileelement.appendChild(element);
        element = doc.createElement("size");
        Text textnode = doc.createTextNode("" + this.getFileSize());
        element.appendChild(textnode);
        fileelement.appendChild(element);
        element = doc.createElement("key");
        textnode = doc.createTextNode(this.getKey());
        element.appendChild(textnode);
        fileelement.appendChild(element);
        element = doc.createElement("Attachment");
        element.setAttribute("type", "file");
        element.appendChild(fileelement);
        return element;
    }

    public void loadXMLElement(Element e) throws SAXException {
        Element _file = XMLTools.getChildElementsByTagName(e, "File").iterator().next();
        this.filename = XMLTools.getChildElementsCDATAValue(_file, "name");
        this.key = XMLTools.getChildElementsTextValue(_file, "key");
        this.size = new Long(XMLTools.getChildElementsTextValue(_file, "size"));
    }

    public FileAttachment(Element e) throws SAXException {
        this.loadXMLElement(e);
    }

    public FileAttachment(String fname, String k, long s) {
        this.filename = fname;
        this.size = s;
        this.key = k;
    }

    public FileAttachment(File newFile, String k, long s) {
        this.file = newFile;
        this.filename = this.file.getName();
        this.size = s;
        this.key = k;
    }

    public FileAttachment(File f) {
        this.file = f;
        this.filename = this.file.getName();
        this.size = this.file.length();
    }

    public int compareTo(Object o) {
        String myName = this.getFilename();
        String otherName = ((FileAttachment)o).getFilename();
        return myName.compareTo(otherName);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String k) {
        this.key = k;
    }

    public long getFileSize() {
        return this.size;
    }

    public File getInternalFile() {
        return this.file;
    }
}

