/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.identities.Identity;
import frost.messages.Attachment;
import frost.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PersonAttachment
extends Attachment {
    private Identity identity;

    public PersonAttachment(Element e) throws SAXException {
        this.loadXMLElement(e);
    }

    public PersonAttachment(Identity newIdentity) {
        this.identity = newIdentity;
    }

    public int compareTo(Object o) {
        String myKey = this.identity.getPublicKey();
        String otherKey = ((PersonAttachment)o).getIdentity().getPublicKey();
        return myKey.compareTo(otherKey);
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public int getType() {
        return 2;
    }

    public Element getXMLElement(Document container) {
        Element el = container.createElement("Attachment");
        el.setAttribute("type", "person");
        el.appendChild(this.identity.getXMLElement(container));
        return el;
    }

    public void loadXMLElement(Element e) throws SAXException {
        Element _person = XMLTools.getChildElementsByTagName(e, "Identity").iterator().next();
        this.identity = Identity.createIdentityFromXmlElement(_person);
    }
}

