/*
 * Decompiled with CFR 0.152.
 */
package frost.storage;

import frost.identities.Identity;
import frost.util.Mixed;
import frost.util.XMLTools;
import frost.util.XMLizable;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitiesXmlDAO {
    private static final Logger logger = Logger.getLogger(IdentitiesXmlDAO.class.getName());

    public static List<Identity> loadIdentities(File file) {
        LinkedList<Identity> identities = new LinkedList<Identity>();
        Document d = XMLTools.parseXmlFile(file, false);
        Element rootEl = d.getDocumentElement();
        List<Element> lists = XMLTools.getChildElementsByTagName(rootEl, "BuddyList");
        for (Element current : lists) {
            Identity id;
            Identity element;
            Iterator<Identity> i$;
            BuddyList buddyList;
            if (current.getAttribute("type").equals("friends")) {
                buddyList = new BuddyList();
                try {
                    buddyList.loadXMLElement(current);
                }
                catch (SAXException e) {
                    logger.log(Level.SEVERE, "Error loading good identities", e);
                }
                i$ = buddyList.getAllValues().iterator();
                while (i$.hasNext()) {
                    id = element = i$.next();
                    id.setGOODWithoutUpdate();
                    identities.add(id);
                }
                continue;
            }
            if (current.getAttribute("type").equals("enemies")) {
                buddyList = new BuddyList();
                try {
                    buddyList.loadXMLElement(current);
                }
                catch (SAXException e) {
                    logger.log(Level.SEVERE, "Error loading bad identities", e);
                }
                i$ = buddyList.getAllValues().iterator();
                while (i$.hasNext()) {
                    id = element = i$.next();
                    id.setBADWithoutUpdate();
                    identities.add(id);
                }
                continue;
            }
            if (current.getAttribute("type").equals("neutral")) {
                buddyList = new BuddyList();
                try {
                    buddyList.loadXMLElement(current);
                }
                catch (SAXException e) {
                    logger.log(Level.SEVERE, "Error loading check identities", e);
                }
                i$ = buddyList.getAllValues().iterator();
                while (i$.hasNext()) {
                    id = element = i$.next();
                    id.setCHECKWithoutUpdate();
                    identities.add(id);
                }
                continue;
            }
            if (!current.getAttribute("type").equals("observed")) continue;
            buddyList = new BuddyList();
            try {
                buddyList.loadXMLElement(current);
            }
            catch (SAXException e) {
                logger.log(Level.SEVERE, "Error loading observe identities", e);
            }
            i$ = buddyList.getAllValues().iterator();
            while (i$.hasNext()) {
                id = element = i$.next();
                id.setOBSERVEWithoutUpdate();
                identities.add(id);
            }
        }
        return identities;
    }

    public static int saveIdentities(File file, List<Identity> identities) {
        BuddyList friends = new BuddyList();
        BuddyList observed = new BuddyList();
        BuddyList enemies = new BuddyList();
        int count = 0;
        for (Identity element : identities) {
            Identity id = element;
            if (id.isGOOD()) {
                friends.add(id);
                ++count;
                continue;
            }
            if (id.isOBSERVE()) {
                observed.add(id);
                ++count;
                continue;
            }
            if (!id.isBAD()) continue;
            enemies.add(id);
            ++count;
        }
        if (count == 0) {
            return count;
        }
        Document d = XMLTools.createDomDocument();
        Element rootElement = d.createElement("FrostIdentities");
        Element friendsElement = friends.getXMLElement(d);
        friendsElement.setAttribute("type", "friends");
        rootElement.appendChild(friendsElement);
        Element enemiesElement = enemies.getXMLElement(d);
        enemiesElement.setAttribute("type", "enemies");
        rootElement.appendChild(enemiesElement);
        Element observedElement = observed.getXMLElement(d);
        observedElement.setAttribute("type", "observed");
        rootElement.appendChild(observedElement);
        d.appendChild(rootElement);
        if (XMLTools.writeXmlFile(d, file)) {
            return count;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuddyList
    implements XMLizable {
        private HashMap<String, Identity> hashMap = new HashMap(100);

        void clearAll() {
            this.hashMap.clear();
        }

        public synchronized boolean add(Identity user) {
            String str = user.getUniqueName();
            if (this.containsKey(str)) {
                return false;
            }
            this.hashMap.put(str, user);
            return true;
        }

        public boolean containsKey(String key) {
            return this.hashMap.containsKey(Mixed.makeFilename(key));
        }

        @Override
        public synchronized Element getXMLElement(Document doc) {
            Element main = doc.createElement("BuddyList");
            for (Identity id : this.hashMap.values()) {
                Element el = id.getExportXMLElement(doc);
                main.appendChild(el);
            }
            return main;
        }

        @Override
        public void loadXMLElement(Element el) throws SAXException {
            if (el == null) {
                return;
            }
            for (Element idEl : XMLTools.getChildElementsByTagName(el, "Identity")) {
                Identity id = Identity.createIdentityFromXmlElement(idEl);
                if (id == null) continue;
                this.add(id);
            }
        }

        protected Object remove(String key) {
            return this.hashMap.remove(Mixed.makeFilename(key));
        }

        public int size() {
            return this.hashMap.size();
        }

        public Collection<Identity> getAllValues() {
            return this.hashMap.values();
        }
    }
}

